###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_pidgin_msnslp_dos_vuln_lin.nasl 6723 2010-01-14 24:48:17Z jan $
#
# Pidgin MSN Protocol Plugin Denial Of Service Vulnerability (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800424);
  script_version("$Revision: 7922 $: 1.0");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2010-0277");
  script_name("Pidgin MSN Protocol Plugin Denial Of Service Vulnerability (Linux)");
  desc = "
  Overview: This host has Pidgin installed and is prone to Denial Of Service
  vulnerability

  Vulnerability Insight:
  This issue is caused due to error in 'slp.c' within the 'MSN protocol plugin'
  in 'libpurple' when processing MSN request.

  Impact:
  Attackers can exploit this issue to cause a denial of service (memory corruption)
  or possibly have unspecified other impact via unknown vectors.

  Impact Level: Application

  Affected Software/OS:
  Pidgin version prior to 2.6.4 on Linux.

  Fix: Upgrade to Pidgin version 2.6.6 or later.
  For updates refer, http://www.pidgin.im/download/

  References:
  http://www.openwall.com/lists/oss-security/2010/01/07/2
  http://cve.mitre.org/cgi-bin/cvename.cgi?name=2010-0277

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score  : 3.7
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Pidgin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_pidgin_detect_lin.nasl");
  script_require_keys("Pidgin/Lin/Ver");
  exit(0);
}


include("version_func.inc");

pidginVer = get_kb_item("Pidgin/Lin/Ver");
if(pidginVer != NULL)
{
  if(version_is_less_equal(version:pidginVer, test_version:"2.6.4")){
    security_warning(0);
  }
}
