###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_vlc_media_player_bof_vuln_lin_mar09.nasl 1115 2009-03-25 16:52:02Z mar $
#
# VLC Media Player Stack Overflow Vulnerability (Lin-Mar09)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900531);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1045");
  script_bugtraq_id(34126);
  script_name("VLC Media Player Stack Overflow Vulnerability (Lin-Mar09)");
  desc = "

  Overview: This host is installed with VLC Media Player and is prone to
  Stack Overflow Vulnerability.

  Vulnerability Insight:
  This flaw is due to improper boundary checking in status.xml in the web
  interface by an overly long request.

  Impact:
  Successful exploitation allows the attacker to execute arbitrary codes
  with escalated privileges and cause overflow in stack.

  Impact Level: Application

  Affected Software/OS:
  VLC media player 0.9.8a and prior on Linux.

  Fix: Upgrade to VLC media player version 1.0 or later,
  For updates refer, http://www.videolan.org/vlc

  References:
  http://www.milw0rm.com/exploits/8213
  http://xforce.iss.net/xforce/xfdb/49249
  http://bugs.gentoo.org/show_bug.cgi?id=262708
  http://www.openwall.com/lists/oss-security/2009/03/17/4

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the Version of VLC Media Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_vlc_media_player_detect_lin.nasl");
  script_require_keys("VLCPlayer/Lin/Ver");
  exit(0);
}


include("version_func.inc");

vlcVer = get_kb_item("VLCPlayer/Lin/Ver");
if(!vlcVer){
  exit(0);
}

if(version_is_less_equal(version:vlcVer, test_version:"0.9.8a")){
  security_hole(0);
}
