#! /usr/bin/perl -w
##
## test Opt.pm

use Opt qw(:DEFAULT optrega_INT optreg_INTLEVEL optreg optrega);

## Very un-perl-ish to declare your variables up front!
## But remember, these are your main option parameters.

$xflag=0;
$zvalu=99;
$verbose=0;

%OPTS = (msg => "hello",
	 "y" => 0,
	 );

## Look at all these different ways to register options!

optrega_INT( \$n,          "N",  "",     "Number");
optreg( \$OPTS{msg},  "STRING",  "m",          "Message");
Opt::register("-y",\%OPTS);
optrega(\$xflag,"ABSFLAG",    "x", "xflag", "long X-flag");
optrega(\$zvalu,"INT",     "",  "zvalu", "value of Z");
optreg_INTLEVEL(\$verbose, "v",          "verbose");

Opt::useEnvString("TOPT_OPTIONS");
Opt::useMainFcn(\&mymain);



Opt::getoptions(["--wvalue=FLOAT","Value of w",\$w],
	   ["-cINT"],
	   );

&mymain(@ARGV);

sub mymain {
    my @argv=@_;
    print "n=$n\n" if defined($n);
    print "m=$OPTS{msg}\n";
    print "x=$xflag\n";
    print "y=$OPTS{'y'}\n";
    print "z=$zvalu\n";
    print "OPT{c}=c=",$OPT{"c"},"\n" if $OPT{"c"};
    print "c=",$Opt::OPT{"c"},"\n" if $Opt::OPT{"c"};
    print "v=$verbose\n";
    print "w=",$w,"\n" if $w;
    
    print "ARGV=",join(" ",@argv),"\n";

    print "OPT=",join(" ",%OPT),"\n";
    print "OPT=",join(" ",%Opt::OPT),"\n";
}

__END__

    
