dnl
dnl	ORBit-C++: C++ bindings for ORBit.
dnl
dnl	Copyright (C) 2000 Andreas Kloeckner
dnl
dnl	This library is free software; you can redistribute it and/or
dnl	modify it under the terms of the GNU Library General Public
dnl	License as published by the Free Software Foundation; either
dnl	version 2 of the License, or (at your option) any later version.
dnl
dnl	This library is distributed in the hope that it will be useful,
dnl	but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl	Library General Public License for more details.
dnl
dnl	You should have received a copy of the GNU Library General Public
dnl	License along with this library; if not, write to the Free
dnl	Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl
dnl	Author: Andreas Kloeckner <ak@ixion.net>
dnl




AC_DEFUN(ORBITCPP_CHECK_BAD_CAST,[
  AC_MSG_CHECKING([whether c++ compiler ($CXX) supports bad_cast])
  AC_LANG_SAVE
  AC_LANG_CPLUSPLUS
  AC_TRY_COMPILE([#include <exception>],[ bad_cast a; ],
    cxx_supports_bad_cast=yes,
    cxx_supports_bad_cast=no)
  AC_LANG_RESTORE
  AC_MSG_RESULT($cxx_supports_bad_cast)
  if test "$cxx_supports_bad_cast" = "yes" ; then
    AC_DEFINE(ORBITCPP_HAVE_BAD_CAST,1,[Whether C++ compiler knows of bad_cast])
  fi
])

AC_DEFUN(ORBITCPP_CHECK_ORBIT_IDL_SUPPORTS_BACKENDDIR,[
  AC_MSG_CHECKING([whether orbit-idl supports --backenddir])
  if orbit-idl --help | grep -q backenddir; then
	orbit_idl_supports_backenddir=true
	AC_MSG_RESULT("yes")
  else
	orbit_idl_supports_backenddir=false
    AC_MSG_RESULT("no")
    echo "*** Your copy of orbit-idl doesn't support --backenddir"
    echo "*** This means that you will have to install the C++ idl compiler back-end"
    echo "*** (with 'make install') before you can build the tests."
  fi
  AM_CONDITIONAL(HAVE_ORBIT_IDL_BACKENDDIR,test "$orbit_idl_supports_backenddir" = "true")
])
