#include "test.hh"
#include <iostream>
#include <fstream>
#include <string>
#include "basic-cpp.hh"

using namespace std;


struct Callback_impl : public POA_Test::Callback {
	int Calls;
	CORBA::Long Identifier;
	
	Callback_impl(long identifier)
		: Calls(0),Identifier(identifier) {
	}
	CORBA::Long call() throw(CORBA::SystemException){
		Calls++;
		return Identifier;
	}
};




BEGIN_TEST {
	// initialize orb
	CORBA::ORB_var orb = CORBA::ORB_init(argc, argv, "orbit-local-orb");
	PASSED
	
	// convert object reference
	ifstream in("iorfile");
	string ior;
	in >> ior;
	CORBA::Object_var head_ = orb->string_to_object(ior.c_str());
	PASSED
  
	Test::Head_var head = Test::Head::_narrow(head_);
	PASSED

    // initialize the root POA and activate the corresponding manager
	CORBA::Object_var poa_ = orb->resolve_initial_references("RootPOA");
	PASSED
  
	PortableServer::POA_var poa = PortableServer::POA::_narrow(poa_);
	PASSED
  
	PortableServer::POAManager_var pm = poa->the_POAManager();
	PASSED
  
	pm->activate();
	PASSED
  
	// test simple types
	const CORBA::Long value = 3400;
	CORBA::Long p1 = value*2,p2;
	
	TEST(head->returnHalf(value,p1,p2) == value / 2);
	TEST(p1 == value*4);
	TEST(p2 == value/4);
	
	// test string type
	char *rev_too = CORBA::string_dup("The word ANAGRAM is no ANAGRAM");
	char *halved;
	char *reversed = head->returnReverse("xaler tsuj",rev_too,halved);
	TEST(!strcmp(reversed,"just relax"))
	TEST(!strcmp(halved,"xaler"))
	TEST(!strcmp(rev_too,"MARGANA on si MARGANA drow ehT"))
	
	// test exceptions
	try {
	  head->throwException();
	  FAILED
	  }
	catch (Test::Base::Failure &ex) {
//		if (!strcmp(ex.Reason,"DIG THIS") && ex.AnotherReason == (int) 0xdeadbeef)
			PASSED
//		else
//			FAILED
	}
	
	// test object reference passing
	Callback_impl cbi1(1);
	
	PortableServer::ObjectId_var oid = poa->activate_object(&cbi1);
	PASSED
	CORBA::Object_var co = poa->id_to_reference(oid);
	PASSED
	Test::Callback_var cb1 = Test::Callback::_narrow(co);
	PASSED
	
	Callback_impl cbi2(2);
	
	oid = poa->activate_object(&cbi2);
	co = poa->id_to_reference(oid);
	Test::Callback_var cb2 = Test::Callback::_narrow(co);
	PASSED
	
	Test::Callback_var cb3;
	Test::Callback_var cb4 =
	  head->getCallback(cb1,cb2,cb3);
	PASSED
	
	TEST(cbi1.Calls == 1);
	TEST(cbi2.Calls == 1);
	cb2->call();
	cb3->call();
	cb4->call();
	cout << "got to here\n";
	TEST(head->verifyAndExit());
	cout << "got to here2\n";
} END_TEST
