/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.javagroups.Address;
import org.javagroups.JChannel;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.protocols.BSH;
import org.javagroups.stack.IpAddress;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Bsh {
    String host;
    int port;
    long timeout;
    String props;
    JChannel ch;

    public void start(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            String tmp = args[i];
            if (tmp.equals("-props")) {
                this.props = args[++i];
            } else if (tmp.equals("-host")) {
                this.host = args[++i];
            } else if (tmp.equals("-port")) {
                this.port = Integer.parseInt(args[++i]);
            } else if (tmp.equals("-timeout")) {
                this.timeout = Long.parseLong(args[++i]);
            } else {
                this.help();
                return;
            }
            ++i;
        }
        Trace.init();
        this.runClient();
    }

    void runClient() throws Exception {
        this.ch = new JChannel(this.props);
        this.ch.connect(null);
        IpAddress addr = new IpAddress(this.host, this.port);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        block0: while (true) {
            BSH.BshHeader hdr;
            Message msg;
            System.out.print("> ");
            String line = reader.readLine();
            if (line.startsWith("quit") || line.startsWith("exit")) {
                this.ch.close();
                return;
            }
            if (line.startsWith("get")) {
                int i = 1;
                while (true) {
                    if (this.ch.getNumMessages() <= 0) continue block0;
                    Object obj = this.ch.receive(1000L);
                    System.out.println("#" + i++ + ": " + this.print(obj) + ", obj=" + obj);
                }
            }
            if (line.startsWith("destroyInterpreter")) {
                msg = new Message((Address)addr, null, line.getBytes());
                hdr = new BSH.BshHeader(1);
                msg.putHeader("BSH", hdr);
                this.sendAndReceive(msg, 1000L);
                continue;
            }
            msg = new Message((Address)addr, null, line.getBytes());
            hdr = new BSH.BshHeader(1);
            msg.putHeader("BSH", hdr);
            this.sendAndReceive(msg, this.timeout);
        }
    }

    Object print(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Message) {
            return ((Message)obj).getObject();
        }
        return obj;
    }

    void sendAndReceive(Message msg, long timeout) {
        try {
            this.ch.send(msg);
            Object obj = this.ch.receive(timeout);
            if (obj == null || !(obj instanceof Message)) {
                System.err.println("<-- " + obj);
            } else {
                Object result = ((Message)obj).getObject();
                System.out.println("<-- " + result);
            }
        }
        catch (Throwable t) {
            System.err.println("Bsh.sendAndReceive(): " + t);
        }
    }

    void help() {
        System.out.println("Bsh [-help] [-props <props>][-host <host>] [-port <port>] [-timeout <timeout>]");
    }

    public static void main(String[] args) {
        try {
            new Bsh().start(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private final /* synthetic */ void this() {
        this.host = "localhost";
        this.port = 0;
        this.timeout = 0L;
        this.props = null;
    }

    public Bsh() {
        this.this();
    }
}

