
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/******************************************************************************
**
**    File:      ssl_utilities.h
**    Author:    Brian Wotring
**
**    Date:      July 28, 2002.
**    Project:   osiris
**
******************************************************************************/

#ifndef SSL_UTILITIES_H
#define SSL_UTILITIES_H


/* common locations for egd sources. */

#ifndef DEVRANDOM_EGD
#define DEVRANDOM_EGD "/var/run/egd-pool", "/dev/egd-pool", "/etc/egd-pool",\
                      "/etc/entropy"
#endif

#ifndef DEVRANDOM
#define DEVRANDOM "/dev/random"
#endif


#ifdef WIN32
#define FILE_OPEN_READ_FLAGS    "rb"
#else
#define FILE_OPEN_READ_FLAGS    "r"
#endif


int seed_prng( int bytes );

int hash_file_md5( const char *file_path, FILE *file,                        
                   char *buffer, int buffer_size );

int hash_file_sha( const char *file_path, FILE *file,
                   char *buffer, int buffer_size );

int hash_file_ripemd( const char *file_path, FILE *file,
                      char *buffer, int buffer_size );

/* random SSL utilities. */

int osi_write_x509_to_path( X509 *cert, const char *filepath, mode_t mode );
int osi_write_rsa_to_path( RSA *rsa, const char *filepath, mode_t mode );
int osi_write_pkey_to_path( EVP_PKEY *pkey, const char *filepath, mode_t mode );

char * osi_get_x509_fingerprint( X509 *cert, char *buffer, int buffer_size );

#endif
