
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_scan.h
**  Date:    June 3, 2002
**
**  Author:  Brian Wotring
**  Purpose: handle scan contexts, and streams for the management daemon.
**
******************************************************************************/

#ifndef MD_SCAN_H_
#define MD_SCAN_H_

typedef struct OSI_SCAN_CONTEXT
{
    OSI_HOST *host;
    SSL *ssl;
    OSI_SCAN_CONFIG *cfg;

} OSI_SCAN_CONTEXT;


OSI_SCAN_CONTEXT * scan_context_new();
void scan_context_destroy( OSI_SCAN_CONTEXT *context );

void scan_host( const char *name, MESSAGE *res );
void start_scan_handler( OSI_SCAN_CONTEXT *scan_context );

THREAD_FUNCTION_TYPE handle_scan_stream( void *scan_context );
osi_bool store_config_in_db( OSI_SCAN_CONFIG *cfg, OSI_DB *db );


#endif

