/* pal
 *
 * Copyright (C) 2004, Scott Kuhl
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h> /* for getenv() */

#include "main.h"
#include "colorize.h"


int use_colors = -1;  /* -2 = no colors, can't turn them on later if this is set;
			 -1 = don't know;
			 0 = no colors;
			 1 = colors */


/* Sets use_colors variable depending on the terminal type.  This is
   very crude.  */
void color_term()
{
    char *term = getenv("TERM");

    use_colors = 0;  /* don't use colors by default */

    /* use colors if TERM variable is one of the following */
    if( getenv("COLORTERM") != NULL ||
	!g_ascii_strncasecmp(term, "xterm", 5) ||
	!g_ascii_strncasecmp(term, "xterm-color", 11) ||
	!g_ascii_strncasecmp(term, "linux", 5) || /* linux console */
	!g_ascii_strncasecmp(term, "ansi", 4) ||
	!g_ascii_strncasecmp(term, "Eterm", 5) ||
	!g_ascii_strncasecmp(term, "dtterm", 6) || /* Solaris */
 	!g_ascii_strncasecmp(term, "rxvt", 4) || /* rxvt & aterm */
	!g_ascii_strncasecmp(term, "cygwin", 6))
	use_colors = 1;

    /* make sure TERM=dumb didn't slip by with COLORTERM set */
    if(!g_ascii_strncasecmp(term, "dumb", 4))
	use_colors = 0;
}


/* allows user to manually set use_colors variable */
void set_colorize(int in)
{
    if(use_colors != -2)
	use_colors = in;
}

void colorize(int attribute, int foreground, int background, gchar *str)
{
    /* determine use_colors variable if it isn't set yet. */
    if(use_colors == -1)
	color_term();

    /* don't do anything if not using colors */
    if(use_colors == 0 || use_colors == -2)
    {
	*str = '\0';
	return;
    }

    foreground += 30;
    background += 40;

    /* Command is the control command to the terminal */
    sprintf(str, "%c[%d;%d;%dm", 0x1B, attribute, foreground, background);

}

void colorize_fg(int attribute, int foreground, gchar *str)
{
    /* determine use_colors variable if it isn't set yet. */
    if(use_colors == -1)
	color_term();

    /* don't do anything if not using colors */
    if(use_colors == 0 || use_colors == -2)
    {
	*str = '\0';
	return;
    }

    foreground += 30;

    /* Command is the control command to the terminal */
    sprintf(str, "%c[%d;%dm", 0x1B, attribute, foreground);

}

void colorize_attr(int attribute, gchar *str)
{

    /* determine use_colors variable if it isn't set yet. */
    if(use_colors == -1)
	color_term();

    /* don't do anything if not using colors */
    if(use_colors == 0 || use_colors == -2)
    {
	*str = '\0';
	return;
    }

    /* Command is the control command to the terminal */
    sprintf(str, "%c[%dm", 0x1B, attribute);

}

void colorize_reset(gchar *str)
{
    /* determine use_colors variable if it isn't set yet. */
    if(use_colors == -1)
	color_term();

    /* don't do anything if not using colors */
    if(use_colors == 0 || use_colors == -2)
    {
	*str = '\0';
	return;
    }

    sprintf(str, "%c[0m", 0x1B);
}


/* free returned string when done. */
gchar* string_color_of(int color)
{
    switch(color)
    {
	case 0: return g_strdup("black");   break;
	case 1: return g_strdup("red");     break;
	case 2: return g_strdup("green");   break;
	case 3: return g_strdup("yellow");  break;
	case 4: return g_strdup("blue");    break;
	case 5: return g_strdup("magenta"); break;
	case 6: return g_strdup("cyan");    break;
	case 7: return g_strdup("white");   break;
	default: /* when in doubt, use default color */
	    return string_color_of(settings->event_color); break;
    }


}


/* returns -1 on failure to match */
int int_color_of(gchar* string)
{
    string = g_strstrip(string);
    if(g_ascii_strcasecmp(string, "black") == 0)
	return BLACK;
    else if(g_ascii_strcasecmp(string, "red") == 0)
	return RED;
    else if(g_ascii_strcasecmp(string, "green") == 0)
	return GREEN;
    else if(g_ascii_strcasecmp(string, "yellow") == 0)
	return YELLOW;
    else if(g_ascii_strcasecmp(string, "blue") == 0)
	return BLUE;
    else if(g_ascii_strcasecmp(string, "magenta") == 0)
	return MAGENTA;
    else if(g_ascii_strcasecmp(string, "cyan") == 0)
	return CYAN;
    else if(g_ascii_strcasecmp(string, "white") == 0)
	return WHITE;
    else
	return -1;
}
