#include "npconfig.h"

void clist_remove_callback( GtkWidget *widget, gint row, gint col,
                            GdkEvent *event )
{
   if ( event == NULL || event->type != GDK_2BUTTON_PRESS )
      return;

   NP_Config *config =
      ( NP_Config *)gtk_object_get_data( GTK_OBJECT( widget ),
                                         "config" );

   char *server, *group, buffer[ 512 ];;
   gtk_clist_get_text( GTK_CLIST( widget ), row, 0, &group );
   server = ( char *)config->subscription[ config->current_server ];
   if ( server == NULL )
   {
      config->subscription.print_error();
      return;
   }
   
   snprintf( buffer, sizeof buffer, "%s-%s", server, group );
   int r;
   if (( r = config->temp_deleted.add_item( buffer )))
      if ( r != 2 )
         config->temp_deleted.print_error();

   gtk_clist_remove( GTK_CLIST( widget ), row );

   --config->group_clist_lines;

   snprintf( buffer, sizeof buffer, "%d Subscribed Newsgroups",
             config->group_clist_lines );
   gtk_clist_set_column_title( GTK_CLIST( widget ), 0, buffer );

   config->dirty = 1;
   
   return;
}
