#include <signal.h>
#include <unistd.h>

#include "npsummary.h"

void recursively_label( np_thread_node_t *pointer, NP_Summary *summary );

void recursively_request( np_thread_node_t *pointer, int request,
                          NP_Summary *summary, int *feedback_writes )
{
   pointer->descendents = pointer->unseen_descendents =
      pointer->requested_descendents = pointer->header_descendents = 0;

   if ( !pointer->is_article &&
        pointer->is_requested != -1 &&
        pointer->is_requested != request )
   {
      pointer->is_requested = request;

      if ( !summary->is_stdout_a_tty )
      {
         printf( "%s\n%s\n%s\n", summary->server, summary->group,
                 ( request ? "r" : "u" ));
         ++( *feedback_writes );
      }
   }

   if ( !pointer->child_count )
      return;

   pointer = pointer->child_head;

   do
   {
      recursively_request( pointer, request, summary, feedback_writes );
      pointer = pointer->child_next;
   }
   while( pointer != NULL );

   return;
}

void request_current_callback( GtkWidget *widget, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   if ( summary->current_node == NULL ||
        summary->current_node->is_requested == -1 )
   {
      summary->show_message( "No message in the list is selected." );
      return;
   }
   
   int request;
   if ( widget != NULL )
      request = 
         ( int)gtk_object_get_data( GTK_OBJECT( widget ), "request" );
   else
      request = summary->current_node->is_requested ^ 1;

   if ( !summary->current_node->is_article &&
        summary->current_node->is_requested != request )
   {
      summary->current_node->is_requested = request;

      if ( !summary->is_stdout_a_tty )
      {
         printf( "%s\n%s\n%s\n.", summary->server, summary->group,
                 ( request ? "r" : "u" ));
         fflush( stdout );
      }
      
      if ( summary->current_node->child_count )
      {
         summary->current_node->descendents =
            summary->current_node->unseen_descendents =
            summary->current_node->requested_descendents =
            summary->current_node->header_descendents = 0;
         
         summary->threads.recursively_count_descendents(
            &summary->current_node->descendents,
            &summary->current_node->unseen_descendents,
            &summary->current_node->requested_descendents,
            &summary->current_node->header_descendents,
            summary->current_node->child_head );
      }

      char *line = summary->create_tree_entry( summary->current_node );
      gtk_label_set( GTK_LABEL( summary->current_node->label ), line );
      np_thread_node_t *pointer = summary->current_node;
      GtkStyle *style;
      if ( !pointer->is_article )
      {
         if ( pointer->is_requested )
            style = ( pointer->is_unseen ? summary->unread_request_style :
                                           summary->request_style );
         else
            style = ( pointer->is_unseen ?  summary->unread_header_style : 
                                            summary->header_style );
      }
      else if ( pointer->is_article < 0 )
         style = ( pointer->unseen_descendents ? 
               summary->unread_dummy_style : summary->dummy_style );
      else
         style = ( pointer->is_unseen ? summary->unread_style : 
               summary->read_style );

      gtk_widget_set_style( GTK_WIDGET( pointer->label ), style );

      if ( pointer->is_child )
      {
         while( pointer->is_child == 1 )
            pointer = pointer->parent;

         if ( request )
            ++pointer->requested_descendents;
         else
            --pointer->requested_descendents;

         line = summary->create_tree_entry( pointer );
         gtk_label_set( GTK_LABEL( pointer->label ), line );
         GtkStyle *style;
         if ( !pointer->is_article )
         {
            if ( pointer->is_requested )
               style = ( pointer->is_unseen ? summary->unread_request_style :
                                              summary->request_style );
            else
               style = ( pointer->is_unseen ? summary->unread_header_style : 
                                              summary->header_style );
         }
         else if ( pointer->is_article < 0 )
         {
            if ( pointer->unseen_descendents )
               style = summary->unread_dummy_style;
            else
               style = summary->dummy_style;
         }
         else
            style = ( pointer->is_unseen ? summary->unread_style : 
                                           summary->read_style );

         gtk_widget_set_style( GTK_WIDGET( pointer->label ), style );
      }
   }

   return;
}

void request_thread_callback( GtkWidget *widget, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   if ( summary->current_node == NULL )
   {
      summary->show_message( "No message in the list is selected." );
      return;
   }

   int request = ( int)gtk_object_get_data( GTK_OBJECT( widget ), "request" );

   np_thread_node_t *pointer = summary->current_node;
   while( pointer->is_child )
      pointer = pointer->parent;

   int writes = 0;

   recursively_request( pointer, request, summary, &writes );

   if ( pointer->child_count )
      summary->threads.recursively_count_descendents(
         &pointer->descendents, &pointer->unseen_descendents,
         &pointer->requested_descendents, &pointer->header_descendents,
         pointer->child_head );

   recursively_label( pointer, summary );

   if ( writes )
   {
      printf( "." );
      fflush( stdout );
   }

   return;
}

void request_all_callback( GtkWidget *widget, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   if ( summary->tree == NULL )
   {
      summary->show_message( "No message in the list is selected." );
      return;
   }
   
   int request = ( int)gtk_object_get_data( GTK_OBJECT( widget ), "request" );

   for( np_thread_node_t *pointer = summary->tree;
        pointer != NULL;
        pointer = pointer->next )
   {
      if ( pointer->is_article )
         continue;

      pointer->is_requested = request;
   }

   summary->write_read_file();
   
   if ( !summary->is_stdout_a_tty )
      kill( getppid(), SIGUSR1 );

   return;
}


