#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>

#include "npsummary.h"

NP_Summary::~NP_Summary()
{
   write_read_file();
   
   int total = children.get_total();
   if ( total < 0 )
      children.print_error();
   else
      if ( total )
      {
         signal( SIGCHLD, SIG_IGN );
         for( int i = 0; i < total; ++i )
         {
            char *text = ( char *)children[ i ];
            if ( text == NULL )
            {
               children.print_error();
               continue;
            }
            
            pid_t pid = atoi( children[ i ] );
            if ( pid <= 0 )
            {
               children.print_error();
               continue;
            }

            kill( pid, SIGTERM );
            if ( !waitpid( pid, NULL, WNOHANG ))
            {
               sleep( 5 );
               kill( pid, SIGKILL );
            }
         }
      }

   if ( output != NULL )
      fclose( output );

   if ( items != NULL )
      free( items );

   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.npsummary:pid", home );
   remove( buffer );

   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/.current_group",
             home );
   remove( buffer );

   snprintf( buffer, sizeof buffer, "%s/.npsummary:font", home );
   FILE *font_file;
   if (( font_file = fopen( buffer, "w" )) != NULL )
   {
      int i = 1;
      if ( item == first_item )
         i = 0;
      else if ( item == second_item )
         i = 1;
      else if ( item == third_item )
         i = 2;

      fprintf( font_file, "%d\n", i );
      fclose( font_file );
   }

	save_size();

   return;
}
