#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <string.h>
#include <errno.h>

#include "npnews.h"

int NP_News::open_server( char *server )
{
   struct hostent *host;
   struct servent *service;
   struct sockaddr_in server_addr;

   int socket_fd, flags, result;
   
   if (( service = getservbyname( "nntp", "tcp" )) == NULL )
   {
      snprintf( error_message, sizeof error_message,
                "NP_News: open_server(): "
                "getservbyname( \"nntp\", \"tcp\" ) returned error: %s.",
                strerror( errno ));
      return 1;
   }

   if ( ( host = gethostbyname( server )) == NULL )
   {
      snprintf( error_message, sizeof error_message,
                "NP_News: open_server(): "
                "gethostbyname( \"%s\" ) returned error: %s.",
                server, strerror( errno )); 
      return 1;
   }

   if (( socket_fd = socket( PF_INET, SOCK_STREAM, 0 )) == -1 )
   {
      snprintf( error_message, sizeof error_message,
                "NP_News: open_server(): socket() returned error: %s.",
                strerror( errno ));
      return 1;
   }

   memset( &server_addr, 0, sizeof server_addr );
   server_addr.sin_family = AF_INET;

   /* 
    * Both gethostbyname() and getservbyname() return data in network
    * byte-order.
    */ 

   memmove( &server_addr.sin_addr, host->h_addr, host->h_length );
   server_addr.sin_port = service->s_port;

   /*
    * Get the current flags settings for the socket file descriptor,
    */

   if (( flags = fcntl( socket_fd, F_GETFL, 0 )) < 0 )
   {
      close( socket_fd );
      snprintf( error_message, sizeof error_message,
                "NP_News: open_server(): "
                "fcntl() F_GETFL returned error: %s.",
                strerror( errno ));
      return 1;
   }
   
   /*
    * Set the socket non-blocking.
    */

   if ( fcntl( socket_fd, F_SETFL, flags | O_NONBLOCK ) < 0 )
   {
      close( socket_fd );
      snprintf( error_message, sizeof error_message,
                "NP_News: open_server(): "
                "fcntl() F_SETFL returned error: %s.", strerror( errno ));
      return 1;
   }
   
   /*
    * Non-blocking connect.
    */

   if (( result = connect( socket_fd, ( struct sockaddr *)&server_addr,
                           sizeof server_addr )) < 0 )
      if ( errno != EINPROGRESS )
      {
         close( socket_fd );
         snprintf( error_message, sizeof error_message,
                   "NP_News: open_server(): connect() returned error: %s.",
                   strerror( errno ));
         return 1;
      }

   /* 
    * if result is zero, connection has completed immediately.
    */

   fd = socket_fd;

   if ( result )
   {
      /*
       * Wait for connect() to complete.
       */
      
      if ( wait_for_activity( 2 ) )
         return 1;
   }

   return 0;
}



