/*
 * PIMPPA - pmv3
 *
 * Moves files around according to an sql format filename
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <ctype.h>

#include "pimppa.h"

int main(int argc, char *argv[])
{
	char src_path[PATH_MAX];
	char dst_path[PATH_MAX];
	unsigned long src_id, dst_id, dst_context;
	MYSQL *src_db, *dst_db;
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	int files_moved=0;
	char *value;
	int minassnamelen;

	if(argc!=4)
	{
		printf("Usage: %s <source area> <destination area> <pattern>\n", argv[0]);
		return(0);
	}

	src_db=p_connect();
	if(!src_db)
		return(-1);

	dst_db=p_connect();
	if(!dst_db)
		return(-1);

	value=p_getmisc(src_db, P_KEY_MINASSNAMELEN);
	if(value)
		minassnamelen=atoi(value);
	else
		minassnamelen=atoi(P_MIN_ASS_NAMELENGTH);

/************** get source area *****************************/

	p_query(src_db, "SELECT area_id, area_path " 
		 	"FROM p_areas "
			"WHERE area_name='%s'", 
		argv[1]);
	if(mysql_error(src_db)[0])
	{
		fprintf(stderr, "Error: %s\n", mysql_error(src_db));
		return(-1);
	}
	sql_result=mysql_store_result(src_db);
	if(sql_result)
	{
		sql_row=mysql_fetch_row(sql_result);
		if(sql_row)
		{
			src_id=atoi(sql_row[0]);
			strcpy(src_path, sql_row[1]);
			if(!p_checkp(src_path))
				strcat(src_path, "/");
		}
		else
		{
			fprintf(stderr, "Area '%s' not found...\n", argv[1]);
			return(-1);
		}

		mysql_free_result(sql_result);
	}
	else
		return(-2);
	
/************ get destination area ****************/
	
	p_query(src_db, "SELECT area_id, area_path, area_context "
			"FROM p_areas "
			"WHERE area_name='%s'", 
		argv[2]);
	if(mysql_error(src_db)[0])
	{
		fprintf(stderr, "Error: %s\n", mysql_error(src_db));
		return(-1);
	}
	sql_result=mysql_store_result(src_db);
	if(sql_result)
	{
		sql_row=mysql_fetch_row(sql_result);
		if(sql_row)
		{
			dst_id=atoi(sql_row[0]);
			strcpy(dst_path, sql_row[1]);
			if(!p_checkp(dst_path))
				strcat(dst_path, "/");
			dst_context=atoi(sql_row[2]);
		}
		else
		{
			fprintf(stderr, "Area '%s' not found...\n", argv[2]);
			return(-1);
		}

		mysql_free_result(sql_result);
	}
	else
		return(-3);

/************ Ok, move files ****************/

	// Locate source files exists
	p_query(src_db, "SELECT file_name FROM p_files "
			"WHERE file_name like '%s' AND file_area=%ld",
		argv[3], src_id);
	if(mysql_error(src_db)[0])
	{
		fprintf(stderr, "Err: %s\n", mysql_error(src_db));
		return(-4);
	}
	sql_result=mysql_use_result(src_db);
	if(!sql_result)
		return(-1);

	while((sql_row=mysql_fetch_row(sql_result)))
	{
		char fullsrc[PATH_MAX];
		char escaped_fn[2*P_LEN_FILE_NAME+1];

		mysql_escape_string(escaped_fn, sql_row[0], strlen(sql_row[0]));

		// Mercilessly delete the destination file, if exists
		p_query(dst_db, "DELETE FROM p_files "
				"WHERE file_name='%s' AND file_area=%ld",
			escaped_fn, dst_id);

		// Ok, move it
		p_query(dst_db, "UPDATE p_files SET file_area=%ld "
				"WHERE file_name='%s' AND file_area=%ld",
			dst_id, escaped_fn, src_id);
		if(mysql_error(dst_db)[0])
		{
			fprintf(stderr, "Err: %s\n", mysql_error(dst_db));
			return(-5);
		}

		sprintf(fullsrc, "%s%s", src_path, sql_row[0]);
		if(!p_mv(fullsrc, dst_path))
		{
			fprintf(stderr, "p_mv() error from %s to %s\n",
					fullsrc, dst_path);
			break;
		}
	
		p_assign(dst_db, sql_row[0], minassnamelen, dst_id, dst_context);

		files_moved++;
	}

	mysql_free_result(sql_result);

	mysql_close(src_db);
	mysql_close(dst_db);

	if(files_moved)
		fprintf(stderr, "%d files moved...\n", files_moved);

	return(0);
}
			
