/* ppxp-object.c -- ǣԣˡ УУХ֥
 *
 * եΥɤʬToru OGAWA <toru@ele.eng.osaka-u.ac.jp>
 * gtkppxp˴ޤޤƤppxpinterface.cƱǤ
 * Yurika <yurika@po.gws.ne.jp>֥Ȳޤ
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <xcio.h>
#include <ppxp.h>
#include "ppxp-object.h"

static void ppxp_class_init(PpxpClass *class);
static void ppxp_init(Ppxp *ppxp);
static void ppxp_destroy(GtkObject *object);
static void ppxp_update(Ppxp *ppxp, unsigned char *xcbuf);
static void ppxp_check(Ppxp *ppxp, gint fd, GdkInputCondition condition);

enum {
    CHANGED,
    LAST_SIGNAL
};

static gint ppxp_signals[LAST_SIGNAL] = { 0 };

guint
ppxp_get_type(void) {
  static guint ppxp_type = 0;

  if(!ppxp_type) {
      GtkTypeInfo ppxp_info = {
          "Ppxp",
          sizeof(Ppxp),
          sizeof(PpxpClass),
          (GtkClassInitFunc)  ppxp_class_init,
          (GtkObjectInitFunc) ppxp_init,
          /* reserved_1 */ NULL,
          /* reserved_2 */ NULL,
          (GtkClassInitFunc) NULL
      };
      ppxp_type = gtk_type_unique(GTK_TYPE_DATA, &ppxp_info);
  }
  return ppxp_type;
}

static void
ppxp_class_init(PpxpClass *class)
{
    GtkObjectClass *object_class;
    GtkDataClass *data_class;
    
    object_class = (GtkObjectClass *) class;
    data_class   = (GtkDataClass *) class;
    
    ppxp_signals[CHANGED] = gtk_signal_new("changed",
                                           GTK_RUN_FIRST,
                                           object_class->type,
                                           GTK_SIGNAL_OFFSET(PpxpClass, changed),
                                           gtk_signal_default_marshaller, GTK_TYPE_NONE, 0);
    
    gtk_object_class_add_signals (object_class, ppxp_signals, LAST_SIGNAL);

    class->changed = NULL;
    data_class->disconnect = NULL;
    object_class->destroy  = ppxp_destroy;
}

static void
ppxp_init(Ppxp *ppxp)
{
    gint argc = 1;
    gchar *argv[] = { NULL ,"" };
    
    argv[0] = g_strdup (g_get_prgname());
    ppxp->can_use = TRUE;
    ppxp->tag = 0;
    ppxp->fd = PPxPSetup(&argc, argv);
    g_free (argv[0]);
    if(ppxp->fd < 0) {
        ppxp->can_use = FALSE;
        return;
    }
    
    ppxp->tag = gdk_input_add( ppxp->fd,
                               GDK_INPUT_READ,
                               (GdkInputFunction)ppxp_check, ppxp);
    PPxPAutoUpdate(ppxp->fd, TRUE);
}

Ppxp *
ppxp_new(void)
{
    Ppxp *ppxp;
    
    ppxp = gtk_type_new(ppxp_get_type());
    if( !ppxp->can_use ) {
        gtk_object_destroy(GTK_OBJECT(ppxp));
        return (Ppxp *)NULL;
    }
    return ppxp;
}

void
ppxp_disconnect(Ppxp *ppxp)
{
    PPxPCommandv( ppxp->fd, XCMD_DISCONNECT,NULL);
}

void
ppxp_connect(Ppxp *ppxp)
{
    PPxPCommandv( ppxp->fd, XCMD_CONNECT,NULL);
}

void ppxp_bye(Ppxp *ppxp)
{
    PPxPCommandv( ppxp->fd, XCMD_BYE, NULL );
}

void
ppxp_quit(Ppxp *ppxp)
{
    PPxPCommandv( ppxp->fd, XCMD_QUIT, NULL );
}

void
ppxp_source(Ppxp *ppxp, gchar *source)
{
  PPxPCommandv( ppxp->fd, XCMD_SOURCE, source, NULL );
}

void
ppxp_toggle_auto (Ppxp *ppxp)
{
    if( ppxp->if_auto ) {
        PPxPCommandv( ppxp->fd, XCMD_AUTO, "off", NULL);
    } else {
        PPxPCommandv( ppxp->fd, XCMD_AUTO, NULL);
    }
}

void
ppxp_auto(Ppxp *ppxp, gboolean auto_on)
{
    if(auto_on)
        PPxPCommandv( ppxp->fd, XCMD_AUTO, NULL);
    else
        PPxPCommandv( ppxp->fd, XCMD_AUTO, "off", NULL);
}

gchar *
ppxp_getenv(Ppxp *ppxp, gchar *env){
    xcmd_t xid;
    
    xid = PPxPEnvRequestv(ppxp->fd, env, NULL);
    return PPxPEnvGet(ppxp->fd, xid);
}

void
ppxp_passwd(Ppxp *ppxp, gchar *entry, gchar *name, gchar *key)
{
    PPxPwdSet(ppxp->fd, entry, name, key);
}

static void
ppxp_destroy(GtkObject *object) {
    Ppxp *ppxp;

    ppxp = PPXP(object);
    
    gtk_signal_emit_by_name(GTK_OBJECT(ppxp), "disconnect");
    
    if (ppxp->can_use)
        ppxp_bye (ppxp);
  
    XcioClose (ppxp->fd);
    
    if (ppxp->tag)
        gdk_input_remove (ppxp->tag);
}

static void
ppxp_update(Ppxp *ppxp, guchar *xcbuf)
{
    gint if_chat, if_estab, if_line, if_auth, if_net;
    gint if_auto;
    gint stat;
    struct pppinfo_s pppinfo;
    static struct pppinfo_s pppInfo;

    memcpy(&pppinfo, xcbuf, sizeof(pppinfo));

    /* ? */
    if_chat = (pppinfo.l_stat & (LSTAT_CHAT|LSTAT_DIAL));
    if_estab = (pppinfo.phase >= PS_ESTABLISH);
    if_line = pppinfo.l_stat & LSTAT_PPP;
    if_auth = pppinfo.phase > PS_ESTABLISH;
    if( pppinfo.n_stat ) {
        if_net = 1;
    } else {
        if_net = 0;
    };

    /* ? 2 */
    stat = 0;
    if( (if_chat | if_estab) ){ stat = 1; };
    if( if_line ){ stat = 2; };
    if( if_auth ){ stat = 3; };
    if( if_net && if_auth ){ stat = 4; };
    ppxp->stat = stat;
    
    if( stat != 4 )
      pppinfo.idle = 0;
    
    if( stat > 1 ){
        ppxp->connect = pppinfo.connect;
        ppxp->idle    = pppinfo.idle;
    } else {
        ppxp->connect = 0;
        ppxp->idle    = 0;
    };
    
    /* AUTO ON ɤ ON  TRUE 餷 */
    if_auto = pppinfo.m_flag & MFLAG_AUTO;
    ppxp->if_auto = if_auto ? TRUE : FALSE;
    
    /* ᡼ */
    ppxp->inrate  = pppinfo.r.nsize - pppInfo.r.nsize;
    ppxp->outrate = pppinfo.s.nsize - pppInfo.s.nsize;
    
    if(ppxp->inrate  <= 0){ ppxp->inrate  = 0; };
    if(ppxp->outrate <= 0){ ppxp->outrate = 0; };
    
    memcpy(&pppInfo, xcbuf, sizeof(pppInfo));
    
    gtk_signal_emit(GTK_OBJECT(ppxp), ppxp_signals[CHANGED]);
}

static void
ppxp_check(Ppxp *ppxp, gint fd, GdkInputCondition condition )
{
    gint n;
    struct xcio_s xc;
    
    n = PPxPRead(ppxp->fd, XID_ANY, &xc);
    if( n > 0 ){
        switch(xc.type) {
        case XCIO_UP_ENVS:
            break;
            
        case XCIO_UP_INFO:
            ppxp_update(ppxp,xc.buf);
            break;
            
        case XCIO_S_OUT:
            break;
            
        case XCIO_ENV_SET:
            break;
            
        case XCIO_RETURN:
            break;

        default:
        }
    } else if( n < 0 ){
        ppxp->can_use = FALSE;
        gtk_signal_emit_by_name(GTK_OBJECT(ppxp),"disconnect");
        gtk_object_destroy(GTK_OBJECT(ppxp));
    }
}
