/* $Id: ImageSprite.java,v 1.7 2005/06/11 13:13:15 eric Exp $
 *
 * ProGuard -- shrinking, optimization, and obfuscation of Java class files.
 *
 * Copyright (c) 2002-2005 Eric Lafortune (eric@graphics.cornell.edu)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package proguard.gui.splash;

import java.awt.*;

/**
 * This Sprite represents an animated image.
 *
 * @author Eric Lafortune
 */
public class ImageSprite implements Sprite
{
    private Image          image;
    private VariableInt    x;
    private VariableInt    y;
    private VariableDouble scaleX;
    private VariableDouble scaleY;


    /**
     * Creates a new ImageSprite.
     * @param image  the Image to be painted.
     * @param x      the variable x-coordinate of the upper-left corner of the image.
     * @param y      the variable y-coordinate of the upper-left corner of the image.
     * @param scaleX the variable x-scale of the image.
     * @param scaleY the variable y-scale of the image.
     */
    public ImageSprite(Image          image,
                       VariableInt    x,
                       VariableInt    y,
                       VariableDouble scaleX,
                       VariableDouble scaleY)
    {
        this.image  = image;
        this.x      = x;
        this.y      = y;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }


    // Implementation for Sprite.

    public void paint(Graphics graphics, long time)
    {
        int xt = x.getInt(time);
        int yt = y.getInt(time);

        double scale_x = scaleX.getDouble(time);
        double scale_y = scaleY.getDouble(time);

        int width  = (int)(image.getWidth(null)  * scale_x);
        int height = (int)(image.getHeight(null) * scale_y);

        graphics.drawImage(image, xt, yt, width, height, null);
    }
}
