/***************************************************************************
  resource.h
  -------------------
  Global resources for QBrew. Constants, enumerations and strings.
  -------------------
  begin         September 20th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999, 2001, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  3. Neither name of the copyright holders nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef RESOURCE_H
#define RESOURCE_H

#include <qobject.h>
#include <qstring.h>
#include <qmap.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#define PACKAGE "qbrew"
#define VERSION "0.0.0"
#endif

namespace AppResource {

///////////////////////////////////////////////////////////////////
// menu entries

const unsigned ID_FILE_NEW              = 10020;
const unsigned ID_FILE_OPEN             = 10030;
const unsigned ID_FILE_SAVE             = 10040;
const unsigned ID_FILE_SAVE_AS          = 10050;
const unsigned ID_FILE_PRINT            = 10060;
const unsigned ID_FILE_QUIT             = 10100;

const unsigned ID_OPTIONS_TOOLBAR       = 12010;
const unsigned ID_OPTIONS_STATUSBAR     = 12020;
const unsigned ID_OPTIONS_SETUP         = 12030;
const unsigned ID_OPTIONS_SAVESETTINGS  = 12040;

const unsigned ID_TOOLS_HYDROMETER      = 13010;

const unsigned ID_HELP_CONTENTS         = 20010;
const unsigned ID_HELP_PRIMER           = 20020;
const unsigned ID_HELP_ABOUT_QT         = 20030;
const unsigned ID_HELP_ABOUT            = 20040;

///////////////////////////////////////////////////////////////////
// general application values

const QString ID_TITLE                  = "QBrew";
const QString ID_DEFAULT_MESSAGE        = QObject::tr("Ready");
const QString ID_APP_ABOUT              = "<b><big>" + ID_TITLE + " Version " + VERSION + "</big></b>"
                                        + QObject::tr("<br/><hr/><p><b>A Homebrewer's Recipe Calculator</b>")
                                        + QObject::tr("<p>Copyright 1999 - 2001 by ") + "David Johnson"
                                        + QObject::tr("<br/>Contributions by ") + "Abe Kabakoff"
                                        + QObject::tr("<br/>Special thanks to ") + "Stephen Lowrie";
const QChar CHAR_LATIN_DEGREE           = QChar(0xB0);  // TODO: make portable
const QChar CHAR_NBSP                   = QChar(0xA0);  // TODO: make portable

///////////////////////////////////////////////////////////////////
// file locations and stuff

const QString ID_FILE_FILTER            = "*.qbrew";
const QString ID_PREFERENCES_FILE       = ".qbrewrc";
const QString ID_HELP_FILE              = QObject::tr("doc/en/qbrew-handbook.html");    // the english version
const QString ID_PRIMER_FILE            = QObject::tr("doc/en/primer.html");            // the english version
const QString ID_DEFAULT_FILE           = QObject::tr("untitled");

///////////////////////////////////////////////////////////////////
// preferences values

const QString ID_NULL                   = "NULL";
const QString ID_PREF_STATUSBAR         = "StatusBar";
const bool ID_PREF_STATUSBAR_DEFAULT    = true;
const QString ID_PREF_TOOLBAR           = "Toolbar";
const bool ID_PREF_TOOLBAR_DEFAULT      = true;
const QString ID_PREF_QBREWDIR          = "QBrewDir"; // TODO: was DOCDIR
const QString ID_PREF_QBREWDIR_DEFAULT  = "/usr/local/share/qbrew/";
const QString ID_PREF_WIDGET_STYLE      = "WidgetStyle";
const QString ID_PREF_WIDGET_STYLE_DEFAULT  = "Default";
const QString ID_PREF_BATCH             = "Batch";
const double ID_PREF_BATCH_DEFAULT      = 5.00;
const QString ID_PREF_EFFICIENCY        = "Efficiency";
const double ID_PREF_EFFICIENCY_DEFAULT = 0.75;
const QString ID_PREF_TINSETH           = "Tinseth";
const bool ID_PREF_TINSETH_DEFAULT      = false;
const QString ID_PREF_RECIPE_STYLE      = "RecipeStyle";
const QString ID_PREF_RECIPE_STYLE_DEFAULT  = "Generic Ale";

///////////////////////////////////////////////////////////////////
// qt themable style "map"

enum { STYLE_CDE, STYLE_MOTIF, STYLE_MOTIFPLUS, STYLE_PLATINUM, STYLE_SGI,
       STYLE_STEP, STYLE_WINDOWS, STYLE_DEFAULT };

const QString STYLES[] = { "CDE", "Motif", "MotifPlus", "Platinum", "SGI",
    "Step", "Windows", "Default" };

}; // namespace AppResource

#endif // RESOURCE_H
