/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink                                 *
 *   katakombi@web.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#include "myqsdlg.h"

#include "config.h"

//
// for tweaking the predefined UI
//
#include <qapplication.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qlistbox.h>
#include <qcombobox.h>
#include <qpainter.h>
#include <qframe.h>
#include <qpaintdevice.h>
#include <qcolor.h>
#include <qpoint.h>
#include <qwidget.h>


#include <iostream>


myQsDlg::myQsDlg():qsDlg()
{
    // let's update some settings
    versionLabel->setText(APPVERSION);

    // sets version
    xFree86VersionLabel->setText(myTP.detectXFree86Version());
        
    // checks on synaptics touch pad driver
    if (myTP.hasSynaptics()) {
        driverStatusLabel->setText("good: driver is installed");
        synapticsVersionLabel->setText(myTP.detectSynapticsVersion());
        
        if (myTP.hasSHMConfigurability())
        {
            xShmStatusLabel->setText("good: x shared memory accessible!");

            // enable functionality (should be initially disabled!)
            TPswitchBG->setEnabled(TRUE);
            if (myTP.getParameter(TOUCHPADOFF) == 0) enableFunctionality();
            
            // display the current state of parameters!
            displayConfig();
        }
    }
    
    // create some necessary connections
            
    // when the "apply" button is pressed, the changes should take effect!
    // TODO disable button after applying...
    connect(buttonApply,SIGNAL(clicked()),&myTP,SLOT(applyConfig()));
    connect(&myTP,SIGNAL(settingsChanged()),this,SLOT(somethingChanged()));
    
    // same for "OK" button
    connect(buttonOk,SIGNAL(clicked()),&myTP,SLOT(applyAndStoreConfig()));
    
    // when the "cancel" button is pressed, the changes should be reverted!
    connect(buttonCancel,SIGNAL(clicked()),&myTP,SLOT(cancelConfig()));
    
    
    
    // update multi finger list box
    connect(tappingMultifingerLB,SIGNAL(highlighted(int)),
        this,SLOT(mfFingerUpdate(int)));

    // to set the multifinger buttons
    connect(buttonBG,SIGNAL(pressed(int)),this,SLOT(mfButtonUpdate(int)));
    
    // to enable / disable the touch pad
    connect(TPswitchBG,SIGNAL(clicked(int)),this,SLOT(touchPadState(int)));
    
    // to update horizontal scrolling
    connect(scrollHSpeedSlider,SIGNAL(valueChanged(int)),
        this,SLOT(horizScrollingUpdate(int)));
        
    // to update vertical scrolling
    connect(scrollVSpeedSlider,SIGNAL(valueChanged(int)),
        this,SLOT(vertScrollingUpdate(int)));
        
    // the scrolling enable/disable checkboxes
    connect(scrollHoriCB,SIGNAL(stateChanged(int)),
        this,SLOT(horizScrollingUpdate(int)));
    
    // the scrolling enable/disable checkboxes
    connect(scrollVertCB,SIGNAL(stateChanged(int)),
        this,SLOT(vertScrollingUpdate(int)));
        
    // scrolling mode selection
    connect(scrollingScrollingBG,SIGNAL(pressed(int)),this,SLOT(scrollingState(int)));
    
    // corner selection for circular scrolling
    connect(scrollingCircCornersCoB,SIGNAL(highlighted(int)),this,SLOT(circScrollingCorners(int)));
    
    connect(scrollCSpeedSlider,SIGNAL(valueChanged(int)),this,SLOT(circScrollingUpdate(int)));
    
    // display the appropriate edges / corners where circular scrolling should be enabled
    connect(scrollingCircCornersCoB,SIGNAL(highlighted(int)),&myCSEdgesFrame,SLOT(displayCSEdges(int)));
    
    // some stuff we have to do AFTER the connections
   
    // load the stored setting onto HW
    myTP.restoreConfig();
   
    // select "one finger"
    tappingMultifingerLB->setSelected(0,TRUE);

    // update the UI dialog 
    displayConfig();
    
       
    // smart mode delay 
    connect(tappingSmartCB,SIGNAL(toggled(bool)),
        this,SLOT(synDaemonToggle(bool)));
    connect(tappingSmartDelaySlider,SIGNAL(valueChanged(int)),
        this,SLOT(synDaemonUpdate(int)));
    
    // tapping time 
    connect(tappingTimeSlider,SIGNAL(valueChanged(int)),this,SLOT(tappingTimeUpdate(int)));
    
    connect(tappingCB,SIGNAL(toggled(bool)),this,SLOT(tappingUpdate(bool)));
    
       
    
    // if the hardware support (driver/synclient/XSHM) is not there
    // disable "Ok" and "Apply"
    if ( (!myTP.hasSynaptics()) | (!myTP.hasSHMConfigurability()) )
    {
        buttonApply->setDisabled(TRUE);
        buttonOk->setDisabled(TRUE);
    }
    
    // FIXME strange, but width() reports a wrong size, although it is fixed!
    myCSEdgesFrame.resize(75,75);
    myCSEdgesFrame.reparent(showCornersFrame, 0, showCornersFrame->geometry().topLeft(), TRUE);
    
    // resize to the fittest
    updateGeometry();
}


void myQsDlg::enableFunctionality()
{
    tappingGeneralBG->setEnabled(TRUE);
    scrollingScrollingBG->setEnabled(TRUE);
    
    tappingSmartBG->setEnabled(TRUE);
    tappingConfigBG->setEnabled(TRUE);

    if (myTP.hasSynDaemon())
    {
        std::cout << "syndaemon found!" << std::endl;
        std::cout << "syndaemon timing is " << myTP.getParameter(SYNDAEMONTIMING);
        std::cout << std::endl;
        // only allow smart mode when syndaemon is available
        tappingSmartCB->setEnabled(TRUE);
    }
    else
        std::cout << "syndaemon not found!" << std::endl;
}


void myQsDlg::mfFingerUpdate(int finger)
{
    int button=0;
    
    switch (finger)
    {
        case 0: button = (int)myTP.getParameter(TAPBUTTON1); break;
        case 1: button = (int)myTP.getParameter(TAPBUTTON2); break;
        case 2: button = (int)myTP.getParameter(TAPBUTTON3); break;
        default: break;
    }
    switch (button)
    {
        case 0: tappingNoneRB->setChecked(true); break;
        case 1: tappingLeftRB->setChecked(true); break;
        case 2: tappingMiddleRB->setChecked(true); break;
        case 3: tappingRightRB->setChecked(true); break;
        default: break;
    }
}

void myQsDlg::mfButtonUpdate(int button)
{
    int finger = tappingMultifingerLB->currentItem();
    switch(finger)
    {
        case 0: myTP.setParameter(TAPBUTTON1, button); break;
        case 1: myTP.setParameter(TAPBUTTON2, button); break;
        case 2: myTP.setParameter(TAPBUTTON3, button); break;
        default: break;
    }
}


void myQsDlg::horizScrollingUpdate(int val)
{
    val=scrollHSpeedSlider->value();
    myTP.setParameter(HSCROLLEMUOFF,!scrollHoriCB->isChecked()); 
    myTP.setParameter(HORIZSCROLLDELTA,val);
}

void myQsDlg::vertScrollingUpdate(int val)
{
    val=scrollVSpeedSlider->value();
    myTP.setParameter(VSCROLLEMUOFF,!scrollVertCB->isChecked()); 
    myTP.setParameter(VERTSCROLLDELTA,val);
}


void myQsDlg::synDaemonToggle(bool onOff)
{
    if (onOff)
        myTP.setParameter(SYNDAEMONOFF,0);
    else
        myTP.setParameter(SYNDAEMONOFF,1);
}

void myQsDlg::synDaemonUpdate(int delay)
{
    myTP.setParameter(SYNDAEMONTIMING,((float)delay)/1000);
}

void myQsDlg::tappingUpdate(bool onOff)
{
    if (onOff) myTP.setParameter(TAPPINGOFF,0);
    else myTP.setParameter(TAPPINGOFF,1);
}

void myQsDlg::tappingTimeUpdate(int delay)
{
    myTP.setParameter(MAXTAPTIME,delay);
}


void myQsDlg::touchPadState(int state)
{
    if (!state) 
     {
         myTP.setParameter(TOUCHPADOFF,0);
         // enable everything that can be enabled
         enableFunctionality();
     }
    else 
    {
        myTP.setParameter(TOUCHPADOFF,1);
        // disable everything
        tappingSmartBG->setEnabled(FALSE);
        tappingConfigBG->setEnabled(FALSE);
        scrollingScrollingBG->setEnabled(FALSE);
        scrollingNormalSettingsBG->setEnabled(FALSE);
        scrollingCircularSettingsBG->setEnabled(FALSE);
        tappingGeneralBG->setEnabled(FALSE);
    }
}


void myQsDlg::scrollingState(int state)
{
    switch (state)
    {
        case 0: 
            // disable everything
            scrollingNormalSettingsBG->setDisabled(TRUE);
            scrollingCircularSettingsBG->setDisabled(TRUE);
            break;
        case 1: 
            // disable circular scrolling only
            scrollingNormalSettingsBG->setEnabled(TRUE);
            scrollingCircularSettingsBG->setDisabled(TRUE);
            break;
        case 2: 
            // disable normal scrolling only
            scrollingNormalSettingsBG->setDisabled(TRUE);
            scrollingCircularSettingsBG->setEnabled(TRUE);
            break;
        default:
            break;
    }
    myTP.setParameter(SCROLLINGMODE,state);
}

void myQsDlg::circScrollingUpdate(int delta)
{
    myTP.setParameter(CIRCSCROLLDELTA,((float)delta)/1000);
}

void myQsDlg::circScrollingCorners(int corners)
{
    myTP.setParameter(CIRCSCROLLTRIGGER,corners);
}


myFrame::myFrame() : QFrame()
{
    sTrigger = 0;
}

void myFrame::displayCSEdges(int scrollTrigger)
{
    sTrigger = scrollTrigger;
    repaint();
}
    
void myQsDlg::displayConfig()
{
    //
    // touch pad enabled?
    //
    if (myTP.getParameter(TOUCHPADOFF)==1)
        switchTPOffRB->setChecked(TRUE);
    else
        switchTPOnRB->setChecked(TRUE);
        
    //
    // scrolling emulation?
    //
    int hScrollD,vScrollD;
    
    vScrollD = (int)myTP.getParameter(VERTSCROLLDELTA);
    hScrollD = (int)myTP.getParameter(HORIZSCROLLDELTA);
    
    scrollHSpeedSlider->setValue(hScrollD);
    scrollVSpeedSlider->setValue(vScrollD);
    
    scrollVertCB->setChecked(myTP.getParameter(VSCROLLEMUOFF)==0);
    scrollHoriCB->setChecked(myTP.getParameter(HSCROLLEMUOFF)==0);
    
    scrollCSpeedSlider->setValue((int)(myTP.getParameter(CIRCSCROLLDELTA)*1000));
    
    tappingTimeSlider->setValue((int)myTP.getParameter(MAXTAPTIME));
    tappingCB->setChecked(myTP.getParameter(TAPPINGOFF)==0);
    
    int ss = (int)myTP.getParameter(SCROLLINGMODE);
    
    switch(ss)
    {
        case 0: scrollingOffRB->setChecked(TRUE); break;
        case 1: scrollingNormalRB->setChecked(TRUE); break;
        case 2: scrollingCircularRB->setChecked(TRUE); break;
        default: break;
    }
    
    // enable the desired mode, except the pad is disabled
    if (myTP.hasSynaptics()) scrollingState(ss);
    
    //
    // smart mode?
    //
    if (myTP.hasSynDaemon())
    {
        // check the smart mode CB if syndaemon is enabled
        tappingSmartCB->setChecked(myTP.getParameter(SYNDAEMONOFF) == 0);
            
        // set slider
        tappingSmartDelaySlider->setValue((int)(myTP.getParameter(SYNDAEMONTIMING)*1000.0f));
    }
}

void myFrame::paintEvent(QPaintEvent *event)
{
    const int r=10;
    const int b=5;
    
    // permutations...
    const int p[]={1+2+4+8,1+2,2,2+4,4,4+8,8,8+1,1};
    
    int x1=b;
    int y1=b;
    int x2=width()-b-r;
    int y2=height()-b-r;
    
    // you don't need to redraw the stuff
    if (!event->erased()) return;
    
    QPainter myPainting(this);
    
    // erase whole frame
    myPainting.setBrush(QPainter::SolidPattern);
    myPainting.setBrush(QColor("White"));
    myPainting.drawRect(0,0,width(),height());
    
    // draw grid
    myPainting.setBrush(QPainter::CrossPattern);
    myPainting.drawRect(x1,y1,x2+r/2,y2+r/2);
    
    myPainting.setPen(QColor("Red"));
    myPainting.setBrush(QColor("Red"));
    
    if (p[sTrigger]&1) myPainting.drawEllipse(x1,y1,r,r);
    if (p[sTrigger]&2) myPainting.drawEllipse(x2,y1,r,r);
    if (p[sTrigger]&4) myPainting.drawEllipse(x2,y2,r,r);
    if (p[sTrigger]&8) myPainting.drawEllipse(x1,y2,r,r);
}

