/*******************************************************************************
FILENAME:      qtermscreenmgr.cpp
REVISION:      2001.8.12 first created.
         
AUTHOR:        kingson fiasco0
*******************************************************************************/
/*******************************************************************************
                                    NOTE
 This file may be used, distributed and modified without limitation.
 *******************************************************************************/

#include "qtermscreenmgr.h"
#include "global.h"

#include <qstring.h>
#include <qregexp.h>

QTermScreenMgr::QTermScreenMgr( QList<QTermTextLine> *list )
{
	lineList = list;
	defaultAttr = COLORPAIR( /*0x4b*/NO_COLOR ) | EXTRAATTR( NO_ATTR );
}

QTermScreenMgr::~QTermScreenMgr()
{
}

void QTermScreenMgr::setCaretPos( int x, int y )
{
	caretX = x;
	caretY = y;
}

void QTermScreenMgr::setMousePos( int x, int y )
{
	mouseX = x;
	mouseY = y;
}

// get current page state
// now we define 3 types ( -1, 0, 1 )
int QTermScreenMgr::getPageState()
{
	nPageState = -1;
	
	// note: this only base on firebird bbs
	// and now is weak
	currentLine = lineList->at( 0 );	// first line
	QCString cp = currentLine->getColorpair();
	if ( GET_BG( cp[0] ) != GET_BG( GET_COLORPAIR( defaultAttr ) ) )
		nPageState++;

	currentLine = lineList->at( 2 );	// third line
	cp = currentLine->getColorpair();
       	if ( GET_BG( cp[0] ) != GET_BG( GET_COLORPAIR( defaultAttr ) ) )
		nPageState++;

	return nPageState;
}

// get mouse select line or select area
int QTermScreenMgr::getSelectLine()
{
	nSelectLine = -1;

	switch ( nPageState )
	{
	case -1:
		break;

	case 0:
		if ( mouseY >= 7 && mouseY < LINENUM - 1 )	// only for firebird
		{
			currentLine = lineList->at( mouseY );
			QString str = currentLine->getText( 0, mouseX );
			QCString cstr = str.local8Bit();

			QRegExp reg( "[a-zA-Z0-9][).\\]]" );
			char indexChar = cstr.findRev( reg );
			if ( indexChar != -1 )
			{
				cMenu = cstr.at(indexChar);
				//qWarning( "%c", cMenu );
				nMenuStart = indexChar;
				if ( cstr[ indexChar - 1 ] == '(' || cstr[ indexChar - 1 ] == '[' )
					nMenuStart--;

				str = currentLine->getText();
				cstr = str.local8Bit();
				reg = QRegExp( "[^ ]" );
				
				int nMenuBaseLength = 20;	
				nMenuLength = cstr.findRev( reg, nMenuStart + nMenuBaseLength ) - nMenuStart + 1;
				if ( nMenuLength == nMenuBaseLength + 1 )
					nMenuLength = cstr.find( " ", nMenuStart + nMenuBaseLength ) - nMenuStart;
				
				if ( mouseX > nMenuStart && mouseX < ( nMenuLength + nMenuStart ) )
					nSelectLine = mouseY;
			}
		}
		break;

	case 1:
		if ( mouseY >=3 && mouseY < LINENUM - 1 )	// only for firebird	
		{
			currentLine =  lineList->at( mouseY );
			QString str = currentLine->getText();

			if ( str.contains( " " ) != ( int ) str.length() )
				nSelectLine = mouseY;
		}
		break;
	default:
		break;
	}	

	return nSelectLine;
}

int QTermScreenMgr::getMenuPos( int *start )
{
	*start = nMenuStart;
	return nMenuLength;
}

char QTermScreenMgr::getMenuChar()
{
	return cMenu;
}
