
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: FdPricers.i,v 1.7 2002/01/16 14:50:51 nando Exp $

#ifndef quantlib_fd_pricers_i
#define quantlib_fd_pricers_i

%include Date.i
%include Options.i
%include Types.i
%include Vectors.i

%{
using QuantLib::Pricers::FdAmericanOption;
using QuantLib::Pricers::FdBermudanOption;
using QuantLib::Pricers::FdDividendAmericanOption;
using QuantLib::Pricers::FdDividendEuropeanOption;
using QuantLib::Pricers::FdDividendShoutOption;
using QuantLib::Pricers::FdEuropean;
using QuantLib::Pricers::FdShoutOption;
%}


class FdEuropean {
  public:
	FdEuropean(OptionType type, double underlying,
	  double strike, Spread dividendYield, Rate riskFreeRate,
	  Time residualTime, double volatility, int timeSteps = 200,
	  int gridPoints = 800);
	~FdEuropean();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	Array getGrid() const;
	Array getPrices() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};

class FdAmericanOption {
  public:
	FdAmericanOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility, int timeSteps = 100, int gridPoints = 100);
    ~FdAmericanOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
                             int maxEvaluations = 100) const ;
};

class FdShoutOption {
  public:
	FdShoutOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility, int timeSteps = 100, int gridPoints = 100);
    ~FdShoutOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
                             int maxEvaluations = 100) const ;
};


class FdBermudanOption{
  public:
	FdBermudanOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility, const DoubleVector &dates,
	  int timeSteps = 100, int gridPoints = 100);
	~FdBermudanOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};

class FdDividendShoutOption{
  public:
	FdDividendShoutOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility,
	  const DoubleVector &dividends,
	  const DoubleVector &exdivdates,
	  int timeSteps = 100, int gridPoints = 100);
	~FdDividendShoutOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
    double controlVariateCorrection() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};

class FdDividendAmericanOption {
  public:
	FdDividendAmericanOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility,
	  const DoubleVector &dividends,
	  const DoubleVector &exdivdates,
	  int timeSteps = 100, int gridPoints = 100);
	~FdDividendAmericanOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
    double controlVariateCorrection() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};

class FdDividendEuropeanOption {
  public:
	FdDividendEuropeanOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility,
	  const DoubleVector &dividends,
	  const DoubleVector &exdivdates);
	~FdDividendEuropeanOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};


#endif
