
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: History.i,v 1.11 2002/01/16 14:50:51 nando Exp $

#ifndef quantlib_history_i
#define quantlib_history_i

%include Date.i
%include Vectors.i
%include String.i
%include Null.i

// History class

%{
using QuantLib::History;
typedef QuantLib::History::Entry HistoryEntry;
typedef QuantLib::History::const_iterator HistoryIterator;
typedef QuantLib::History::const_valid_iterator HistoryValidIterator;
typedef QuantLib::History::const_data_iterator HistoryDataIterator;
typedef QuantLib::History::const_valid_data_iterator HistoryValidDataIterator;
using QuantLib::DateFormatter;
using QuantLib::DoubleFormatter;
%}

class HistoryEntry {
  private:
    // access control - no constructor exported
    HistoryEntry();
  public:
    ~HistoryEntry();
    Date date();
    doubleOrNull value();
};

%addmethods HistoryEntry {
    String __str__() {
        return DateFormatter::toString(self->date()) +
            "\t" + (self->value() == Null<double>() ? String("Null") :
            DoubleFormatter::toString(self->value()));
    }
}

class HistoryIterator {
  private:
    // access control - no constructor exported
    HistoryIterator();
  public:
    ~HistoryIterator();
};

%addmethods HistoryIterator {
    int __cmp__(const HistoryIterator& other) {
        return (*self == other ? 0 : -1);
    }
    // do not use these directly
    // the user interface is defined in defaults.py
    HistoryEntry _value() {
        return **self;
    }
    void _advance() {
        (*self)++;
    }
}


class HistoryValidIterator {
  private:
    // access control - no constructor exported
    HistoryValidIterator();
  public:
    ~HistoryValidIterator();
};

%addmethods HistoryValidIterator {
    int __cmp__(const HistoryValidIterator& other) {
        return (*self == other ? 0 : -1);
    }
    // do not use these directly
    // the user interface is defined in defaults.py
    HistoryEntry _value() {
        return **self;
    }
    void _advance() {
        (*self)++;
    }
}


class HistoryDataIterator {
  private:
    // access control - no constructor exported
    HistoryDataIterator();
  public:
    ~HistoryDataIterator();
};

%addmethods HistoryDataIterator {
    int __cmp__(const HistoryDataIterator& other) {
        return (*self == other ? 0 : -1);
    }
    // do not use these directly
    // the user interface is defined in defaults.py
    doubleOrNull _value() {
        return **self;
    }
    void _advance() {
        (*self)++;
    }
}


class HistoryValidDataIterator {
  private:
    // access control - no constructor exported
    HistoryValidDataIterator();
  public:
    ~HistoryValidDataIterator();
};

%addmethods HistoryValidDataIterator {
    int __cmp__(const HistoryValidDataIterator& other) {
        return (*self == other ? 0 : -1);
    }
    // do not use these directly
    // the user interface is defined in defaults.py
    doubleOrNull _value() {
        return **self;
    }
    void _advance() {
        (*self)++;
    }
}


class History {
  public:
    History(DateVector dates, DoubleVector values);
    ~History();
    Date firstDate() const;
    Date lastDate() const;
};

%addmethods History {
    int __len__() {
        return self->size();
    }
    doubleOrNull __getitem__(Date d) {
        return (*self)[d];
    }
    String __str__() {
        return "Historical data from " +
            DateFormatter::toString(self->firstDate()) +
            " to " + DateFormatter::toString(self->lastDate());
    }
    // do not use these directly
    // the user interface is defined in defaults.py
    HistoryIterator _begin() {
        return self->begin();
    }
    HistoryIterator _end() {
        return self->end();
    }
    HistoryIterator _iterator(Date d) {
        return self->iterator(d);
    }
    HistoryValidIterator _vbegin() {
        return self->vbegin();
    }
    HistoryValidIterator _vend() {
        return self->vend();
    }
    HistoryValidIterator _valid_iterator(Date d) {
        return self->valid_iterator(d);
    }
    HistoryDataIterator _dbegin() {
        return self->dbegin();
    }
    HistoryDataIterator _dend() {
        return self->dend();
    }
    HistoryDataIterator _data_iterator(Date d) {
        return self->data_iterator(d);
    }
    HistoryValidDataIterator _vdbegin() {
        return self->vdbegin();
    }
    HistoryValidDataIterator _vdend() {
        return self->vdend();
    }
    HistoryValidDataIterator _valid_data_iterator(Date d) {
        return self->valid_data_iterator(d);
    }
}

AllowNoneAsInput(History,History);


#endif
