% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeRegistry.R
\name{removeRegistry}
\alias{removeRegistry}
\title{Remove a Registry from the File System}
\usage{
removeRegistry(wait = 5, reg = getDefaultRegistry())
}
\arguments{
\item{wait}{[\code{numeric(1)}]\cr
Seconds to wait before proceeding. This is a safety measure to not
accidentally remove your precious files. Set to 0 in
non-interactive scripts to disable this precaution.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{character(1)}]: Path of the deleted file directory.
}
\description{
All files will be erased from the file system, including all results.
If you wish to remove only intermediate files, use \code{\link{sweepRegistry}}.
}
\examples{
\dontshow{ batchtools:::example_push_temp(1) }
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
removeRegistry(0, tmp)
}
\seealso{
Other Registry: \code{\link{clearRegistry}},
  \code{\link{getDefaultRegistry}},
  \code{\link{loadRegistry}}, \code{\link{makeRegistry}},
  \code{\link{saveRegistry}}, \code{\link{sweepRegistry}},
  \code{\link{syncRegistry}}
}
\concept{Registry}
