#include "allegro.h"
#include "strings.h"
#include "defs.h"

#include "hull.h"
#include "hull_num_show.h"

HullShow::HullShow( int sp ):
HullObject( NULL, 19, 0, 0, 0, MAX_PLANE, false, NULL ),
spc( sp ),
col( 0 ) {

	shade = new int[ 20 ];
	if ( spc > 800 ) {

		blend_palette( shade, 5, makecol( 242,2,2 ), makecol(49,244,19) );
		blend_palette( shade+4, 5, makecol(49,244,19), makecol(234,242,4) );
		blend_palette( shade+4+4,5, makecol(234,242,4), makecol(255,139,7) );
		blend_palette( shade+4+4+4, 8, makecol(255,139,7),makecol(242,2,2) );

	} else
	blend_palette( shade, 20, makecol(255,255,255), makecol(30,30,30) );
	char * str = int2str( spc );
	int len = text_length( font, str );
	free( str );
	mock = create_bitmap( len, 10 );
	clear_to_color( mock, makecol(255,0,255) );

}


void HullShow::Draw( BITMAP * who, int x, int y ) {

	char * str = int2str( spc );
	int len = text_length( font, str );
	free( str );
	textprintf(mock,font,0,0,shade[col],"%d",spc );
	masked_stretch_blit( mock, who, 0, 0, len, 10, x,y,len+col,10+col);
	takeDamage( 1 );

	col++;
	if ( col > 19 ) col = 19;
}


HullShow::~HullShow() {
	destroy_bitmap( mock );
}
