#include "weaponobj.h"
#include "weapon_rotate.h"
#include "trigtable.h"

Rotate::Rotate( int qx, int qy, double kx, double ky, int _ang, int _max, HullObject * hnew, int al ):
WeaponNode( qx, qy, kx, ky, hnew, al ),
ang( _ang ),
max( _max ),
rad( 0 ),
dir( 1 ){}

void Rotate::MoveReal() {

	virtualx += dx;
	virtualy += dy;
	actualx = (int)( virtualx + tcos[ang] * rad );
	actualy = (int)( virtualy + tsine[ang] * rad );
	rad += dir;
	if ( rad < -max ) dir = 1;
	if ( rad > max ) dir = -1;

}
