# $Header: /raid/cvsroot/rt/lib/rt/ui/cli/query.pm,v 1.7 2000/02/29 03:49:55 jesse Exp $

package rt::ui::cli::query;
require "ctime.pl";


sub activate {
($current_user,$tmp)=getpwuid($<);
($value, $message)=&rt::initialize($current_user);
if ($value == 0) {
    print "$message\n";
    exit(0);
} 
else {
    print "$message\n";
}
$criteria=&build_query();
if ( $export && $format_string ) {
    die "-export and -format may not both be specified";
}
if ( $export ) {
    &export();
    return 0;
}
$count=&rt::get_queue($criteria,$current_user);
if (!$format_string) {
    $format_string = "%n%p%o%g%l%t%r%s";
}
&print_header($format_string);
for ($temp=0;$temp<$count;$temp++)
{
    #do this because we're redefining the format string internally each run.
    my ($format_string) = $format_string;

    while ($format_string) {
	($field, $format_string) = split (/\%/, $format_string,2);  

	if  ($field =~ /^n(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=6;}
	    printf "%-${length}.${length}s ", $rt::req[$temp]{'serial_num'};
	}
        elsif ($field =~ /^d(\d*)$/){
            my $length = $1;
		if ($rt::req[$temp]{'date_due'} > 0) {
		my $date = localtime($rt::req[$temp]{'date_due'});
		$date =~ s/\d*:\d*:\d*//;	
                if ($length < 1) {$length=5;}
            printf "%-${length}.${length}s ", $date;
		}
	else {
	printf  "%-${length}.${length}s ", "none";
	}
        }
	elsif ($field =~ /^p(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=2;}
	    printf "%-${length}.${length}d ", $rt::req[$temp]{'priority'};
	}
	elsif ($field =~ /^r(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=9;}
	    printf "%-${length}.${length}s ", $rt::req[$temp]{'requestors'};
	}
	elsif ($field =~ /^o(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=8;}
	    printf "%-${length}.${length}s ", $rt::req[$temp]{'owner'};
	}

	elsif ($field =~ /^s(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=30;}
	    printf "%-${length}.${length}s ", $rt::req[$temp]{'subject'};
	}
	elsif ($field =~ /^t(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=5;}
	    printf "%-${length}.${length}s ", $rt::req[$temp]{'status'};
	}
	elsif ($field =~ /^q(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=8;}
	    printf "%-${length}.${length}s ", $rt::req[$temp]{'queue_id'};
	}
	elsif ($field =~ /^a(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=7;}
	    printf "%-${length}.${length}s ", $rt::req[$temp]{'area'};
	}
	elsif ($field =~ /^g(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=6;}
	    printf "%-${length}.${length}s ", $rt::req[$temp]{'age'};
	}
	elsif ($field =~ /^l(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=6;}
	    printf "%-${length}.${length}s ", $rt::req[$temp]{'since_told'};
	}
	elsif ($field =~ /^w(.)$/) {
	    if ($1 eq 't') { print "\t";}
	    if ($1 eq 's') { print " ";}
	    if ($1 eq 'n') {print "\n";}
	}
	else {
	    print $field;
	}
    }
    print "\n";
}
}
sub build_query {
    local ($owner_ops, $user_ops, $status_ops, $prio_ops, $order_ops, $reverse);
    if (($ARGV[0] eq '-help')  or ($ARGV[0] eq '--help') or ($ARGV[0] eq '-h')) {
     &usage();
     exit(0);
    }
    if (&rt::is_a_queue($ARGV[0])){
	$queue_ops = "queue_id = \'$ARGV[0]\'";
    }

    for ($i=0;$i<=$#ARGV;$i++) {
	if ($ARGV[$i] eq '-format') {
	    $format_string = $ARGV[++$i];
	}
        if ($ARGV[$i] eq '-export') {
            $export = 1;
        }

	if ($ARGV[$i] eq '-owner') {
	    if ($owner_ops){
		   $owner_ops .= " OR ";
	       }
	       $owner_ops .= " owner = \'" . $ARGV[++$i] . "\'";
	   }
	   
	   if ($ARGV[$i] eq '-unowned'){
	       if ($owner_ops){
		   $owner_ops .= " OR ";
	       }
	       $owner_ops .= " owner =  \'\'" ;
	   }
	   if ($ARGV[$i] eq '-all'){
	       $all_ops = 1;
	   }
	   if ($ARGV[$i] =~ '-prio'){
	       if ($prio_ops){
		   $prio_ops .= " AND ";
	       }
	       $prio_ops .= " priority $ARGV[++$i] $ARGV[++$i] ";
	   }
	   
	   if ($ARGV[$i] =~ '-stat'){
	       if ($status_ops){
		   $status_ops .= " OR ";
	       }
	       $status_ops .= " status =  \'$ARGV[++$i]\'" ;
	   }

           if ($ARGV[$i] eq '-area'){
               if ($area_ops){
                   $area_ops .= " OR ";
               }
               $area_ops .= " area =  \'$ARGV[++$i]\'" ;
           }

	   if ($ARGV[$i] eq '-open'){
	       if ($status_ops){
		   $status_ops .= " OR ";
	       }
	       $status_ops .= " status =  \'open\'" ;
	   }
	   if (($ARGV[$i] eq '-resolved') or ($ARGV[$i] eq '-closed')){
	       if ($status_ops){
		   $status_ops .= " OR ";
	       }
	       $status_ops .= " status =  \'resolved\'" ;
	   }
	   if ($ARGV[$i] eq '-dead'){
	       if ($status_ops){
		   $status_ops .= " OR ";
	       }
	       $status_ops .= " status =  \'dead\'" ;
	   }    
	   
	   if ($ARGV[$i] eq '-stalled'){
	       if ($status_ops){
		   $status_ops .= " OR ";
	       }
	       $status_ops .= " status =  \'stalled\'" ;
	   }
	   
	   if ($ARGV[$i] eq '-user') {
	       if ($user_ops){
		   $user_ops .= " OR ";
	       }
	       $user_ops .= " requestors like \'%" . $ARGV[++$i] . "%\' ";
	   }
	   
	   if ($ARGV[$i] eq '-orderby') {
	       if ($order_ops){
		   $order_ops .= ", ";
	       }
	       $order_ops .= $ARGV[++$i]; 
	   }
	   if ($ARGV[$i] eq '-r') {
	       $reverse = ' DESC'; 
	   }

	   if ($ARGV[$i] eq '-t') {       
	       if ($order_ops){
		   $order_ops .= ", ";
	       }
	       $order_ops .= "date_acted"; 
	   }
    }    
    
    if ($queue_ops) {
	if ($query_string) {$query_string .= " AND ";}
	$query_string .= "$queue_ops";
    }
   
    if ($area_ops) {
	if ($query_string) {$query_string .= " AND ";}
        $query_string .= "$area_ops";
    }
 
    if ($prio_ops) {
	if ($query_string) {$query_string .= " AND ";}
	$query_string .= "$prio_ops";
    }
    
    if ($status_ops) {
	if ($query_string) {$query_string .= " AND ";}
	$query_string .= "$status_ops";
    }
    
    if ($user_ops) {
	if ($query_string) {$query_string .= " AND ";}
	$query_string .= "$user_ops";
    }
    if ($owner_ops) {
	if ($query_string) {$query_string .= " AND ";}
	$query_string .= "$owner_ops";
    }
    if ($all_ops) {
        $query_string = "1 = 1 ";
    }
    if (!$query_string) {
	$query_string = "status = \'open\' ";
    }
    if ($order_ops) {
	$query_string .= "ORDER BY $order_ops";
    }
    else {
	$query_string .= "ORDER BY serial_num";
    }
    if ($reverse) {
	$query_string .= " DESC";
    }
    
    return ($query_string);
}
sub usage {
print"
       usage: rtq <queue> <options>
       Where <options> are almost any combination of:
           -r                list requests in reverse order
           -t                list most recently modified requests first
    
           -prio <op> <prio> list requests which have a <prio> satisfying <op>
                             op may be one of = < > <= >= <>
           -owner    <user>  lists all requests owned by <user>
           -unowned          lists unowned requests
           -user <user>      lists all requests made by <user>
           -open             lists only the open requests
           -resolved         lists resolved requests
           -stalled          lists stalled requests
           -dead             lists killed requests
	   -area <area>	     lists requests in the area <area>
           -orderby <crit>   Sorts requests by <crit>  (one of serial_num, 
                             queue_id, requestors, owner, subject, priority, 
           -export           Outputs selected requests in tab-delimited format,
                             including all fields.  Embedded tabs and newlines
                             are translated to \\t and \\n.  A header record is
                             written.
           -all              Export all requests
                             status, date_created, date_due, area)
           -format <format> allows you to specify the output of rtq.
                             <format> is a string of the form %xn%xn%xn.  
                             x is any of the commands associated below.  
                             n is an integer which corresponds to the 
                             number of spaces you'd like the output of x 
                             to take up.  <format>'s default value is 
                             \"%n%p%o%g%l%t%r%s\". Valid values of x are:
                             n[6]      serial number
                             p[2]      priority
                             r[9]      requestors
                             o[8]      owner
			     d[10]     due date
                             s[30]     subject
                             t[5]      status
                             a[7]      area
                             q[8]      queue
                             g[5]      age
                             l[6]      time since last correspondence
                             wt        tab
                             ws        space
                             wn        newline
";

    #          <num>-<num>      print only requests in the number range\n
    #          <num>            print only request <num>\n";
    #          :<num>           print a total of <num> requests\n";
    
print "                     Without options, rtq lists all open requests.
";
}


sub print_header {
    my($format_string) =@_;
    my ($field, $length,$total_length);
    while ($format_string) {
	($field, $format_string) = split (/%/, $format_string,2);  
	
	if ($field =~ /^n(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=6;}
	    $total_length = $total_length + $length;
	    printf "%-${length}.${length}s ", "Num";
	}
        elsif ($field =~ /^d(\d*)$/){
            $length = $1;
                if ($length < 1) {$length=5;}
            $total_length = $total_length + $length;
            printf "%-${length}.${length}s ", "Due";
        }
	elsif ($field =~ /^p(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=2;}
	    $total_length = $total_length + $length;
	    printf "%-${length}.${length}s ", "!";
	}
	elsif ($field =~ /^r(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=9;}
	    $total_length = $total_length + $length;
	    printf "%-${length}.${length}s ", "Requestor";
	}
	elsif ($field =~ /^o(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=8;}
	    $total_length = $total_length + $length;
	    printf "%-${length}.${length}s ", "Owner";
	}

	elsif ($field =~ /^s(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=20;}
	    $total_length = $total_length + $length;
	    printf "%-${length}.${length}s ", "Subject";
	}
	elsif ($field =~ /^t(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=5;}
	    $total_length = $total_length + $length;
	    printf "%-${length}.${length}s ", "State";
	}

	elsif ($field =~ /^q(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=8;}
	    $total_length = $total_length + $length;
	    printf "%-${length}.${length}s ", "Queue";
	}
	elsif ($field =~ /^a(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=7;}
	    $total_length = $total_length + $length;
	    printf "%-${length}.${length}s ", "Area";
	}
	elsif ($field =~ /^g(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=6;}
	    $total_length = $total_length + $length;
	    printf "%-${length}.${length}s ", "Age";
	}
	elsif ($field =~ /^l(\d*)$/){ 
	    $length = $1;
		if ($length < 1) {$length=6;}
	    $total_length = $total_length + $length;
	    printf "%-${length}.${length}s ", "Told";
	}
	elsif ($field =~ /^w(.)$/) {
	    if ($1 eq 't') { print "\t";}
	    if ($1 eq 's') { print " ";}
	    if ($1 eq 'n') {print "\n";}
	}
	else {
	    print $field;
	}

    }
    print "\n";
    for ($temp=0;$temp<$total_length;$temp++){
	print "-";
    }
    print "\n";
}
sub export
{
    my( $i, $k, $val, @values );

    my @fields = qw(
                        serial_num
                        queue_id
                        area
                        status
                        alias
                        owner
                        initial_priority
                        final_priority
                        priority
                        date_created
                        date_told
                        date_acted
                        date_due
                        date_status_changed
                        current_user
                        requestors
                        subject
                   );

    print join("\t", @fields), "\n";

    for ($i = 0 ; $i < $count; $i++) {

        $rt::req[$i]{'date_status_changed'} =
                &last_status($rt::req[$i]{'serial_num'});

        my @values = ();

        foreach $k (@fields) {
          
            $val = $rt::req[$i]{$k};
            $val =~ s/\t/\\t/g;
            $val =~ s/\n/\\n/g;

            push(@values, $val);
        }

        print join("\t", @values), "\n";

    }
    
}


sub last_status
{
    my ( $in_serial_num ) = @_;

    my $i = &rt::transaction_history_in($in_serial_num,$current_user);

    while ( $i-- > 0 ) {

        next unless $rt::req[$in_serial_num]{'trans'}[$i]{'type'} eq 'status';

        return $rt::req[$in_serial_num]{'trans'}[$i]{'time'};
    
    }

    return 0;
}


1;
