# $Header: /CVSROOT/yahoo/audit/rt/stats/manipulate.pm,v 1.3 1998/08/28 01:39:51 serge Exp $

require rt::ui::web::support;
require rt::stats::db::db;
package rt::stats;

#use strict;

my $ScriptURL;
my $query;
my $sdate;
my $edate;

sub activate
{
use Time::Local;
my @ks = ('Last Day','Last Week','Last Month');
my $dinc = 24*60*60;
my %per = (
	   $ks[0] => d_day,
	   $ks[1] => d_week,
	   $ks[2] => d_month,
	  );
my %pr = (
	   $ks[0]=>$dinc,
	   $ks[1]=>$dinc*7,
	   $ks[2]=>$dinc*30
	 );
my @qs;
my %owners;
my $msg;
my $q = '';

   $QUEUE_FONT="-1";
   $MESSAGE_FONT="-1";
   &rt::ui::web::cgi_vars_in();

   &init_env();
   &InitDisplay();
   &get_date();

   $q = $rt::ui::web::FORM{'q_queue'} if defined $rt::ui::web::FORM{'q_queue'};
   return 1 if ! &db_init(\@qs,\%owners,$q);

   &show_stats(\@ks,\%pr,\%per,$q,\%owners);
   &db_end();

   &display_form(\@ks,\%per,\@qs,\%owners);

   &set_cookie();
   &footer();
   return(0);
}

sub show_stats
{
my ($ks,$pr,$per,$q,$owners) = @_;
my %tbl;
my $datet = time;
my $sortby = 'srt';
my $order = 'ord';
my %u;

   $sortby = $rt::ui::web::FORM{$sortby} ? $rt::ui::web::FORM{$sortby} : 'owner';
   $order = defined $rt::ui::web::FORM{$order} ? $rt::ui::web::FORM{$order} : 0;

   if( $rt::ui::web::FORM{q_owned_by} || $rt::ui::web::FORM{q_unowned} )
   {
	$u{$rt::ui::web::FORM{q_owner}} = $$owners{$rt::ui::web::FORM{q_owner}} if $rt::ui::web::FORM{q_owned_by};
	$u{nobody} = $$owners{nobody} if $rt::ui::web::FORM{q_unowned};
   }
   else
   {
	%u = %$owners;
   }
   
   for( @$ks )
   {
	undef %tbl;
	$rt::ui::web::FORM{$$per{$_}} = '' if ! defined $rt::ui::web::FORM{$$per{$_}};
	next if ! $rt::ui::web::FORM{$$per{$_}};
	$msg = &get_db_stats(\%u,\%tbl,$q,$datet - $$pr{$_},$datet);
	return $msg if $msg;
	&pr_out($_,\%tbl,$sortby,$order);
   }

   if( $rt::ui::web::FORM{'d_range'} )
   {
	undef %tbl;
	$msg = &get_db_stats(\%u,\%tbl,$q,$sdate,$edate);
	return $msg if $msg;
	&pr_out('Selected Range',\%tbl,$sortby,$order);
   }
}

sub get_date
{
my $dedate = time;
my $dinc = 24*60*60;
my $dsdate = $dedate - 365*$dinc;

   if( ! defined $rt::ui::web::FORM{e_date_year} )
   {
   	$sdate = $dsdate;
   	$edate = $dedate;
   	return;
   }
   $sdate = timelocal(0,0,0,$rt::ui::web::FORM{'s_date_mday'},$rt::ui::web::FORM{'s_date_month'},$rt::ui::web::FORM{'s_date_year'});
   $edate = timelocal(0,0,0,$rt::ui::web::FORM{'e_date_mday'},$rt::ui::web::FORM{'e_date_month'},$rt::ui::web::FORM{'e_date_year'});
   ($edate,$sdate) = ($sdate,$edate) if $sdate > $edate;
   $sdate -= $dinc if $sdate == $edate;
}

sub queue_header
{
my ($col,$name,$t) = @_;
my $header;

   $header = "<TH><CENTER><FONT SIZE=\"-1\">$name<br><a href=\"$ScriptURL?srt=$col\&ord=0\&$query\"><img src=\"/webrt/up.gif\" alt=\"Ascending\" border=0></a>&nbsp;<a href=\"$ScriptURL?srt=$col\&ord=1&$query\"><img src=\"/webrt/down.gif\" alt=\"Descending\" border=0></a></FONT></CENTER></TH>";
   return ($header);
}

sub pr_out
{
my ($msg,$tbl,$sortby,$sortorder) = @_;
my @pr;
my $i = 0;
my $topen = 0;
my $tresolved = 0;
my $tstalled = 0;
my $ttotal = 0;

   @pr = keys %$tbl;

   if( $sortby eq 'owner' )
   {
	if( $sortorder )
	{
		@pr = sort {$b cmp $a} @pr;
	}
	else
	{
		@pr = sort @pr;
	}
   }
   else
   {
	@pr = sort {&byfield($sortby,$tbl,$sortorder)} @pr;
   }

   print "<center><B><FONT COLOR=\"\#000099\"><font size=+1>$msg</FONT></B></center><BR>";
   print "
	<font size=\"$QUEUE_FONT\">
	<TABLE cellpadding=4 border=1 width=100% bgcolor=\"\#bbbbbb\">
	<TR>";
   $query =~ s/srt=(.*?)\&//g;
   $query =~ s/ord=(.*?)\&//g;
   $query =~ s/&&//g;
   print &queue_header('owner',"Owner",$per);
   print &queue_header('open',"Open",$per);
   print &queue_header('stalled',"Stalled",$per);
   print &queue_header('resolved',"Resolved",$per);
   print &queue_header('total',"Total",$per);
   print "</TR>";
  
   for( @pr )
   {
	if( $i % 2 )
	{
		&rt::ui::web::new_row("bgcolor=\"ffffff\"");
	}
	else
	{
		&rt::ui::web::new_row("bgcolor=\"dddddd\"");
	}
	$i++;
	print "
	<TD NOWRAP><font size=-1>$_ ($$tbl{$_}{real_name})</font></TD>
	<TD NOWRAP><font size=-1><b>$$tbl{$_}{'open'}</b>&nbsp;</font></TD>
	<TD NOWRAP><font size=-1><b>$$tbl{$_}{'stalled'}</b>&nbsp;</font></TD>
	<TD NOWRAP><font size=-1><b>$$tbl{$_}{'resolved'}</b>&nbsp;</font></TD>
	<TD NOWRAP><font size=-1><b>$$tbl{$_}{'total'}</b>&nbsp;</font></TD>";
   	$topen += $$tbl{$_}{'open'};
   	$tresolved += $$tbl{$_}{'resolved'};
   	$tstalled += $$tbl{$_}{'stalled'};
   	$ttotal += $$tbl{$_}{'total'};
   }
   if( scalar(@pr) > 1 )
   {
	   &rt::ui::web::new_row("bgcolor=\"3eeeee\"");
	   print "
		<TD NOWRAP><font size=-1>Total:</font></TD>
		<TD NOWRAP><font size=-1><b>$topen</b>&nbsp;</font></TD>
		<TD NOWRAP><font size=-1><b>$tstalled</b>&nbsp;</font></TD>
		<TD NOWRAP><font size=-1><b>$tresolved</b>&nbsp;</font></TD>
		<TD NOWRAP><font size=-1><b>$ttotal</b>&nbsp;</font></TD>";
   }
   print "</TR></TABLE></font></B><BR><BR>\n";
}

sub byfield
{
my ($sortby,$tbl,$sortorder) = @_;

   return $$tbl{$b}{$sortby} <=> $$tbl{$a}{$sortby} if $sortorder;
   $$tbl{$a}{$sortby} <=> $$tbl{$b}{$sortby};
}

sub display_form
{
my ($ks,$per,$qs,$u) = @_;
my $name;
my $queue;

   print "<form action=\"$ScriptURL\" method=\"get\">";
   print "
<center>
<table>
<td valign=\"top\">
<font size=\"-1\">
<b>Owner</b>: <INPUT TYPE=\"checkbox\" NAME=\"q_unowned\" VALUE=\"true\"";
   $rt::ui::web::FORM{'q_unowned'} = '' if ! defined $rt::ui::web::FORM{'q_unowned'};
   $rt::ui::web::FORM{'q_owned_by'} = '' if ! defined $rt::ui::web::FORM{'q_owned_by'};
   $rt::ui::web::FORM{'q_owner'} =  $rt::ui::web::current_user if ! defined $rt::ui::web::FORM{'q_owner'};

   print "CHECKED" if $rt::ui::web::FORM{'q_unowned'};
   print "> None ";

   print "<INPUT TYPE=\"checkbox\" NAME=\"q_owned_by\" VALUE=\"true\"";
   print "CHECKED" if $rt::ui::web::FORM{'q_owned_by'};

   print "> <select name=\"q_owner\">";
   for(sort keys %$u)
   {
	next if /nobody/;
	print "<option ";
	print "SELECTED" if $_ eq $rt::ui::web::FORM{'q_owner'};
	print ">$_\n";
   }
   print "</select></TD>\n";
   
   print "<td valign=\"top\">";
   print "
<font size=\"-1\">
<b>Queue</b>: <select name=\"q_queue\">
<option value=\"\">Any\n";
   for( @$qs )
   {
	print "<option";
	print " SELECTED" if $_ eq $rt::ui::web::FORM{q_queue};
	print ">$_\n";
   }
   print "</select></td></tr>\n";
   
   print "
<td valign=\"top\">
<font size=\"-1\">
<B>Display</B>: ";
   foreach $name ( @$ks )
   {
	$rt::ui::web::FORM{$$per{$name}} = '' if ! defined $rt::ui::web::FORM{$$per{$name}};
	print "<INPUT TYPE=\"checkbox\" NAME=\"$$per{$name}\" VALUE=\"true\"";
	print "CHECKED" if $rt::ui::web::FORM{$$per{$name}};
	print "> $name ";
   }
   print "</td></tr>";

   print "
<td valign=\"top\">
<font size=\"-1\">";
   $rt::ui::web::FORM{'d_range'} = '' if ! defined $rt::ui::web::FORM{'d_range'};
   print "<INPUT TYPE=\"checkbox\" NAME=\"d_range\" VALUE=\"true\"";
   print "CHECKED" if $rt::ui::web::FORM{'d_range'};
   print "> Display range: ";
	&select_date($sdate,'s_date');
	print "-- ";
	&select_date($edate,'e_date');
   print "<font size=\"-1\"></td></table></center><br>\n";
   
   print "<B><center><input type=\"submit\" value =\"Update Display Filter\"></center></B>";
   if( defined $rt::ui::web::FORM{'srt'} )
   {
   	print "<input type=\"hidden\" name=\"srt\" value=\"$rt::ui::web::FORM{'srt'}\">";
	print "<input type=\"hidden\" name=\"ord\" value=\"$rt::ui::web::FORM{'ord'}\">";
   }
   print "<input type=\"hidden\" name=\"display\" value=\"stats\">";

   print "</form>";
}

sub select_date
{
my ($date, $name) = @_;
my $dt = time;
my ($wday, $mon, $mday, $hour, $min, $sec, $TZ, $year, $temp, $counter, $now_year);
local (@MoY = ('Jan','Feb','Mar','Apr','May','Jun',
       	   'Jul','Aug','Sep','Oct','Nov','Dec'));

   ($temp, $temp, $temp, $temp, $temp, $temp, $temp, $year)=&rt::parse_time($dt);
   ($wday, $mon, $mday, $hour, $min, $sec, $TZ, $now_year)=&rt::parse_time($date);
   print "<select name=\"".$name."_mday\">\n";
   for ($counter=1;$counter<=31;$counter++)
   {
	print "<option";
	if ($mday==$counter) {print " SELECTED";}
	print ">$counter\n";
   }
   print "</select><select name=\"".$name."_month\">\n";
   for ($counter=0;$counter<=11;$counter++)
   {
	print "<option value=\"$counter\" ";
	if ($mon eq $MoY[$counter]) {print " SELECTED";}
	print ">$MoY[$counter]\n";
   }
   print "</select><select name=\"".$name."_year\">\n";
   for ($counter=$year-5;$counter<=$year;$counter++)
   {
	print "<option value=\"".($counter-1900)."\" "; #apparently, timelocal
	                                            #likes dates to be 2 digits
	                                            #that sucks
	if ($counter==$now_year) {print " SELECTED";}
	print ">$counter\n";
   }
   print "</select>\n"; 
}

sub InitDisplay
{
  
  &rt::ui::web::header();
  if( ! $rt::ui::web::FORM{'display'} && ! &decode_cookie() )
  {
	$rt::ui::web::FORM{'d_day'}='true';
  }
}

sub decode_cookie
{
my $cookie = $ENV{HTTP_COOKIE};
my $name;
my $value;
my @pairs;

   return 0 if ! $cookie;
   return 0 if ! ($cookie =~ /.*RT_STATS=(.+)&%%/);
   @pairs = split(/&/,$1);
   for(@pairs)
   {
	s/\s//g;
   	($name, $value) = split /=/;
   	next if ! ($name=~/^(q_\w+|d_\w+|srt|ord|s_date_\w+|e_date_\w+)/);
   	next if defined $rt::ui::web::FORM{$name};
   	$rt::ui::web::FORM{$name} = $value;
   }
   return 1;
}

# set cookie to save user preferences
#META HTTP-EQUIV="Set-Cookie" CONTENT="NAME=value; EXPIRES=date;
#DOMAIN=domain_name; PATH=path; SECURE"
sub set_cookie
{
my $expire;
my $inc = 24*7*60*60; # default expire is one week
my ($wday, $mon, $mday, $hour, $min, $sec, $TZ, $year)=&rt::parse_time(time + $inc);
my $cookie = '';

  $expire = "$wday, $mday-$mon-$year $hour:$min:$sec $TZ";
  for(sort keys %rt::ui::web::FORM)
  {
   	next if ! /^(q_\w+|d_\w+|srt|ord|s_date_\w+|e_date_\w+)/;
  	$cookie .= "$_=$rt::ui::web::FORM{$_}&";
  }
  print "<META HTTP-EQUIV=\"Set-Cookie\"CONTENT=\"RT_STATS=$cookie%%";
  print ";expires=$expire; path=/rt-cgi;secure\">\n";
}

sub init_env
{
   $ScriptURL=$ENV{'SCRIPT_NAME'}.$ENV{'PATH_INFO'};
   $rt::ui::web::current_user = $ENV{'REMOTE_USER'};
   $query = $ENV{'QUERY_STRING'};
}

sub footer
{
   print "<CENTER><A HREF=\"https://$rt::rt_server_host/rt-cgi/webrt.cgi\">Back to main RT page</A>";
   print " | <A HREF=\"https://$rt::rt_server_host/rt-cgi/admin-webrt.cgi\">Change Configuration</A></CENTER><br>";
   &rt::ui::web::footer();
}

sub db_init
{
my ($qs,$owners,$q) = @_;
   return 0 if &db::db_connect();
   return 0 if &get_queues($qs, $rt::ui::web::current_user);
   return 0 if &get_users($owners, $q, $qs);
   return 1;
}

sub db_end
{
   &db::db_close();
}

1;
