# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Integer", "Numeric", "class")
aClass.addSubclasses(%w{Bignum Fixnum})
aClass.addFragment(Paragraph.new("<code>Integer</code> is the basis for the two concrete classes that hold whole numbers, <code>Bignum</code> and <code>Fixnum</code>.\n"))
m0002 = MethodDesc.new("chr", "instance", "<i>int</i>.chr -> <i>aString</i>")
m0002.addFragment(Paragraph.new("Returns a string containing the ASCII character represented by the receiver's value.\n"))
m0002.addFragment(Verbatim.new("65.chr    \#=> \"A\"\n?a.chr    \#=> \"a\"\n230.chr   \#=> \"\\346\"\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("downto", "instance", "<i>int</i>.downto( <i>anInteger</i> ) {| i | block } <p></p> -> <i>int</i>")
m0003.addFragment(Paragraph.new("Iterates <em>block</em>, passing decreasing values from <i>int</i> down to and including <i>anInteger</i>.\n"))
m0003.addFragment(Verbatim.new("5.downto(1) { |n| print n, \".. \" }\nprint \"  Liftoff!\\n\""))
m0003.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0003.addFragment(Verbatim.new("5.. 4.. 3.. 2.. 1..   Liftoff!"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("integer?", "instance", "<i>int</i>.integer? -> <code>true</code>")
m0004.addFragment(Paragraph.new("Always returns <code>true</code>.\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("next", "instance", "<i>int</i>.next -> <i>anInteger</i>")
m0005.addFragment(Paragraph.new("Returns the <code>Integer</code> equal to <i>int</i> + 1.\n"))
m0005.addFragment(Verbatim.new("1.next      \#=> 2\n(-1).next   \#=> 0\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("step", "instance", "<i>int</i>.step( <i>endNum</i>, <i>step</i> ) {| i | block } <p></p> -> <i>int</i>")
m0006.addFragment(Paragraph.new("Invokes <em>block</em> with the sequence of numbers starting at <i>int</i>, incremented by <i>step</i> on each call. The loop finishes when the value to be passed to the block is greater than <i>endNum</i> (if <i>step</i> is positive) or less than <i>endNum</i> (if <i>step</i> is negative).\n"))
m0006.addFragment(Verbatim.new("1.step(10, 2) { |i| print i, \" \" }"))
m0006.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0006.addFragment(Verbatim.new("1 3 5 7 9"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("succ", "instance", "<i>int</i>.succ -> <i>anInteger</i>")
m0007.addFragment(Paragraph.new("Synonym for <code>Integer\#next</code>.\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("times", "instance", "<i>int</i>.times {| i | block } <p></p> -> <i>int</i>")
m0008.addFragment(Paragraph.new("Iterates block <i>int</i> times, passing in values from zero to <i>int</i> - 1.\n"))
m0008.addFragment(Verbatim.new("5.times do |i|\n  print i, \" \"\nend\nprint \"\\n\""))
m0008.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0008.addFragment(Verbatim.new("0 1 2 3 4"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("upto", "instance", "<i>int</i>.upto( <i>anInteger</i> ) {| i | block } <p></p> -> <i>int</i>")
m0009.addFragment(Paragraph.new("Iterates <em>block</em>, passing in integer values from <i>int</i> up to and including <i>anInteger</i>.\n"))
m0009.addFragment(Verbatim.new("5.upto(10) { |i| print i, \" \" }"))
m0009.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0009.addFragment(Verbatim.new("5 6 7 8 9 10"))
aClass.addMethod(m0009)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
