/*
 *  contact-data.c
 *
 *  Created: 20011224
 *
 *  Copyright (c) 2001 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: contact-data.c,v 1.26 2002/03/04 23:13:34 tomek Exp $
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <contact-data.h>

#include <string.h>
#include <common.h>

/* Funkcja zerujca struktur danych kontaktu. */
void clear_contact_data(contact_data *data)
{
    memset(data, 0, sizeof(contact_data));
    data->send_to = ADDRESS_TYPE_NONE;
    data->phone_type[0] = PHONE_TYPE_HOME;
    data->phone_type[1] = PHONE_TYPE_WORK;
    data->phone_type[2] = PHONE_TYPE_FAX_WORK;
    data->phone_type[3] = PHONE_TYPE_MOBILE;
}

#define MAX_FULL_NAME  (MAX_FIRST_NAME + MAX_MIDDLE_NAME + MAX_LAST_NAME + 3)

/* Funkcja zwracajca wskanik do acucha zawierajacego pene imi i nazwisko utworzony na
   podstawie poszczeglnych jego elementw. */
gchar *get_full_name(contact_data *data)
{
    gchar *full_name;
    gboolean is_space = TRUE;
    
    /* Utworzenie i wypenienie zerami zmiennej sucej do przechowywania penego imienia
       i nazwiska kontaktu. */    
    full_name = (gchar *)g_malloc0(MAX_FULL_NAME);

    /* Utworzenie penego imienia i nazwiska na podstawie poszczeglnych jego elementw. */    
    if (strcmp(data->prefix_name, "") != 0)
    {
        strcat(full_name, data->prefix_name);
	is_space = FALSE;
    }
    
    if (strcmp(data->first_name, "") != 0)
    {
        if (!is_space)
	    strcat(full_name, " ");
	strcat(full_name, data->first_name);
	is_space = FALSE;
    }
    
    if (strcmp(data->middle_name, "") != 0)
    {
        if (!is_space)
	    strcat(full_name, " ");
	strcat(full_name, data->middle_name);
	is_space = FALSE;
    }
    
    if (strcmp(data->last_name, "") != 0)
    {
        if (!is_space)
	    strcat(full_name, " ");
	strcat(full_name, data->last_name);
	is_space = FALSE;
    }
    
    if (strcmp(data->sufix_name, "") != 0)
    {
        if (!is_space)
	    strcat(full_name, " ");
	strcat(full_name, data->sufix_name);
    }

    return full_name;
}

/* Funkcja tworzca pene imi i nazwisko na podstawie poszczeglnych jego
   elementw, a nastepnie wstawiajca t warto do pola imienia i nazwiska
   okienka kontaktw. */
void create_full_name(contact_data *data)
{
    gchar *full_name;
    gpointer entry;

    /* Utworzenie penego imienia i nazwiska. */
    full_name = get_full_name(data);

    /* Wstawienie penego imienia i nazwiska do pola edycji. */
    entry = gtk_object_get_data(GTK_OBJECT(data->contact_window), "full_name");
    gtk_entry_set_text(GTK_ENTRY(entry), full_name);
    
    g_free(full_name);
}

/* Funkcja tworzca list elementw do listy wyboru "Zapisz jako" na podstawie
   poszcczeglnych elementw imienia i nazwiska, a nastepnie wstawiajca t
   warto do listy wyboru. */
void create_save_as_list(contact_data *data)
{
    gchar *full_first_name;
    gchar *full_name;
    gchar *item;

    GList *list = NULL;
    
    gpointer entry;

    /* Utworzenie i wypenienie zerami zmiennych pomocniczych sucych do
       tworzenia elementw listy "Zapisz jako". */
    full_first_name = (gchar *)g_malloc0(MAX_FIRST_NAME + MAX_MIDDLE_NAME + 2);
    full_name = (gchar *)g_malloc0(MAX_FULL_NAME);
    item = (gchar *)g_malloc0(MAX_FULL_NAME + MAX_FIRM_NAME + 5);

    /* Tworzenie penego imienia na podstawie imienia i drgiego imienia. */
    if (strcmp(data->first_name, "") != 0 &&
        strcmp(data->middle_name, "") != 0)
    {
        strcpy(full_first_name, data->first_name);
	strcat(full_first_name, " ");
	strcat(full_first_name, data->middle_name);
    }
    else
        if (strcmp(data->first_name, "") != 0)
	    strcpy(full_first_name, data->first_name);
	else
	    if (strcmp(data->middle_name, "") != 0)
	        strcpy(full_first_name, data->middle_name);
	    else
	        strcpy(full_first_name, "");

    /* Tworzenie elementw listy wyboru. */
    if (strcmp(full_first_name, "") != 0 && strcmp(data->last_name, "") != 0)
    {
	/* Trojanowski, Tomasz Marcin */
	strcpy(full_name, data->last_name);
	strcat(full_name, ", ");
	strcat(full_name, full_first_name);
	
	list = g_list_append(list, (gpointer)g_strdup(full_name));

        /* Tomasz Marcin Trojanowski */
        strcpy(item, full_first_name);
	strcat(item, " ");
	strcat(item, data->last_name);
	
	list = g_list_append(list, (gpointer)g_strdup(item));
    }
    else
        if (strcmp(data->last_name, "") != 0)
	{
	    /* Trojanowski */
	    strcpy(full_name, data->last_name);
	    
	    list = g_list_append(list, (gpointer)g_strdup(full_name));
	}
    
    /* Uninet Polska */
    if (strcmp(data->firm_name, "") != 0)
        list = g_list_append(list, (gpointer)g_strdup(data->firm_name));

    if (strcmp(full_name, "") != 0 && strcmp(data->firm_name, ""))
    {
        /* Trojanowski, Tomasz Marcin (Uninet Polska) */
	strcpy(item, full_name);
	strcat(item, " (");
	strcat(item, data->firm_name);
	strcat(item, ")");
	
	list = g_list_append(list, (gpointer)g_strdup(item));
	
	/* Uninet Polska (Trojanowski, Tomasz Marcin) */
	strcpy(item, data->firm_name);
	strcat(item, " (");
	strcat(item, full_name);
	strcat(item, ")");
	
	list = g_list_append(list, (gpointer)g_strdup(item));
    }

    /* Wstawienie nowej listy do pola wyboru. */
    entry = gtk_object_get_data(GTK_OBJECT(data->contact_window),
                                "save_as_combo");
    gtk_combo_set_popdown_strings(GTK_COMBO(entry), list);

    /* Zwalnianie pamici zajmowanej przez elemnty listy. */
    g_list_foreach(list, free_list_item_callback, NULL);
    
    /* Zwolnienie pamici zajmowanej przez list. */
    g_list_free(list);
    
    /* Zwolnienie pamici zajmowanej przez zmienne pomocnicze. */
    g_free(full_first_name);
    g_free(full_name);
    g_free(item);
}

#define MAX_FULL_ADDRESS  (MAX_STREET + MAX_CITY + MAX_STATE + MAX_ZIP + MAX_COUNTRY + 10)

/* Funkcja tworzca peny adres na podstawie poszczeglnych jego elementw,
   a nastepnie wstawiajca t warto do pola tekstowego adresu okienka
   kontaktu. */
void create_full_address(contact_data *data)
{
    GtkWidget *entry;
    gchar *full_address;
    
    /* Utworzenie i wypenienie zerami zmiennej pomocniczej sucej do
       tworzenia penego adresu. */
    full_address = (gchar *)g_malloc0(MAX_FULL_ADDRESS);
    
    if (strcmp(data->address[data->address_type].street, "") != 0)
    {
        strcat(full_address, data->address[data->address_type].street);
	strcat(full_address, "\n");
    }
    
    if (strcmp(data->address[data->address_type].city, "") != 0)
    {
        if (strcmp(data->address[data->address_type].zip, "") != 0)
	{
	    strcat(full_address, data->address[data->address_type].zip);
	    strcat(full_address, " ");
	}
	strcat(full_address, data->address[data->address_type].city);
	strcat(full_address, "\n");
    }
    
    if (strcmp(data->address[data->address_type].state, "") != 0)
    {
        strcat(full_address, "woj. ");
	strcat(full_address, data->address[data->address_type].state);
	strcat(full_address, "\n");
    }
    
    if (strcmp(data->address[data->address_type].country, "") != 0)
    {
        strcat(full_address, data->address[data->address_type].country);
	strcat(full_address, "\n");
    }
    
    /* Wstawienie penego adresu do pola tekstowego adresu. */
    entry = gtk_object_get_data(GTK_OBJECT(data->contact_window),
                                "full_address");
    gtk_text_backward_delete(GTK_TEXT(entry),
                             gtk_text_get_point(GTK_TEXT(entry)));
    gtk_text_insert(GTK_TEXT(entry), NULL, NULL, NULL,
                    full_address, strlen(full_address));
    
    g_free(full_address);
}

#define MAX_FULL_PHONE  (MAX_PHONE_COUNTRY + MAX_PHONE_REGION + MAX_PHONE_NUMBER + 5)

/* Funkcja zwracajca wskanik do acucha zawierajacego peny numer telefonu na podstawie
   poszczeglnych jego elementw. */
gchar *get_full_phone(contact_data *data, phone_type_enum phone_type)
{
    gchar *full_phone;
    gboolean is_space = TRUE;
    
    g_assert(data != NULL);

    /* Utworzenie i wypenienie zerami zmiennej pomocniczej sucej do tworzenia penego
       numeru telefonu. */
    full_phone = (gchar *)g_malloc0(MAX_FULL_PHONE);
    
    /* Tworzenie penego numetu telefonu. */
    if (strcmp(data->phone[phone_type].country, "") != 0)
    {
        strcat(full_phone, data->phone[phone_type].country);
	is_space = FALSE;
    }
    
    if (strcmp(data->phone[phone_type].region, "") != 0)
    {
        if (!is_space)
	    strcat(full_phone, " (");
	else
            strcat(full_phone, "(");
        strcat(full_phone, data->phone[phone_type].region);
	strcat(full_phone, ")");
	is_space = FALSE;
    }
    
    if (strcmp(data->phone[phone_type].number, "") != 0)
    {
        if (!is_space)
	    strcat(full_phone, " ");
	strcat(full_phone, data->phone[phone_type].number);
    }

    return full_phone;
}

/* Funkcja tworzca peny numer telefonu na podstawie poszczeglnych jego
   elementw, a nastepnie wstawiajca t warto do pola tekstowego numeru
   telefonu okienka kontaktu. */
void create_full_phone(contact_data *data, guint phone_pos)
{
    gchar *full_phone;
    gchar *phone_key;
    GtkWidget *entry;
    
    g_assert(data != NULL);

    /* Utworzenie penego numeru telefonu. */
    full_phone = get_full_phone(data, data->phone_type[phone_pos]);
    
    /* Wstawienie penego numeru telefonu do pola edycji. */
    if (phone_pos <= 3)
    {
        phone_key = g_strdup_printf("phone%d", phone_pos);
	
	entry = gtk_object_get_data(GTK_OBJECT(data->contact_window), phone_key);
        gtk_entry_set_text(GTK_ENTRY(entry), full_phone);
	
	g_free(phone_key);
    }
    
    g_free(full_phone);
}
