
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */


#include <roy.h>

RNode *
rnode_new_child_append  (RNode *parent, RBuf *type, 
                         RBuf **err)
{
    RNode *node;

    node = rchunk_alloc (sizeof (RNode));
    if (rbuf_owned (type)) {
        node->type = rbuf_new_with_rbuf (type);
    } else {
        node->type = type;
    }
    rbuf_own (node->type);
    rbuf_set_rdonly (node->type);

    RDEBUG (("rnode_new", "Creating new node of type %b", type));

    node->children = rlist_new ();

    node->parent = parent;
    node->attribs = rbhash_new ();
    node->flags = 0;
    node->refcount = 1;
    node->kvs = NULL;
    node->user_data = NULL;

   
    if (parent) {
        rlist_append (parent->children, node);
    }

    return (node);
}


