/* -*-objc-*-
 */

#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>

#import "RSSFeedList.h"

@interface MyDelegate : NSObject
{
  NSToolbar*      toolbar;
  NSWindow*       window;
  NSTableView*    tableView;
  NSSplitView*    splitView;
  NSScrollView*   scrollView;

  id /* NSView* */ articleView;
  
  NSTableColumn*  feedColumn;
  NSTableColumn*  headlineColumn;
  NSTableColumn*  dateColumn;
  
  NSString*       myStoreFile;
  
  RSSFeedList*    myFeeds;
}

- (void) dealloc;

- (void) initRSSFeeds;

- (void) openHomepage: (id) sender;

- (void) saveStatus: (id)sender;
- (void) buildMenu;
- (void) reloadTable;
- (void) buildWindow;
- (void) applicationDidFinishLaunching: (NSNotification*)not;
- (void) applicationWillFinishLaunching: (NSNotification *) not;

- (void) windowDidLoad: (NSNotification*) aNotification;

- (NSString*) storeFile;

- (void) setArticle: (RSSArticle*) article;
- (RSSFeedList*) RSSFeeds;

@end
