# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Graph
  module Models
    #
    # The properties of an Active Directory object.
    #
    class AADObject

      include MsRestAzure

      # @return [String] The ID of the object.
      attr_accessor :object_id

      # @return [String] The type of AAD object.
      attr_accessor :object_type

      # @return [String] The display name of the object.
      attr_accessor :display_name

      # @return [String] The principal name of the object.
      attr_accessor :user_principal_name

      # @return [String] The primary email address of the object.
      attr_accessor :mail

      # @return [Boolean] Whether the AAD object is mail-enabled.
      attr_accessor :mail_enabled

      # @return [Boolean] Whether the AAD object is security-enabled.
      attr_accessor :security_enabled

      # @return [String] The sign-in name of the object.
      attr_accessor :sign_in_name

      # @return [Array<String>] A collection of service principal names
      # associated with the object.
      attr_accessor :service_principal_names

      # @return [String] The user type of the object.
      attr_accessor :user_type


      #
      # Mapper for AADObject class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'AADObject',
          type: {
            name: 'Composite',
            class_name: 'AADObject',
            model_properties: {
              object_id: {
                required: false,
                serialized_name: 'objectId',
                type: {
                  name: 'String'
                }
              },
              object_type: {
                required: false,
                serialized_name: 'objectType',
                type: {
                  name: 'String'
                }
              },
              display_name: {
                required: false,
                serialized_name: 'displayName',
                type: {
                  name: 'String'
                }
              },
              user_principal_name: {
                required: false,
                serialized_name: 'userPrincipalName',
                type: {
                  name: 'String'
                }
              },
              mail: {
                required: false,
                serialized_name: 'mail',
                type: {
                  name: 'String'
                }
              },
              mail_enabled: {
                required: false,
                serialized_name: 'mailEnabled',
                type: {
                  name: 'Boolean'
                }
              },
              security_enabled: {
                required: false,
                serialized_name: 'securityEnabled',
                type: {
                  name: 'Boolean'
                }
              },
              sign_in_name: {
                required: false,
                serialized_name: 'signInName',
                type: {
                  name: 'String'
                }
              },
              service_principal_names: {
                required: false,
                serialized_name: 'servicePrincipalNames',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              user_type: {
                required: false,
                serialized_name: 'userType',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
