# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Resources
  #
  # Provides operations for working with resources and resource groups.
  #
  class Deployments
    include Azure::ARM::Resources::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Deployments class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ResourceManagementClient] reference to the ResourceManagementClient
    attr_reader :client

    #
    # Deletes a deployment from the deployment history.
    #
    # A template deployment that is currently running cannot be deleted. Deleting a
    # template deployment removes the associated deployment operations. Deleting a
    # template deployment does not affect the state of the resource group. This is
    # an asynchronous operation that returns a status of 202 until the template
    # deployment is successfully deleted. The Location response header contains the
    # URI that is used to obtain the status of the process. While the process is
    # running, a call to the URI in the Location header returns a status of 202.
    # When the process finishes, the URI in the Location header returns a status of
    # 204 on success. If the asynchronous request failed, the URI in the Location
    # header returns an error-level status code.
    #
    # @param resource_group_name [String] The name of the resource group with the
    # deployment to delete. The name is case insensitive.
    # @param deployment_name [String] The name of the deployment to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, deployment_name, custom_headers = nil)
      response = delete_async(resource_group_name, deployment_name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group with the
    # deployment to delete. The name is case insensitive.
    # @param deployment_name [String] The name of the deployment to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, deployment_name, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, deployment_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Checks whether the deployment exists.
    #
    # @param resource_group_name [String] The name of the resource group with the
    # deployment to check. The name is case insensitive.
    # @param deployment_name [String] The name of the deployment to check.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Boolean] operation results.
    #
    def check_existence(resource_group_name, deployment_name, custom_headers = nil)
      response = check_existence_async(resource_group_name, deployment_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Checks whether the deployment exists.
    #
    # @param resource_group_name [String] The name of the resource group with the
    # deployment to check. The name is case insensitive.
    # @param deployment_name [String] The name of the deployment to check.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def check_existence_with_http_info(resource_group_name, deployment_name, custom_headers = nil)
      check_existence_async(resource_group_name, deployment_name, custom_headers).value!
    end

    #
    # Checks whether the deployment exists.
    #
    # @param resource_group_name [String] The name of the resource group with the
    # deployment to check. The name is case insensitive.
    # @param deployment_name [String] The name of the deployment to check.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def check_existence_async(resource_group_name, deployment_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'deployment_name is nil' if deployment_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'deploymentName' => deployment_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:head, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.body = (status_code == 204)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Deploys resources to a resource group.
    #
    # You can provide the template and parameters directly in the request or link
    # to JSON files.
    #
    # @param resource_group_name [String] The name of the resource group to deploy
    # the resources to. The name is case insensitive. The resource group must
    # already exist.
    # @param deployment_name [String] The name of the deployment.
    # @param parameters [Deployment] Additional parameters supplied to the
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentExtended] operation results.
    #
    def create_or_update(resource_group_name, deployment_name, parameters, custom_headers = nil)
      response = create_or_update_async(resource_group_name, deployment_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group to deploy
    # the resources to. The name is case insensitive. The resource group must
    # already exist.
    # @param deployment_name [String] The name of the deployment.
    # @param parameters [Deployment] Additional parameters supplied to the
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, deployment_name, parameters, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, deployment_name, parameters, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = DeploymentExtended.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets a deployment.
    #
    # @param resource_group_name [String] The name of the resource group. The name
    # is case insensitive.
    # @param deployment_name [String] The name of the deployment to get.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentExtended] operation results.
    #
    def get(resource_group_name, deployment_name, custom_headers = nil)
      response = get_async(resource_group_name, deployment_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a deployment.
    #
    # @param resource_group_name [String] The name of the resource group. The name
    # is case insensitive.
    # @param deployment_name [String] The name of the deployment to get.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, deployment_name, custom_headers = nil)
      get_async(resource_group_name, deployment_name, custom_headers).value!
    end

    #
    # Gets a deployment.
    #
    # @param resource_group_name [String] The name of the resource group. The name
    # is case insensitive.
    # @param deployment_name [String] The name of the deployment to get.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, deployment_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'deployment_name is nil' if deployment_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'deploymentName' => deployment_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentExtended.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Cancels a currently running template deployment.
    #
    # You can cancel a deployment only if the provisioningState is Accepted or
    # Running. After the deployment is canceled, the provisioningState is set to
    # Canceled. Canceling a template deployment stops the currently running
    # template deployment and leaves the resource group partially deployed.
    #
    # @param resource_group_name [String] The name of the resource group. The name
    # is case insensitive.
    # @param deployment_name [String] The name of the deployment to cancel.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def cancel(resource_group_name, deployment_name, custom_headers = nil)
      response = cancel_async(resource_group_name, deployment_name, custom_headers).value!
      nil
    end

    #
    # Cancels a currently running template deployment.
    #
    # You can cancel a deployment only if the provisioningState is Accepted or
    # Running. After the deployment is canceled, the provisioningState is set to
    # Canceled. Canceling a template deployment stops the currently running
    # template deployment and leaves the resource group partially deployed.
    #
    # @param resource_group_name [String] The name of the resource group. The name
    # is case insensitive.
    # @param deployment_name [String] The name of the deployment to cancel.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def cancel_with_http_info(resource_group_name, deployment_name, custom_headers = nil)
      cancel_async(resource_group_name, deployment_name, custom_headers).value!
    end

    #
    # Cancels a currently running template deployment.
    #
    # You can cancel a deployment only if the provisioningState is Accepted or
    # Running. After the deployment is canceled, the provisioningState is set to
    # Canceled. Canceling a template deployment stops the currently running
    # template deployment and leaves the resource group partially deployed.
    #
    # @param resource_group_name [String] The name of the resource group. The name
    # is case insensitive.
    # @param deployment_name [String] The name of the deployment to cancel.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def cancel_async(resource_group_name, deployment_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'deployment_name is nil' if deployment_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'deploymentName' => deployment_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Validates whether the specified template is syntactically correct and will be
    # accepted by Azure Resource Manager..
    #
    # @param resource_group_name [String] The name of the resource group the
    # template will be deployed to. The name is case insensitive.
    # @param deployment_name [String] The name of the deployment.
    # @param parameters [Deployment] Parameters to validate.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentValidateResult] operation results.
    #
    def validate(resource_group_name, deployment_name, parameters, custom_headers = nil)
      response = validate_async(resource_group_name, deployment_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Validates whether the specified template is syntactically correct and will be
    # accepted by Azure Resource Manager..
    #
    # @param resource_group_name [String] The name of the resource group the
    # template will be deployed to. The name is case insensitive.
    # @param deployment_name [String] The name of the deployment.
    # @param parameters [Deployment] Parameters to validate.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def validate_with_http_info(resource_group_name, deployment_name, parameters, custom_headers = nil)
      validate_async(resource_group_name, deployment_name, parameters, custom_headers).value!
    end

    #
    # Validates whether the specified template is syntactically correct and will be
    # accepted by Azure Resource Manager..
    #
    # @param resource_group_name [String] The name of the resource group the
    # template will be deployed to. The name is case insensitive.
    # @param deployment_name [String] The name of the deployment.
    # @param parameters [Deployment] Parameters to validate.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def validate_async(resource_group_name, deployment_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'deployment_name is nil' if deployment_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Deployment.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/validate'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'deploymentName' => deployment_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 400
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentValidateResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 400
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentValidateResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Exports the template used for specified deployment.
    #
    # @param resource_group_name [String] The name of the resource group. The name
    # is case insensitive.
    # @param deployment_name [String] The name of the deployment from which to get
    # the template.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentExportResult] operation results.
    #
    def export_template(resource_group_name, deployment_name, custom_headers = nil)
      response = export_template_async(resource_group_name, deployment_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Exports the template used for specified deployment.
    #
    # @param resource_group_name [String] The name of the resource group. The name
    # is case insensitive.
    # @param deployment_name [String] The name of the deployment from which to get
    # the template.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def export_template_with_http_info(resource_group_name, deployment_name, custom_headers = nil)
      export_template_async(resource_group_name, deployment_name, custom_headers).value!
    end

    #
    # Exports the template used for specified deployment.
    #
    # @param resource_group_name [String] The name of the resource group. The name
    # is case insensitive.
    # @param deployment_name [String] The name of the deployment from which to get
    # the template.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def export_template_async(resource_group_name, deployment_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'deployment_name is nil' if deployment_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'deploymentName' => deployment_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentExportResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all the deployments for a resource group.
    #
    # @param resource_group_name [String] The name of the resource group with the
    # deployments to get. The name is case insensitive.
    # @param filter [String] The filter to apply on the operation. For example, you
    # can use $filter=provisioningState eq '{state}'.
    # @param top [Integer] The number of results to get. If null is passed, returns
    # all deployments.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<DeploymentExtended>] operation results.
    #
    def list(resource_group_name, filter = nil, top = nil, custom_headers = nil)
      first_page = list_as_lazy(resource_group_name, filter, top, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all the deployments for a resource group.
    #
    # @param resource_group_name [String] The name of the resource group with the
    # deployments to get. The name is case insensitive.
    # @param filter [String] The filter to apply on the operation. For example, you
    # can use $filter=provisioningState eq '{state}'.
    # @param top [Integer] The number of results to get. If null is passed, returns
    # all deployments.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, filter = nil, top = nil, custom_headers = nil)
      list_async(resource_group_name, filter, top, custom_headers).value!
    end

    #
    # Get all the deployments for a resource group.
    #
    # @param resource_group_name [String] The name of the resource group with the
    # deployments to get. The name is case insensitive.
    # @param filter [String] The filter to apply on the operation. For example, you
    # can use $filter=provisioningState eq '{state}'.
    # @param top [Integer] The number of results to get. If null is passed, returns
    # all deployments.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, filter = nil, top = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'$top' => top,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a deployment from the deployment history.
    #
    # A template deployment that is currently running cannot be deleted. Deleting a
    # template deployment removes the associated deployment operations. Deleting a
    # template deployment does not affect the state of the resource group. This is
    # an asynchronous operation that returns a status of 202 until the template
    # deployment is successfully deleted. The Location response header contains the
    # URI that is used to obtain the status of the process. While the process is
    # running, a call to the URI in the Location header returns a status of 202.
    # When the process finishes, the URI in the Location header returns a status of
    # 204 on success. If the asynchronous request failed, the URI in the Location
    # header returns an error-level status code.
    #
    # @param resource_group_name [String] The name of the resource group with the
    # deployment to delete. The name is case insensitive.
    # @param deployment_name [String] The name of the deployment to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, deployment_name, custom_headers = nil)
      response = begin_delete_async(resource_group_name, deployment_name, custom_headers).value!
      nil
    end

    #
    # Deletes a deployment from the deployment history.
    #
    # A template deployment that is currently running cannot be deleted. Deleting a
    # template deployment removes the associated deployment operations. Deleting a
    # template deployment does not affect the state of the resource group. This is
    # an asynchronous operation that returns a status of 202 until the template
    # deployment is successfully deleted. The Location response header contains the
    # URI that is used to obtain the status of the process. While the process is
    # running, a call to the URI in the Location header returns a status of 202.
    # When the process finishes, the URI in the Location header returns a status of
    # 204 on success. If the asynchronous request failed, the URI in the Location
    # header returns an error-level status code.
    #
    # @param resource_group_name [String] The name of the resource group with the
    # deployment to delete. The name is case insensitive.
    # @param deployment_name [String] The name of the deployment to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, deployment_name, custom_headers = nil)
      begin_delete_async(resource_group_name, deployment_name, custom_headers).value!
    end

    #
    # Deletes a deployment from the deployment history.
    #
    # A template deployment that is currently running cannot be deleted. Deleting a
    # template deployment removes the associated deployment operations. Deleting a
    # template deployment does not affect the state of the resource group. This is
    # an asynchronous operation that returns a status of 202 until the template
    # deployment is successfully deleted. The Location response header contains the
    # URI that is used to obtain the status of the process. While the process is
    # running, a call to the URI in the Location header returns a status of 202.
    # When the process finishes, the URI in the Location header returns a status of
    # 204 on success. If the asynchronous request failed, the URI in the Location
    # header returns an error-level status code.
    #
    # @param resource_group_name [String] The name of the resource group with the
    # deployment to delete. The name is case insensitive.
    # @param deployment_name [String] The name of the deployment to delete.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, deployment_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'deployment_name is nil' if deployment_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'deploymentName' => deployment_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Deploys resources to a resource group.
    #
    # You can provide the template and parameters directly in the request or link
    # to JSON files.
    #
    # @param resource_group_name [String] The name of the resource group to deploy
    # the resources to. The name is case insensitive. The resource group must
    # already exist.
    # @param deployment_name [String] The name of the deployment.
    # @param parameters [Deployment] Additional parameters supplied to the
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentExtended] operation results.
    #
    def begin_create_or_update(resource_group_name, deployment_name, parameters, custom_headers = nil)
      response = begin_create_or_update_async(resource_group_name, deployment_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deploys resources to a resource group.
    #
    # You can provide the template and parameters directly in the request or link
    # to JSON files.
    #
    # @param resource_group_name [String] The name of the resource group to deploy
    # the resources to. The name is case insensitive. The resource group must
    # already exist.
    # @param deployment_name [String] The name of the deployment.
    # @param parameters [Deployment] Additional parameters supplied to the
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, deployment_name, parameters, custom_headers = nil)
      begin_create_or_update_async(resource_group_name, deployment_name, parameters, custom_headers).value!
    end

    #
    # Deploys resources to a resource group.
    #
    # You can provide the template and parameters directly in the request or link
    # to JSON files.
    #
    # @param resource_group_name [String] The name of the resource group to deploy
    # the resources to. The name is case insensitive. The resource group must
    # already exist.
    # @param deployment_name [String] The name of the deployment.
    # @param parameters [Deployment] Additional parameters supplied to the
    # operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, deployment_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'deployment_name is nil' if deployment_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Deployment.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'deploymentName' => deployment_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentExtended.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentExtended.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all the deployments for a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentListResult] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all the deployments for a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all the deployments for a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all the deployments for a resource group.
    #
    # @param resource_group_name [String] The name of the resource group with the
    # deployments to get. The name is case insensitive.
    # @param filter [String] The filter to apply on the operation. For example, you
    # can use $filter=provisioningState eq '{state}'.
    # @param top [Integer] The number of results to get. If null is passed, returns
    # all deployments.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentListResult] which provide lazy access to pages of the
    # response.
    #
    def list_as_lazy(resource_group_name, filter = nil, top = nil, custom_headers = nil)
      response = list_async(resource_group_name, filter, top, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
