require 'runit/testcase'
require 'runit/cui/testrunner'
require 'runit/ext/testdecorator'
require 'dummytestcase'

class DummyTest < RUNIT::TestCase
  def test_foo
  end
  def test_bar
  end
end

class TestTestSuite < RUNIT::TestCase
  def setup
    @testsuite = RUNIT::TestSuite.new
  end

  def test_count_test_cases
    assert_equal(0, @testsuite.count_test_cases)

    @testsuite.add(DummyEmptyTest.suite)
    assert_equal(0, @testsuite.count_test_cases)

    @testsuite.add(DummyTest.suite)
    assert_equal(2, @testsuite.count_test_cases)

    @testsuite.add(DummyTest.suite)
    assert_equal(4, @testsuite.count_test_cases)

    dummytest_foo = DummyTest.new('test_foo')
    @testsuite.add(dummytest_foo)
    assert_equal(5, @testsuite.count_test_cases)
  end

  def test_add
    @testsuite.add(DummyEmptyTest.suite)
    assert_equal(0, @testsuite.size)
    assert_equal(0, @testsuite.count_test_cases)

    @testsuite.add(DummyTest.suite)
    assert_equal(2, @testsuite.size)
    assert_equal(2, @testsuite.count_test_cases)

    decorated_test = DummyTestDecorator.new(DummyTest.suite)

    @testsuite.add(decorated_test)
    assert_equal(3, @testsuite.size)
    assert_equal(4, @testsuite.count_test_cases)

    decorated_test = DummyTestDecorator.new(DummyEmptyTest.suite)
    @testsuite.add(decorated_test)
    assert_equal(4, @testsuite.size)
    assert_equal(4, @testsuite.count_test_cases)
  end

  def test_add_check_order
    @testsuite.add(DummyTest.new('test_foo'))
    @testsuite.add(DummyTest.new('test_bar'))

    exp_s = ['DummyTest#test_foo', 'DummyTest#test_bar']
    @testsuite.each_with_index do |test, i|
      assert_equal(exp_s[i], test.name)
    end
  end

  def test_decorated
    suite = DummyTestTestDecorated.suite
    assert_equal(0, DummyTestTestDecorated.decorated)
    suite.decorated(DummyTestDecorator)
    assert_equal(1, DummyTestTestDecorated.decorated)

    suite = DummyTestTestDecorated.suite
    assert_equal(0, DummyTestTestDecoratedWithoutDecorated.decorated)
    suite.decorated(DummyTestDecorator)
    assert_equal(0, DummyTestTestDecoratedWithoutDecorated.decorated)
  end

end

if $0 == __FILE__
  RUNIT::CUI::TestRunner.run(TestTestSuite.suite)
end

