/*
 * Copyright 1995,96 Thierry Bousch
 * Licensed under the Gnu Public License, Version 2
 *
 * $Id: saml.h,v 3.3 1996/09/13 16:20:19 bousch Exp $
 *
 * Public interface of SAML (Simple Algebraic Math Library).
 */

#ifndef _SAML_H
#define _SAML_H

#include <stddef.h>
#include "saml-mtypes.h"

/* Operations on mrefs */

typedef int mref_t;

void saml_init (void);
mref_t mref_new (void);
void mref_free (mref_t mr);
char* mref_string (mref_t mr);
int mref_type (mref_t mr);
const char* mref_stype (mref_t mr);

int mref_length (mref_t arr);
int mref_array (mref_t arr, int type, mref_t length);
int mref_getitem (mref_t mr, mref_t arr, mref_t i);	/* mr = arr[i]  */
int mref_setitem (mref_t arr, mref_t i, mref_t mr);	/* arr[i] = mr	*/
int mref_build (mref_t mr, int t, const char*);		/* mr = string  */
int mref_cast (mref_t mr, int t);
int mref_promote (mref_t mr, mref_t mr1);

void mref_copy (mref_t mr, mref_t mr1);			/* mr = mr1     */
void mref_swap (mref_t mr1, mref_t mr2);
int mref_add (mref_t mr, mref_t mr1, mref_t mr2);	/* mr = mr1+mr2 */
int mref_sub (mref_t mr, mref_t mr1, mref_t mr2);	/* mr = mr1-mr2 */
int mref_mul (mref_t mr, mref_t mr1, mref_t mr2);	/* mr = mr1*mr2 */
int mref_div (mref_t mr, mref_t mr1, mref_t mr2);	/* mr = mr1/mr2 */
int mref_mod (mref_t mr, mref_t mr1, mref_t mr2);	/* mr = mr1%mr2 */
int mref_gcd (mref_t mr, mref_t mr1, mref_t mr2);	/* mr = mr1&mr2 */
int mref_invert (mref_t mr, mref_t mr1);		/* mr = 1/mr1   */
int mref_negate (mref_t mr, mref_t mr1);		/* mr = -mr1    */
int mref_zero (mref_t mr, mref_t mr1);			/* mr = 0       */
int mref_one  (mref_t mr, mref_t mr1);			/* mr = 1       */
int mref_notzero (mref_t mr);
int mref_isneg (mref_t mr);
int mref_differ (mref_t mr1, mref_t mr2);
int mref_lessthan (mref_t mr1, mref_t mr2);
int mref_power (mref_t mr, mref_t mr1, int power);
int mref_sqrt (mref_t mr, mref_t mr1);

/* Type-specific operations */

int mref_error (mref_t result, int errno, const char *where);
int mref_subs (mref_t result, mref_t expr, mref_t e1, mref_t e2);
int mref_det (mref_t result, mref_t matrix);
int mref_elim (mref_t result, mref_t lit, mref_t e1, mref_t e2);
int mref_diff (mref_t result, mref_t expr, mref_t lit);
int parse_poly (mref_t result, int type, const char* start, size_t len);
int mref_move_lit (mref_t result, mref_t expr, mref_t lit1, mref_t lit2);

/* Parsing */

int saml_parse (mref_t result, mref_t model);

/* Debugging */

extern long nb_mnodes_allocated;
extern long nb_mnodes_freed;
extern long nb_mnodes_reserved;

/* Error handling */

extern void (*saml_error_handler)(int reason, const char *where);
extern int saml_errors;
const char *saml_strerror (int reason);

void saml_default_ehandler (int, const char *);
void saml_fatal_ehandler (int, const char *);
void saml_silent_ehandler (int, const char *);

#endif	/* _SAML_H */
