#!/usr/local/bin/python

from saml1 import Mathnode, ST_INTEGER, ST_APOLY, MnAllocStats
from string import atoi
from sys import argv, stderr, exit

def arrg(m,n):
  zero = Mathnode(ST_INTEGER,'0').cast(ST_APOLY)
  one = zero.one()
  def c1(i,j,z=zero):
    return z.parse('c1[%d,%d]' % (i,j))
  def c2(i,j,z=zero):
    return z.parse('c2[%d,%d]' % (i,j))
  def c3(i,j,z=zero):
    return z.parse('c3[%d,%d]' % (i,j))
  r = one
  for i in range(m):
    for j in range(n):
      r = r.subs(c1(i,j-1),zero).subs(c1(i-1,j),zero) * c1(i,j) + \
          r.subs(c2(i,j-1),zero).subs(c2(i-1,j),zero) * c2(i,j) + \
          r.subs(c3(i,j-1),zero).subs(c3(i-1,j),zero) * c3(i,j)
      r = r.subs(c1(i-1,j),one).subs(c2(i-1,j),one).subs(c3(i-1,j),one)
  for i in range(m):
    for j in range(n):
      r = r.subs(c1(i,j),one).subs(c2(i,j),one).subs(c3(i,j),one)
  return r

def main():
  if len(argv) != 3:
    stderr.write('Usage: %s lines columns\n' % argv[0])
    exit(1)
  print arrg(atoi(argv[1]), atoi(argv[2]))
  print 'Allocated-reserved-freed mnodes = %d-%d-%d' % MnAllocStats()

if __name__ == '__main__':
  main()
