### francais.tcl:
#
# French language support for Scid.
# Translations contributed by: Gilles Maire, Vincent Serisier, Joel Rivat.

addLanguage F Francais 0

proc setLanguage_F {} {

# File menu:
menuText F File "Fichier" 0
menuText F FileNew "Nouvelle..." 0 {Crer une nouvelle base de donnes Scid}
menuText F FileOpen "Ouvrir..." 0 {Ouvrir une base de donnes Scid existante}
menuText F FileClose "Fermer" 0 {Fermer la base de donnes Scid active}
menuText F FileFinder "Finder" 0 {Open the File Finder window} ;# ***
menuText F FileBookmarks "Bookmarks" 0 {Bookmarks menu (shortcut: Ctrl+B)} ;# ***
menuText F FileBookmarksAdd "Add bookmark" 0 \
  {Bookmark the current database game and position} ;# ***
menuText F FileBookmarksFile "File bookmark" 0 \
  {File a bookmark for the current game and position} ;# ***
menuText F FileBookmarksEdit "Edit bookmarks..." 0 \
  {Edit the bookmarks menus} ;# ***
menuText F FileBookmarksList "Display folders as single list" 0 \
  {Display bookmark folders as a single list, not submenus} ;# ***
menuText F FileBookmarksSub "Display folders as submenus" 0 \
  {Display bookmark folders as submenus, not a single list} ;# ***
menuText F FileMaint "Maintenance" 0
menuText F FileMaintWin "Maintenance fentre" 0 \
  {Ouvrir/Fermer la fentre de maintenance de}
menuText F FileMaintCompact "Compacter la base..." 0 \
  {Compacter la base: supprimer la parties effaces et les noms non utiliss}
menuText F FileMaintClass "ECO-Classifier les parties" 2 \
  {Recalculer le code ECO de toutes les parties}
menuText F FileMaintSort "Trier la base..." 0 {Trier toutes les parties de la base}
menuText F FileMaintDelete "Purge des doublons..." 0 \
  {Trouver les parties en doublons et les marquer pour l'effacement}
menuText F FileMaintTwin "Trouver les doublons" 0 \
  {Ouvrir/Actualiser la fentre de recherche de doublons}
menuText F FileMaintName "Orthographie des noms" 0 {Edition des noms et outils orthographiques}
menuText F FileMaintNameEditor "diteur de noms" 11 {Ouvrir/Fermer l'diteur de noms}
menuText F FileMaintNamePlayer "Corriger les noms de joueurs..." 21 \
  {Vrifier l'orthographe des noms de joueurs}
menuText F FileMaintNameEvent "Corriger les vnements..." 14 \
  {Vrifier l'orthographe des noms d'vnements}
menuText F FileMaintNameSite "Corriger les noms de lieux.." 21 \
  {Vrifier l'orthographe des noms de lieux}
menuText F FileMaintNameRound "Corriger les noms des rondes..." 22 \
  {Vrifier l'orthographe des noms de rondes}
menuText F FileReadOnly "Lecture seule..." 0 \
  {Traite la base courante en lecture seule, en empchant les changements}
menuText F FileExit "Quitter" 0 {Quitter Scid}

# Edit menu:
menuText F Edit "Editer" 0
menuText F EditAdd "Ajouter variante" 0 {Ajouter une variante}
menuText F EditDelete "Effacer variante" 0 {Effacer cette variante}
menuText F EditFirst "Dplacer en tte" 0 \
  {Dplacer cette variante en tte de liste}
menuText F EditMain "Variante vers ligne principale" 13 \
   {Promouvoir une variante en ligne principale}
menuText F EditTrial "Essai variante" 0 \
  {Dmarrer/Stopper mode d'essai, pour tester une ide sur l'chiquier}
menuText F EditStrip "Strip" 2 {Strip comments or variations from this game} ;# ***
menuText F EditStripComments "Comments" 0 \
  {Strip all comments and annotations from this game} ;# ***
menuText F EditStripVars "Variantes" 0 {Strip all variations from this game} ;# ***
menuText F EditReset "Vider la clipbase" 0 {Vider le presse-papier}
menuText F EditCopy "Copier dans la clipbase" 0 \
  {Copier la partie en cours dans le presse-papier}
menuText F EditPaste "Coller depuis la clipbase" 1 \
  {Copie la partie contenue dans le presse papier  cet emplacement}
menuText F EditSetup "Position de dpart" 0 \
  {Choisir une position de dpart pour cette partie}
menuText F EditPasteBoard "Coller la position de dpart" 12 \
  {Initialise la position de dpart  partir de la slection de texte courante(presse-papier)}

# Game menu:
menuText F Game "Partie" 0
menuText F GameNew "Rinitialiser la partie" 2 \
  {Remettre  zro la partie}
menuText F GameFirst "Charge la premire partie" 5 {Charge la premire partie du filtre}
menuText F GamePrev "Partie prcdente" 7 \
  {Charger la partie prcdente du filtre}
menuText F GameReload "Recharger la partie" 2 \
  {Recharger la partie (les modifications ne seront pas sauvegardes)}
menuText F GameNext "Partie suivante" 7 {Charger la partie suivante du filtre}
menuText F GameLast "Charge la dernire partie" 5 {Charge la dernire partie du filtre}
menuText F GameNumber "Partie numro..." 9 \
  {Charger une partie en donnant son numro}
menuText F GameReplace "Enregistrer: Remplacer la partie..." 13 \
  {Enregistrer cette partie, en crasant l'ancienne version}
menuText F GameAdd "Enregistrer: Ajouter nouvelle partie..." 13 \
  {Enregistrer cette partie en tant que nouvelle partie dans la base}
menuText F GameDeepest "Identifier ouverture" 11 \
  {Trouver la partie la plus proche dans la nomenclature ECO}
menuText F GameGotoMove "Coup numero..." 6 \
  {Aller au coup spcifi dans la partie en cours}
menuText F GameNovelty "Trouver la nouveaut..." 7 \
  {Trouver le premier coup de la partie qui n'a pas t jou auparavant}

# Search menu:
menuText F Search "Rechercher" 0
menuText F SearchReset "Rinitialiser le filtre" 0 \
  {Remettre  zro le filtre (inclusion de toutes les parties)}
menuText F SearchNegate "Inverser le filtre" 0 \
  {Inverser le filtre}
menuText F SearchCurrent "Position..." 0 \
  {Rechercher la position en cours}
menuText F SearchHeader "Entte..." 0 \
  {Rechercher par entte (joueur, tournoi, etc) information}
menuText F SearchMaterial "Motifs" 0 \
  {Rechercher des motifs ou un matriel particulier sur l'chiquier}
menuText F SearchUsing "Utilisant un fichier d'options..." 0 \
  {Rechercher en utilisant un fichier d'options de recherche}

# Windows menu:
menuText F Windows "Fentres" 2
menuText F WindowsComment "Editeur de commentaires" 0 \
  {Ouvrir/fermer l'diteur de commentaires}
menuText F WindowsGList "Liste des parties" 0 \
  {Ouvrir/fermer la liste des parties}
menuText F WindowsPGN "Fentre PGN" 8 {Ouvrir/fermer la fentre PGN}
menuText F WindowsTmt "Tournament Finder" 0 {Open/close the tournament finder} ;# ***
menuText F WindowsSwitcher "Changer de base" 0 \
  {Ouvrir/Fermer l'outil de changement de base}
menuText F WindowsMaint "Maintenance fentre" 0 \
  {Ouvrir/Fermer la fentre de maintenance de fentre}
menuText F WindowsECO "Navigateur ECO" 0 {Ouvrir/fermer le navigateur ECO}
menuText F WindowsRepertoire "Editeur de rpertoire" 0 {Ouvrir/Fermer l'diteur de rpertoire}
menuText F WindowsStats "Fentre de statistique" 11 \
  {Ouvir/Fermer le filtre de statistiques}
menuText F WindowsTree "Fentre d'arbre" 10 \
  {Ouvrir/Fermer la fentre d'arbre}
menuText F WindowsTB "Fentre de tables de finales" 8 \
  {Ouvrir/Fermer la fentre de tables de finales}

# Tools menu:
menuText F Tools "Outils" 2
menuText F ToolsAnalysis "Moteur d'analyse..." 9 \
  {Dmarrer/Arrter un moteur d'analyses}
menuText F ToolsAnalysis2 "Moteur d'analyse #2..." 18 \
  {Dmarrer/Arrter un moteur d'analyses}
menuText F ToolsCross "Classement du tournoi" 0 \
  {Montrer le classement du tournoi}
menuText F ToolsEmail "Gestion des messages" 0 \
  {Ouvrir/fermer la fentre de gestion des messages lectroniques}
menuText F ToolsOpReport "Rapport d'ouverture" 0 \
  {Generer un rapport d'ouvertures  partir de la position courante}
menuText F ToolsPInfo "Information sur les joueurs"  0 \
  {Ouvrir/Mettre  jour la fentre d'information sur les joueurs}
menuText F ToolsRating "Elo graphique" 0 \
  {Tracer un graphique du classement Elo des joueurs de cette partie}
menuText F ToolsScore "Score graphique" 0 {Montrer le graphique des scores}
menuText F ToolsExpCurrent "Ecrire la partie en cours" 22 \
  {Ecrire la partie en cours dans un fichier texte}
menuText F ToolsExpCurrentPGN "Dans un fichier PGN..." 16 \
  {Ecrire la partie en cours dans un fichier PGN}
menuText F ToolsExpCurrentHTML "Dans un fichier HTML..." 16 \
  {Ecrire la partie en cours dans un fichier HTML}
menuText F ToolsExpCurrentLaTeX "Dans un fichier LaTeX..." 16 \
  {Ecrire la partie en cours dans un fichier LaTeX}
menuText F ToolsExpFilter "Ecrire le filtre " 2 \
  {Ecrire le filtre dans un fichier texte}
menuText F ToolsExpFilterPGN "Dans un fichier PGN..." 16 \
  {Ecrire le filtre dans un fichier PGN}
menuText F ToolsExpFilterHTML "Dans un fichier HTML..." 16 \
  {Ecrire le filtre dans un fichier HTML}
menuText F ToolsExpFilterLaTeX "Dans un fichier LaTeX..." 16 \
  {Ecrire le filtre dans un fichier LaTeX}
menuText F ToolsImportOne "Importer une partie en PGN..." 0 \
  {Importer une partie  partir d'un texte PGN}
menuText F ToolsImportFile "Importer un fichier en PGN..." 12 \
  {Importer des parties  partir d'un fichier PGN}

# Options menu:
menuText F Options "Options" 0
menuText F OptionsSize "Taille chiquier" 0 {Changer la taille de l'chiquier}
menuText F OptionsPieces "Board Piece Style" 6 \
  {Change the board piece style} ;# ***
menuText F OptionsColors "Couleurs..." 0 {Changer les couleurs}
menuText F OptionsExport "Exportation" 0 {Changer les options d'exportation}
menuText F OptionsFonts "Polices" 0 {Changer les polices}
menuText F OptionsFontsRegular "Normales" 0 {Changer les polices normales}
menuText F OptionsFontsSmall "Petites" 0 {Changer les petites polices}
menuText F OptionsFontsFixed "Fixe" 0 {Changer les polices de chasse fixe}
menuText F OptionsGInfo "Informations de la partie" 7 {Options d'information de la partie}
menuText F OptionsLanguage "Langue" 0 {Selectionner le menu de choix des langues}
menuText F OptionsMoves "Coups" 2 {Gestion des coups}
menuText F OptionsMovesAsk "Demander avant d'craser les coups" 0 \
  {Demander avant d'craser un coup existant}
menuText F OptionsMovesDelay "Dlai entre les coups" 3 \
  {Positionner le dlai entre deux coups en mode automatique}
menuText F OptionsMovesCoord "Coordonnes entre les coups" 0 \
  {Accepter l'entre des coups par coordonnes ("g1f3")}
menuText F OptionsMovesSuggest "Montrer les coups suggrs" 0 \
  {Activer/Dsactiver le mode de suggestion de coup}
menuText F OptionsMovesKey "Completion clavier" 0 \
  {Activer/Dsactiver le mode de completion du clavier}
menuText F OptionsNumbers "Format numrique" 7 {Selectionner le format des nombres}
menuText F OptionsStartup "Startup" 3 {Select windows to open at startup} ;# ***
menuText F OptionsWindows "Fentres" 0 {Options des fentres}
menuText F OptionsWindowsIconify "Auto-iconify" 5 \
  {Iconify all windows when the main window is iconified} ;# ***
menuText F OptionsWindowsRaise "Apparition automatique" 0 \
  {Fait apparatre certaines fentres (i.e. barres de progression)  chaque fois qu'elles sont obscurcies}
menuText F OptionsToolbar "Main window Toolbar" 12 \
  {Show/hide the main window toolbar} ;# ***
menuText F OptionsECO "Charger le fichier ECO..." 20 \
  {Charger un fichier au format ECO}
menuText F OptionsSpell "Charger le fichier d'orthographe..." 25 \
  {Charger un fichier de correction orthographique scid}
menuText F OptionsTable "Rpertoire des TB..." 0 \
  {Slectionner un rpertoire de fichiers TB, tous les fichiers de ce rpertoire seront utiliss}
menuText F OptionsSave "Sauver les options" 0 \
  "Sauver les options dans le fichier $::optionsFile"
menuText F OptionsAutoSave "Auto-save Options on Exit" 0 \
  {Auto-save all options when exiting Scid} ;# ***

# Help menu:
menuText F Help "Aide" 0
menuText F HelpIndex "Index" 0 {Afficher la table des matires}
menuText F HelpGuide "Aide Rapide" 5 {Montrer la page d'aide rapide}
menuText F HelpHints "Astuces" 0 {Afficher les trucs et astuces}
menuText F HelpContact "Contact" 0 {Afficher les noms des contacts}
menuText F HelpTip "Tip of the day" 0 {Show a useful Scid tip} ;# ***
menuText F HelpStartup "Fentre de dmarrage" 0 {Afficher la fentre de dmarrage}
menuText F HelpAbout "A propos de Scid" 2 {Information au sujet de Scid}

# Game info box popup menu:
menuText F GInfoHideNext "Cacher le coup suivant" 0
menuText F GInfoMaterial "Montrer les valeurs de matriel" 0
menuText F GInfoFEN "Montrer la notation FEN" 5
menuText F GInfoMarks "Show colored squares and arrows" 5 ;# ***
menuText F GInfoWrap "Wrap long lines" 0 ;# ***
menuText F GInfoFullComment "Show Full Comment" 10 ;# ***
menuText F GInfoTBNothing "Tablebases: Rien" 12
menuText F GInfoTBResult "Tablebases: Seulement le rsultat" 12
menuText F GInfoTBAll "Tablebases: rsultat et meilleurs coups" 19
menuText F GInfoDelete "(Un)Delete cette partie" 4
menuText F GInfoMark "(D)Slectionner cette partie" 4

# Main window buttons:
helpMsg F .button.start {Aller au dbut de la partie  (Raccourci clavier: Home)}
helpMsg F .button.end {Aller  la fin de la partie  (Raccourci clavier: Fin)}
helpMsg F .button.back {Reculer d'un coup  (Raccourci clavier: Flche gauche)}
helpMsg F .button.forward {Avancer d'un coup  (Raccourci clavier: Flche droite)}
helpMsg F .button.intoVar {Entrer dans une variante  (Raccourci clavier: v)}
helpMsg F .button.exitVar {Quitter la variante en cours  (Raccourci clavier: z)}
helpMsg F .button.flip {Retourner l'chiquier  (Raccourci clavier: .)}
helpMsg F .button.coords {Afficher/Enlever les coordonnes  (Raccourci clavier: 0)}
helpMsg F .button.autoplay {Jeu automatique  (Raccourci clavier: Ctrl+Z)}

# General buttons:
translate F Back {Retour}
translate F Cancel {Annuler}
translate F Clear {Effacer}
translate F Close {Fermer}
translate F Defaults {Par dfaut}
translate F Delete {Delete} ;# ***
translate F Graph {Graphique}
translate F Help {Aide}
translate F Import {Importer}
translate F Index {Index}
translate F LoadGame {Load game} ;# ***
translate F BrowseGame {Browse game} ;# ***
translate F MergeGame {Merge game} ;# ***
translate F Preview {Preview} ;# ***
translate F Revert {Revenir}
translate F Save {Enregistrer}
translate F Search {Rechercher}
translate F Stop {Arrter}
translate F Store {Enregistrer}
translate F Update {Mettre  jour}
translate F ChangeOrient {Change window orientation} ;# ***
translate F None {None} ;# ***
translate F First {First} ;# ***
translate F Current {Current} ;# ***
translate F Last {Last} ;# ***

# General messages:
translate F game {partie}
translate F games {parties}
translate F move {coup}
translate F moves {coups}
translate F all {tout}
translate F Yes {Oui}
translate F No {Non}
translate F Both {Both} ;# ***
translate F King {Roi}
translate F Queen {Dame}
translate F Rook {Tour}
translate F Bishop {Fou}
translate F Knight {Cavalier}
translate F Pawn {Pion}
translate F White {Blanc}
translate F Black {Noir}
translate F Player {Joueur}
translate F Rating {Classement ELO}
translate F RatingDiff {Difference de classement ELO (Blanc - Noir)}
translate F Event {vnement}
translate F Site {Lieux}
translate F Country {Pays}
translate F IgnoreColors {Ignorer les couleurs}
translate F Date {Date}
translate F EventDate {vnement date}
translate F Year {Anne}
translate F Month {Mois}
translate F Months {Janvier Fvrier Mars Avril Mai Juin
  Juillet Aot Septembre Octobre Novembre Dcembre}
translate F Days {Dim Lun Mar Mer Jeu Ven Sam}
translate F YearToToday {Anne jusqu' aujourd'hui}
translate F Result {Rsultat}
translate F Round {Ronde}
translate F Length {Longueur}
translate F ECOCode {code ECO}
translate F ECO {ECO}
translate F Deleted {Effac}
translate F SearchResults {Rsultats de la recherche}
translate F OpeningTheDatabase {Ouverture de la base}
translate F Database {Base}
translate F Filter {Filtre}
translate F noGames {pas de parties}
translate F allGames {toutes les parties}
translate F empty {vide}
translate F clipbase {clipbase}
translate F score {score}
translate F StartPos {Position de dpart}
translate F Total {Total} ;# ***

# Game information:
translate F twin {doublon}
translate F deleted {effac}
translate F comment {commentaire}
translate F hidden {cach}
translate F LastMove {Dernier coup}
translate F NextMove {Coup suivant}
translate F GameStart {Dbut de la partie}
translate F LineStart {Dbut de la ligne de jeu}
translate F GameEnd {Fin de la partie}
translate F LineEnd {Fin de la ligne de jeu}

# Player information:
translate F PInfoAll {Results for <b>all</b> games} ;# ***
translate F PInfoFilter {Results for <b>filter</b> games} ;# ***
translate F PInfoAgainst {Results against} ;# ***
translate F PInfoMostWhite {Most common openings as White} ;# ***
translate F PInfoMostBlack {Most common openings as Black} ;# ***
translate F PInfoRating {Rating history} ;# ***
translate F PInfoBio {Biography} ;# ***

# Tablebase information:
translate F Draw {Nulle}
translate F stalemate {pat}
translate F withAllMoves {avec tous les coups}
translate F withAllButOneMove {avec tous les coups sauf le dernier}
translate F with {avec}
translate F only {seulement}
translate F lose {perte}
translate F loses {pertes}
translate F allOthersLose {toutes les autres pertes}
translate F matesIn {mat en}
translate F hasCheckmated {a mat}
translate F longest {le plus long}

# Tip of the day:
translate F Tip {Tip} ;# ***
translate F TipAtStartup {Tip at startup} ;# ***

# Tree window menus:
menuText F TreeFile "Fichier" 0
menuText F TreeFileSave "Sauver le cache" 0
menuText F TreeFileFill "Remplir le cache" 0
menuText F TreeFileBest "Best games list" 0 {Show the best tree games list} ;# ***
menuText F TreeFileGraph "Graphique" 0
menuText F TreeFileCopy "Copier l'arbre dans le presse-papiers" 0
menuText F TreeFileClose "Fermer la fentre d'arbre" 0
menuText F TreeSort "Trier" 0
menuText F TreeSortAlpha "Alphabetique" 0
menuText F TreeSortECO "code ECO" 0
menuText F TreeSortFreq "Frquence" 0
menuText F TreeSortScore "Score" 0
menuText F TreeOpt "Options" 0
menuText F TreeOptLock "Lock" 0 {Lock/unlock the tree to the current database} ;# ***
menuText F TreeOptTraining "Entrainement" 0 {Turn on/off tree training mode} ;# ***
menuText F TreeOptAutosave "Sauver le cache automatiquement" 0
menuText F TreeHelp "Aide" 0
menuText F TreeHelpTree "Aide Arbre" 0
menuText F TreeHelpIndex "Index" 0
translate F SaveCache {Sauver le cache}
translate F Training {Entrainement}
translate F LockTree {Lock}
translate F TreeLocked {locked} ;# ***
translate F TreeBest {Best} ;# ***
translate F TreeBestGames {Best tree games} ;# ***

# Finder window: ;# ***
menuText F FinderFile "Fichier" 0
menuText F FinderFileSubdirs "Look in subdirectories" 0
menuText F FinderFileClose "Close File Finder" 0
menuText F FinderSort "Trier" 0
menuText F FinderSortType "Type" 0
menuText F FinderSortSize "Size" 0
menuText F FinderSortMod "Modified" 0
menuText F FinderSortName "Name" 0
menuText F FinderSortPath "Path" 0
menuText F FinderTypes "Types" 0
menuText F FinderTypesScid "Scid databases" 0
menuText F FinderTypesOld "Old-format Scid databases" 0
menuText F FinderTypesPGN "PGN files" 0
menuText F FinderTypesEPD "EPD (book) files" 0
menuText F FinderTypesRep "Repertoire files" 0
menuText F FinderHelp "Aide" 0
menuText F FinderHelpFinder "File Finder help" 0
menuText F FinderHelpIndex "Index" 0
translate F FileFinder {File Finder}
translate F FinderDir {Directory}
translate F FinderDirs {Directories}
translate F FinderFiles {Files}
translate F FinderUpDir {up}

# Tournament finder:
menuText F TmtFile "Fichier" 0
menuText F TmtFileUpdate "Mettre  jour" 0
menuText F TmtFileClose "Close Tournament Finder" 0
menuText F TmtSort "Trier" 0
menuText F TmtSortDate "Date" 0
menuText F TmtSortPlayers "Joueurs" 0
menuText F TmtSortGames "Parties" 0
menuText F TmtSortElo "Elo" 0
menuText F TmtSortSite "Lieux" 0
menuText F TmtSortEvent "vnement" 1
menuText F TmtSortWinner "Winner" 0 ;# ***
translate F TmtLimit "List limit" ;# ***
translate F TmtMeanElo "Lowest mean Elo" ;# ***
translate F TmtNone "No matching tournaments were found." ;# ***

# Graph windows:
menuText F GraphFile "Fichier" 0
menuText F GraphFileColor "Save as Color Postscript..." 8 ;# ***
menuText F GraphFileGrey "Save as Greyscale Postscript..." 8 ;# ***
menuText F GraphFileClose "Close window" 6 ;# ***
menuText F GraphOptions "Options" 0
menuText F GraphOptionsWhite "Blanc" 0
menuText F GraphOptionsBlack "Noir" 0
menuText F GraphOptionsBoth "Both" 1 ;# ***
menuText F GraphOptionsPInfo "Player Info player" 0 ;# ***

# Analysis window:
translate F AddVariation {Add variation} ;# ***
translate F AddMove {Ajouter le coup}
translate F Annotate {Annotation}
translate F AnalysisCommand {Commande d'analyse}
translate F PreviousChoices {Choix prcdents}
translate F AnnotateTime {Set the time between moves in seconds} ;# ***
translate F AnnotateWhich {Add variations} ;# ***
translate F AnnotateAll {For moves by both sides} ;# ***
translate F AnnotateWhite {For White moves only} ;# ***
translate F AnnotateBlack {For Black moves only} ;# ***
translate F AnnotateNotBest {When game move is not best move} ;# ***

# Analysis Engine open dialog:
translate F EngineList {Analysis Engine List} ;# ***
translate F EngineName {Name} ;# ***
translate F EngineCmd {Command} ;# ***
translate F EngineArgs {Parameters} ;# ***
translate F EngineDir {Directory} ;# ***
translate F EngineElo {Elo}
translate F EngineTime {Date}
translate F EngineNew {New} ;# ***
translate F EngineEdit {Edit} ;# ***
translate F EngineRequired {Fields in bold are required; others are optional} ;# ***

# Stats window menus:
menuText F StatsFile "Fichier" 0
menuText F StatsFilePrint "crire dans fichier..." 0
menuText F StatsFileClose "Close window" 0 ;# ***
menuText F StatsOpt "Options" 0

# PGN window menus:
menuText F PgnFile "Fichier" 0
menuText F PgnFilePrint "crire dans fichier..." 0
menuText F PgnFileClose "Fermer la fentre PGN" 0
menuText F PgnOpt "Affichage" 0
menuText F PgnOptColor "Couleur d'affichage" 0
menuText F PgnOptShort "Short (3-line) header" 0 ;# ***
menuText F PgnOptSymbols "Annotations symboliques" 0
menuText F PgnOptIndentC "Indentation des commentaires" 0
menuText F PgnOptIndentV "Indentation des variantes" 16
menuText F PgnOptColumn "Style en colomne (un coup par ligne)" 1
menuText F PgnOptSpace "Espace aprs numro des coups" 0
menuText F PgnColor "Couleur" 0
menuText F PgnColorHeader "Entte..." 0
menuText F PgnColorAnno "Annotations..." 0
menuText F PgnColorComments "Commentaires..." 0
menuText F PgnColorVars "Variantes..." 0
menuText F PgnColorBackground "Couleur du fond..." 11
menuText F PgnHelp "Aide" 0
menuText F PgnHelpPgn "Aide PGN" 0
menuText F PgnHelpIndex "Index" 0

# Crosstable window menus:
menuText F CrosstabFile "Fichier" 0
menuText F CrosstabFileText "crire dans un fichier texte..." 23
menuText F CrosstabFileHtml "crire dans un fichier HTML..." 23
menuText F CrosstabFileLaTeX "crire dans un fichier LaTeX..." 23
menuText F CrosstabFileClose "Fermer fentre tableau" 0
menuText F CrosstabEdit "Editer" 0
menuText F CrosstabEditEvent "Evnement" 0
menuText F CrosstabEditSite "Lieux" 0
menuText F CrosstabEditDate "Date" 0
menuText F CrosstabOpt "Affichage" 0
menuText F CrosstabOptAll "Toutes rondes" 0
menuText F CrosstabOptSwiss "Suisse" 0
menuText F CrosstabOptKnockout "Knockout" 0 ;# ***
menuText F CrosstabOptAuto "Auto" 0 ;# ***
menuText F CrosstabOptAges "Ages en annes" 8
menuText F CrosstabOptNats "Nationalits" 0
menuText F CrosstabOptRatings "Classements" 0
menuText F CrosstabOptTitles "Titres" 0
menuText F CrosstabOptBreaks "Tie-break scores" 4 ;# ***
menuText F CrosstabOptColors "Couleurs (systme suisse uniquement)" 1
menuText F CrosstabOptGroup "Scores du groupe" 0
menuText F CrosstabSort "Trier" 0
menuText F CrosstabSortName "Nom" 0
menuText F CrosstabSortRating "Elo" 0
menuText F CrosstabSortScore "Score" 0
menuText F CrosstabColor "Couleur" 0
menuText F CrosstabColorPlain "Texte normal" 0
menuText F CrosstabColorHyper "Hypertexte" 0
menuText F CrosstabHelp "Aide" 0
menuText F CrosstabHelpCross "Aide tableau" 0
menuText F CrosstabHelpIndex "Index" 0
translate F SetFilter {Set filter} ;# ***
translate F AddToFilter {Ajouter au filtre}
translate F Swiss {Suisse}

# Opening report window menus:
menuText F OprepFile "Fichier" 0
menuText F OprepFileText "crire dans un fichier texte..." 23
menuText F OprepFileHtml "crire dans un fichier HTML..." 23
menuText F OprepFileLaTeX "crire dans un fichier LaTeX..." 23
menuText F OprepFileOptions "Options..." 0
menuText F OprepFileClose "Fermer la fentre du rapport" 0
menuText F OprepHelp "Aide" 0
menuText F OprepHelpReport "Aide du rapport" 0
menuText F OprepHelpIndex "Index" 0

# Repertoire editor: ;# ***
menuText F RepFile "Fichier" 0
menuText F RepFileNew "Nouvelle" 0
menuText F RepFileOpen "Ouvrir..." 0
menuText F RepFileSave "Sauve..." 0
menuText F RepFileSaveAs "Sauve sous..." 5
menuText F RepFileClose "Fermer" 0
menuText F RepEdit "Editer" 0
menuText F RepEditGroup "Ajouter Groupe" 4
menuText F RepEditInclude "Ajouter Inclure ligne" 4
menuText F RepEditExclude "Ajouter Exclure ligne" 4
menuText F RepView "Voir" 0
menuText F RepViewExpand "Etends tous les groupes" 0
menuText F RepViewCollapse "Collapse tous les groupes" 0
menuText F RepSearch "Rechercher" 0
menuText F RepSearchAll "Tout le rpertoire..." 0
menuText F RepSearchDisplayed "Affiche seulement les lignes..." 0
menuText F RepHelp "Aide" 0
menuText F RepHelpRep "Aide sur le rpertoire" 0
menuText F RepHelpIndex "Index" 0
translate F RepSearch "Recherche dans le rpertoire"
translate F RepIncludedLines "lignes inclues"
translate F RepExcludedLines "lignes exclues"
translate F RepCloseDialog {Ce rpertoire a des modifications non enregistres.

Voulez vous rellement continuer et ne pas tenir compte des changements que vous avez effectu?
}

# Header search:
translate F HeaderSearch {Rechercher Entte}
translate F GamesWithNoECO {Partie sans code ECO?}
translate F GameLength {Longueur de la partie}
translate F FindGamesWith {Chercher les parties avec}
translate F StdStart {Position initiale standard}
translate F Promotions {Promotions}
translate F Comments {Commentaires}
translate F Variations {Variantes}
translate F Annotations {Annotations}
translate F DeleteFlag {Marques supprimes}
translate F WhiteOpFlag {White opening} ;# ***
translate F BlackOpFlag {Black opening} ;# ***
translate F MiddlegameFlag {Middlegame} ;# ***
translate F EndgameFlag {Endgame} ;# ***
translate F NoveltyFlag {Novelty} ;# ***
translate F PawnFlag {Pawn structure} ;# ***
translate F TacticsFlag {Tactics} ;# ***
translate F QsideFlag {Queenside play} ;# ***
translate F KsideFlag {Kingside play} ;# ***
translate F BrilliancyFlag {Brilliancy} ;# ***
translate F BlunderFlag {Blunder} ;# ***
translate F UserFlag {User} ;# ***
translate F PgnContains {PGN contains text} ;# ***

# Game list window:
translate F GlistNumber {Numro}
translate F GlistWhite {Blanc}
translate F GlistBlack {Noir}
translate F GlistWElo {B-Elo}
translate F GlistBElo {N-Elo}
translate F GlistEvent {vnement}
translate F GlistSite {Lieux}
translate F GlistRound {Ronde}
translate F GlistDate {Date}
translate F GlistYear {Anne}
translate F GlistEDate {vnement-Date}
translate F GlistResult {Rsultat}
translate F GlistLength {Length} ;# ***
translate F GlistCountry {Pays}
translate F GlistECO {ECO}
translate F GlistOpening {Opening} ;# ***
translate F GlistEndMaterial {End-Material} ;# ***
translate F GlistDeleted {Effac}
translate F GlistFlags {Flags} ;# ***
translate F GlistVars {Variantes}
translate F GlistComments {Commentaires}
translate F GlistAnnos {Annotations}
translate F GlistStart {Start} ;# ***
translate F GlistGameNumber {Partie numro}
translate F GlistFindText {Rechercher texte}
translate F GlistMoveField {Move} ;# ***
translate F GlistEditField {Configure} ;# ***
translate F GlistAddField {Add} ;# ***
translate F GlistDeleteField {Remove} ;# ***
translate F GlistWidth {Width} ;# ***
translate F GlistAlign {Align} ;# ***
translate F GlistColor {Couleur}
translate F GlistSep {Separator} ;# ***

# Maintenance window:
translate F DatabaseName {Nom de base:}
translate F TypeIcon {Type icne:}
translate F NumOfGames {Parties:}
translate F NumDeletedGames {Parties supprimes:}
translate F NumFilterGames {Parties dans le filtre:}
translate F YearRange {Annes:}
translate F RatingRange {Classements:}
translate F Flag {Flag} ;# ***
translate F DeleteCurrent {Effacer la partie courante}
translate F DeleteFilter {Effacer le filtre de parties}
translate F DeleteAll {Effacer toutes les parties}
translate F UndeleteCurrent {Rcuprer la partie en cours}
translate F UndeleteFilter {Rcuprer les parties filtres}
translate F UndeleteAll {Rcuprer toutes les parties}
translate F DeleteTwins {Effacer les parties en doublon}
translate F MarkCurrent {Selectionner la partie en cours}
translate F MarkFilter {Selectionner les parties filtres}
translate F MarkAll {Selectionner toutes les parties}
translate F UnmarkCurrent {Dselectionner la partie en cours}
translate F UnmarkFilter {Dselectionner les parties filtres}
translate F UnmarkAll {Dselectionner toutes les parties}
translate F Spellchecking {Spell-checking}
translate F Players {Joueurs}
translate F Events {vnements}
translate F Sites {Lieux}
translate F Rounds {Rondes}
translate F DatabaseOps {Oprations sur la base}
translate F ReclassifyGames {ECO-Classifier les parties...}
translate F CompactDatabase {Compacter la base}
translate F SortDatabase {Trier la base}
translate F AddEloRatings {Ajouter les classements Elo}
translate F AutoloadGame {Autoload game number} ;# ***
translate F Cleaner {Nettoyer}
translate F CleanerHelp {
Le Nettoyeur Scid va raliser pour la base en cours toutes les actions de maintenance que vous avez slectionn  partir de la liste ci-dessous.

Les rglages en cours de la classification ECO et les dialogues d'effacement des jumeaux vont s'appliquer si vous avez slectionn ces fonctions.
}
translate F CleanerConfirm {
Une fois que le nettoyage est commenc, il ne peut tre interrompu!

Cela peut prendre beaucoup de temps sur une grande base, suivant les fonctions que vous avez slectionn et leurs rglages en cours.

Etes vous sr que vous voulez commencer les fonctions de maintenance que vous avez slectionn?
}

# Comment editor:
translate F AnnotationSymbols {Symboles d'annotation:}
translate F Comment {Commentaire:}

# Board search:
translate F BoardSearch {Rechercher Position}
translate F FilterOperation {Operation sur le filtre en cours:}
translate F FilterAnd {ET (Restraint le filtre)}
translate F FilterOr {OU (Ajouter au filtre)}
translate F FilterIgnore {IGNORER (Restaure le filtre initial)}
translate F SearchType {Type de recherche:}
translate F SearchBoardExact {Position exacte (mmes pices sur les mmes cases)}
translate F SearchBoardPawns {Pions (mme matriel, tous les pions sur les mmes cases)}
translate F SearchBoardFiles {Colonnes (mme matriel, tous les pions dans le mme fichier)}
translate F SearchBoardAny {Tous (mme matriel, pions et pices n'importe o)}
translate F LookInVars {Cherche dans les variantes}

# Material search:
translate F MaterialSearch {Rechercher Motifs}
translate F Material {Matriel}
translate F Patterns {Motifs}
translate F Zero {Zro}
translate F Any {Tout}
translate F CurrentBoard {Position en cours}
translate F CommonEndings {Finales}
translate F CommonPatterns {Motifs}
translate F MaterialDiff {Material difference} ;# ***
translate F squares {cases}
translate F SameColor {Mmes couleur}
translate F OppColor {Couleurs opposes}
translate F Either {Les deux}
translate F MoveNumberRange {Dplacer de X coups}
translate F MatchForAtLeast {Correspond  la dernire}
translate F HalfMoves {demi-coups}

# Game saving:
translate F Today {Aujourd'hui}
translate F ClassifyGame {Classer la partie}

# Setup position:
translate F EmptyBoard {Vider l'chiquier}
translate F InitialBoard {R-initiliser l'chiquier}
translate F SideToMove {Cot qui a le trait}
translate F MoveNumber {Coup numero}
translate F Castling {Roque}
translate F EnPassentFile {Prise en passent}
translate F ClearFen {Effacer FEN}
translate F PasteFen {Coller FEN}

# Replace move dialog:
translate F ReplaceMove {Remplacer le coup}
translate F AddNewVar {Ajouter variante}
translate F ReplaceMoveMessage {Un coup existe dj.

Vous pouvez le remplacer, ou bien dtruire tous les coups aprs ce coup ou ajouter une nouvelle variante.

(Vous pouvez demander  ne plus voir ce message  l'avenir, en dslectionnant l'option "Demander avant de remplacer le coup" dans le menu des options)}

# Make database read-only dialog:
translate F ReadOnlyDialog {Si vous mettez cette base en lecture seule, aucun changement ne sera permis.
Aucune partie ne peut tre sauve ou remplace, et aucun drapeau d'effacement ne peut tre altr.
Tout les tris ou les rsultats de classification ECO seront temporaires.

Vous pouvez facilement rendre la base  nouveau accesible en ccriture, en la fermant et en l'ouvrant  nouveau.

Voulez vous vraiment passer cette base en lecture seule?}

# Clear game dialog:
translate F ClearGameDialog {Cette partie a t modifie.

Voulez vous vraiment continuer et ignorer les changements effectus?
}

# Exit dialog:
translate F ExitDialog {Voulez vous rellement quitter Scid?}

# Import window:
translate F PasteCurrentGame {Coller la partie courante}
translate F ImportHelp1 {Entrer ou coller une partie au format PGN dans le cadre ci-dessus.}
translate F ImportHelp2 {Toutes les erreurs durant l'import de la partie seront affiches ii.}

# ECO Browser:
translate F ECOAllSections {toutes les sections ECO}
translate F ECOSection {section ECO}
translate F ECOSummary {Rsum pour}
translate F ECOFrequency {Frequence des sous-codes pour}

# Opening Report:
translate F OprepTitle {Rapport sur l'ouverture}
translate F OprepReport {Rapport}
translate F OprepGenerated {Gener par}
translate F OprepStatsHist {Statistiques et Historique}
translate F OprepStats {Statistiques}
translate F OprepStatAll {All report games} ;# ***
translate F OprepStatBoth {Both rated} ;# ***
translate F OprepStatSince {Depuis}
translate F OprepOldest {Les parties les plus anciennes}
translate F OprepNewest {Les parties les plus rcentes}
translate F OprepPopular {Popularit courante}
translate F OprepFreqAll {Frquence pour toutes les annes: }
translate F OprepFreq1   {Depuis 1 an jusqu' ce jour:      }
translate F OprepFreq5   {Depuis 5 ans jusqu' ce jour:     }
translate F OprepFreq10  {Depuis 10 ans jusqu' ce jour:    }
translate F OprepEvery {once every %u games} ;# ***
translate F OprepUp {up %u%s from all years} ;# ***
translate F OprepDown {down %u%s from all years} ;# ***
translate F OprepSame {no change from all years} ;# ***
translate F OprepMostFrequent {Most frequent players} ;# ***
translate F OprepRatingsPerf {Classements et performance}
translate F OprepAvgPerf {Average ratings and performance} ;# ***
translate F OprepWRating {Classement des blancs}
translate F OprepBRating {Classement des noirs}
translate F OprepWPerf {Performance des blancs}
translate F OprepBPerf {Performance des noirs}
translate F OprepHighRating {Games with highest average rating} ;# ***
translate F OprepTrends {Result Trends} ;# ***
translate F OprepResults {Result lengths and frequencies} ;# ***
translate F OprepLength {Game length} ;# ***
translate F OprepFrequency {Frequency} ;# ***
translate F OprepWWins {Gains blancs: }
translate F OprepBWins {Gains noirs:  }
translate F OprepDraws {Nulles:       }
translate F OprepWholeDB {whole database} ;# ***
translate F OprepShortest {Shortest wins} ;# ***
# translate F OprepShortWhite {Gains blancs les plus courts}
# translate F OprepShortBlack {Gains noirs les plus courts}
translate F OprepMovesThemes {Coups et Thmes}
translate F OprepMoveOrders {Ordres de coups atteignant la position du rapport}
translate F OprepMoveOrdersOne \
  {Il n'y a qu'un seul ordre de coups pour atteindre cette position:}
translate F OprepMoveOrdersAll \
  {Il y a %u ordres de coups pour atteindre cette position:}
translate F OprepMoveOrdersMany \
  {Il y a %u ordres de coups pour atteindre cette position. Les %u premiers sont:}
translate F OprepMovesFrom {Coups depuis la position du rapport}
translate F OprepThemes {Thmes positionnels}
translate F OprepThemeDescription {Frequence des thmes au coup %u}
translate F OprepThemeSameCastling {Roques du mme ct}
translate F OprepThemeOppCastling {Roques du ct oppos}
translate F OprepThemeNoCastling {Aucun roque}
translate F OprepThemeKPawnStorm {Avalanche de pions  l'aile roi}
translate F OprepThemeQueenswap {Dames echanges}
translate F OprepThemeIQP {Pion Dame isol}
translate F OprepThemeWP567 {Pion blanc sur la 5/6/7e ligne}
translate F OprepThemeBP234 {Pion noir sur la 2/3/4e ligne}
translate F OprepThemeOpenCDE {Colonne c/d/e ouverte}
translate F OprepTheme1BishopPair {Paire de fous}
translate F OprepEndgames {Finales}
translate F OprepReportGames {Report games} ;# ***
translate F OprepAllGames {Toutes les parties}
translate F OprepEndClass {Material classification of final game positions} ;# ***
translate F OprepTheoryTable {Theory Table} ;# ***
translate F OprepTableComment {Generated from the %u highest-rated games.} ;# ***
translate F OprepExtraMoves {Extra note moves in theory table} ;# ***
translate F OprepMaxGames {Maximum games in theory table} ;# ***

# Game selection dialogs:
translate F SelectAllGames {Toutes les parties de la base}
translate F SelectFilterGames {Seulement les parties du filtre}
translate F SelectTournamentGames {Seulement les parties du tournoi courant}
translate F SelectOlderGames {Only older games} ;# ***

# Delete Twins window:
translate F TwinsNote {Pour tre considres comme doublons, deux parties doivent au moins avoir les deux mmes joueurs, et avoir les critres que vous pouvez fixer ci-dessous satisfaits. Quand une paire de doublons est trouve, la partie la plus courte est fface.
Conseil: il est prfrable de vrifier l'orthographe dans la base avant d'effacer les doublons, car cela amliore la dtection des doublons. }
translate F TwinsCriteria {Critre: Les doublons doivent avoir...}
translate F TwinsWhich {Parties  examiner}
translate F TwinsColors {Mme couleurs de joueurs?}
translate F TwinsEvent {Mme vnement?}
translate F TwinsSite {Mme lieu?}
translate F TwinsRound {Mme ronde?}
translate F TwinsYear {Mme anne?}
translate F TwinsMonth {Mme mois?}
translate F TwinsDay {Mme jour?}
translate F TwinsResult {Mme rsultat?}
translate F TwinsECO {Mme code ECO?}
translate F TwinsMoves {Mmes coups?}
translate F TwinsPlayers {Comparaison des noms des joueurs:}
translate F TwinsPlayersExact {Correspondance exacte}
translate F TwinsPlayersPrefix {Les 4 premires lettres seules}
translate F TwinsWhen {En effaant les doublons}
translate F TwinsSkipShort {Ignore all games under 5 moves long?} ;# ***
translate F TwinsUndelete {Rcuprer toutes les parties d'abord?}
translate F TwinsSetFilter {Set filter to all deleted twin games?} ;# ***
translate F TwinsComments {Toujours garder les parties qui comportent des commentaires?}
translate F TwinsVars {Toujours garder les parties qui comportent des variantes?}
translate F TwinsDelete {Effacer les parties}

# Name editor window:
translate F NameEditType {Type of name to edit} ;# ***
translate F NameEditSelect {Parties  diter}
translate F NameEditReplace {Remplacer}
translate F NameEditWith {avec}
translate F NameEditMatches {Matches: Presser Ctrl+1  Ctrl+9 pour slectionner}

# Classify window:
translate F Classify {Classer}
translate F ClassifyWhich {Choix des parties  classer suivant ECO}
translate F ClassifyAll {Toutes les parties (crase les ancients codes ECO)}
translate F ClassifyYear {Toutes les parties joues la dernire anne}
translate F ClassifyMonth {Toutes les parties joues le dernier mois}
translate F ClassifyNew {Seulement les parties qui ne possdent pas encore de code ECO}
translate F ClassifyCodes {Codes ECO  utiliser}
translate F ClassifyBasic {Codes de base seulement ("B12", ...)}
translate F ClassifyExtended {Extensions de Scid ("B12j", ...)}

# Compaction:
translate F NameFile {Fichier de noms}
translate F GameFile {Fichier de parties}
translate F Names {Noms}
translate F Unused {Non utilis}
translate F SizeKb {Taille (kb)}
translate F CurrentState {Etat courant}
translate F AfterCompaction {Aprs compactage}
translate F CompactNames {Compacter le fichier de noms}
translate F CompactGames {Compacter le fichier de parties}

# Sorting:
translate F SortCriteria {Critre}
translate F AddCriteria {Ajouter un critre}
translate F CommonSorts {Tris courants}
translate F Sort {Tri}

# Exporting:
translate F AddToExistingFile {Ajouter les parties  un fichier existant?}
translate F ExportComments {Exporter les commentaires?}
translate F ExportVariations {Exporter les variantes?}
translate F IndentComments {Indenter les commentaires?}
translate F IndentVariations {Indenter les variantes?}
translate F ExportColumnStyle {Style en colomne (un coup par ligne)?}
translate F ExportSymbolStyle {Style d'annotation symbolique:}

# Goto game/move dialogs:
translate F LoadGameNumber {Entrer le numro de la partie  charger:}
translate F GotoMoveNumber {Aller au coup numro:}

# Copy games dialog:
translate F CopyGames {Copier les parties}
translate F CopyConfirm {
 Voulez vous vraiment copier
 les [thousands $nGamesToCopy] parties filtres
 depuis la base "$fromName"
 vers la base "$targetName"?
}
translate F CopyErr {Ne peut copier les parties}
translate F CopyErrSource {la base source}
translate F CopyErrTarget {la base destination}
translate F CopyErrNoGames {n'a pas de parties dans son filtre}
translate F CopyErrReadOnly {est en lecture seule}
translate F CopyErrNotOpen {n'est pas ouverte}

# Colors:
translate F LightSquares {Cases blanches}
translate F DarkSquares {Cases noires}
translate F SelectedSquares {Cases slectionnes}
translate F SuggestedSquares {Cases des coups suggrs}
translate F WhitePieces {Pieces blanches}
translate F BlackPieces {Pieces noires}
translate F WhiteBorder {Bordure des pices blanches}
translate F BlackBorder {Bordure des pices noires}

# Novelty window:
translate F FindNovelty {Touver la nouveaut}
translate F Novelty {Nouveaut}
translate F NoveltyInterrupt {Novelty search interrupted} ;# ***
translate F NoveltyNone {No novelty was found for this game} ;# ***
translate F NoveltyHelp {
Scid va trouver le premier coup de la partie en cours qui atteint une position qui ne figure ni dans la base slectionne ni dans le rpertoire d'ouvertures ECO.
}

# Upgrading databases: ;# ***
translate F Upgrading {Upgrading}
translate F ConfirmOpenNew {
This is an old-format (Scid 2) database that cannot be opened in Scid 3, but a new-format (Scid 3) version has already been created.

Do you want to open the new-format version of the database?
}
translate F ConfirmUpgrade {
This is an old-format (Scid 2) database. A new-format version of the database must be created before it can be used in Scid 3.

Upgrading will create a new version of the database; it will not edit or remove the original files.

This may take a while, but it only needs to be done one time. You can cancel if it takes too long.

Do you want to upgrade this database now?
}

}
# end of francais.tcl
