#*=====================================================================*/
#*    serrano/prgm/project/scribe/Makefile.tpl                         */
#*    -------------------------------------------------------------    */
#*    Author      :  Manuel Serrano                                    */
#*    Creation    :  Wed Nov  7 09:20:47 2001                          */
#*    Last change :  Tue Jan 15 14:19:42 2002 (serrano)                */
#*    Copyright   :  2001-02 Manuel Serrano                            */
#*    -------------------------------------------------------------    */
#*    Standard Scribe makefile to build various libraries.             */
#*=====================================================================*/

#*---------------------------------------------------------------------*/
#*    Compilers, Tools and Destinations                                */
#*---------------------------------------------------------------------*/
# where to store Biglook libraries and Biglook heap file
LIB         	= $(SCRIBEDIR)/lib
BIN		= $(SCRIBEDIR)/bin
# The heap file
HEAP_FILE	= $(LIB)/$(TARGETNAME).heap
HEAPJVM_FILE	= $(LIB)/$(TARGETNAME).jheap
# Where to store the library class files
PBASE		= bigloo.scribe.$(TARGETNAME)
CLASS_DIR	= objs/class/bigloo/scribe/$(TARGETNAME)

#*---------------------------------------------------------------------*/
#*    Suffixes                                                         */
#*---------------------------------------------------------------------*/
.SUFFIXES:
.SUFFIXES: .scm .class .o

#*---------------------------------------------------------------------*/
#*    The implicit rules                                               */
#*---------------------------------------------------------------------*/
.scm.o:
	$(BIGLOO) $(BFLAGS) $*.scm -o $*.o -c

$(CLASS_DIR)/%.class: %.scm
	$(BIGLOO) -jvm $(BJVMFLAGS) $(BFLAGS) -c $< -o $@

#*---------------------------------------------------------------------*/
#*    The heap construction                                            */
#*---------------------------------------------------------------------*/
.PHONY: heap heap-c heap-jvm

heap-c: $(HEAP_FILE)
heap-jvm: $(HEAPJVM_FILE)

$(HEAP_FILE): .afile make-lib.scm
	@ \rm -f $(HEAP_FILE)
	@ $(BIGLOO) $(BHEAPFLAGS) make-lib.scm -addheap $(HEAP_FILE)
	@ echo "Heap Done..."
	@ echo "-------------------------------"

$(HEAPJVM_FILE): .jfile .afile make-lib.scm
	@ \rm -f $(HEAPJVM_FILE)
	@ $(BIGLOO) -jvm $(BHEAPFLAGS) make-lib.scm -addheap $(HEAPJVM_FILE)
	@ echo "Heap JVM Done..."
	@ echo "-------------------------------"

#*---------------------------------------------------------------------*/
#*    bin                                                              */
#*---------------------------------------------------------------------*/
.PHONY: bin-c bin-jvm bin-c-safe

#*--- bin-c -----------------------------------------------------------*/
bin-c: $(TAGS) .afile $(BIN)/$(TARGETNAME)

$(BIN)/$(TARGETNAME): $(OBJECTS)
	$(BIGLOO) $(BFLAGS) $(OBJECTS) -o $(BIN)/$(TARGETNAME)
	@ echo "$(TARGETNAME) Done..."
	@ echo "-------------------------------"

#*--- bin-c-safe ------------------------------------------------------*/
bin-c-safe: $(TAGS) .afile $(BIN)/$(TARGETNAME).safe

$(BIN)/$(TARGETNAME).safe: $(OBJECTS)
	$(BIGLOO) $(BSAFEFLAGS) $(OBJECTS) -o $(BIN)/$(TARGETNAME)
	@ echo "$(TARGETNAME) Done..."
	@ echo "-------------------------------"

#*--- bin-jvm ---------------------------------------------------------*/
bin-jvm: $(TAGS) .afile .jfile $(CLASS_DIR) $(BIN)/$(TARGETNAME).zip

$(BIN)/$(TARGETNAME).zip: $(CLASSES)
	@ /bin/rm -f $(BIN)/$(TARGETNAME).zip
	@ (cd objs/class; \
	  $(ZIP) -q $(ZFLAGS) \
                 $(BIN)/$(TARGETNAME).zip \
                 $(CLASS_DIR:objs/class/%=%)/*.class)
	@ echo "$(TARGETNAME).zip done..."
	@ echo "-------------------------------"

#*---------------------------------------------------------------------*/
#*    lib                                                              */
#*---------------------------------------------------------------------*/
.PHONY: lib-c lib-jvm

#*--- lib-c -----------------------------------------------------------*/
lib-c: $(TAGS) .afile lib.$(SHAREDSUFFIX) lib.a

lib.$(SHAREDSUFFIX): $(LIB)/lib$(TARGETNAME).$(SHAREDSUFFIX) $(LIB)/lib$(TARGETNAME)_u.$(SHAREDSUFFIX)
lib.a: $(LIB)/lib$(TARGETNAME).a $(LIB)/lib$(TARGETNAME)_u.a

$(LIB)/lib$(TARGETNAME)_u.$(SHAREDSUFFIX): $(LIB)/lib$(TARGETNAME).$(SHAREDSUFFIX)
	cd $(LIB); \
        /bin/rm -f lib$(TARGETNAME)_u.$(SHAREDSUFFIX); \
        ln -s lib$(TARGETNAME).$(SHAREDSUFFIX) lib$(TARGETNAME)_u.$(SHAREDSUFFIX)

$(LIB)/lib$(TARGETNAME).$(SHAREDSUFFIX): .afile $(OBJECTS)
	@ /bin/rm -f $(LIB)/lib$(TARGETNAME).$(SHAREDSUFFIX)
	@ $(LD) -o $(LIB)/lib$(TARGETNAME).$(SHAREDSUFFIX) $(OBJECTS) -lm -lc
	@ echo "lib$(TARGETNAME).$(SHAREDSUFFIX) Done..."
	@ echo "-------------------------------"

$(LIB)/lib$(TARGETNAME)_u.a: $(LIB)/lib$(TARGETNAME).a
	cd $(LIB); \
        /bin/rm -f lib$(TARGETNAME)_u.a; \
        ln -s lib$(TARGETNAME).a lib$(TARGETNAME)_u.a

$(LIB)/lib$(TARGETNAME).a: .afile $(OBJECTS)
	@ /bin/rm -f $(LIB)/lib$(TARGETNAME).a
	@ $(AR) $(ARFLAGS) $(LIB)/lib$(TARGETNAME).a $(OBJECTS)
	@ $(RANLIB) $(LIB)/lib$(TARGETNAME).a
	@ echo "lib$(TARGETNAME).a Done..."
	@ echo "-------------------------------"

#*--- lib-jvm ---------------------------------------------------------*/
lib-jvm: $(TAGS) $(CLASS_DIR) lib.zip

$(CLASS_DIR): 
	mkdir -p $(CLASS_DIR)

lib.zip: .afile .jfile $(CLASSES)
	@ /bin/rm -f $(LIB)/lib$(TARGETNAME).zip
	@ (cd objs/class; \
	  $(ZIP) -q $(ZFLAGS) \
                 $(LIB)/lib$(TARGETNAME).zip \
                 $(CLASS_DIR:objs/class/%=%)/*.class)
	@ echo "lib$(TARGETNAME).zip done..."
	@ echo "-------------------------------"

#*---------------------------------------------------------------------*/
#*    ude                                                              */
#*---------------------------------------------------------------------*/
.PHONY: ude
ude:
	@ $(MAKE) -f Makefile .afile .btags

.afile: $(SOURCES)
	@ $(AFILE) -o .afile $(_BGL_SOURCES) 

.jfile: $(SOURCES)
	@ $(JFILE) -o .jfile -pbase $(PBASE) $(SOURCES) 

.btags: $(SOURCES)
	@ $(BTAGS) -o .btags $(_BGL_SOURCES)

#*---------------------------------------------------------------------*/
#*    stdclean                                                         */
#*---------------------------------------------------------------------*/
stdclean:
	/bin/rm -f $(OBJECTS) $(_BGL_OBJECTS:%=%.c)
	/bin/rm -f $(LIB)/lib$(TARGETNAME).$(SHAREDSUFFIX)
	/bin/rm -f .afile .btags .jfile
	/bin/rm -rf $(CLASS_DIR)
	/bin/rm -f *~
	/bin/rm -f *.mco

