;*=====================================================================*/
;*    serrano/prgm/project/scribe/apache/driver.scm                    */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov 22 07:04:01 2001                          */
;*    Last change :  Mon Nov 26 09:57:23 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    The Apache driver used to dynamically translate Scribe files     */
;*    into Html strings.                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribe_apache-driver
   (library scribeapi
	    scribehtml
	    scribehtmlgui)
   (main    initialize)
   (export  (driver::string ::string))
   (extern  (export driver "bgl_scribe_driver")))

;*---------------------------------------------------------------------*/
;*    initialize ...                                                   */
;*    -------------------------------------------------------------    */
;*    This does nothing but it must however exists so that the         */
;*    Bigloo compiler produces the necessary code to initialize        */
;*    the application.                                                 */
;*---------------------------------------------------------------------*/
(define (initialize argv)
   ;; make a dummy reference to a function of scribeapi. This force
   ;; the module containing the scribe api to be loaded at runtime
   (with-output-to-string
      (lambda ()
	 (for-each print (list document pre form))))
   ;; explicit apache initializations
   (scribehtmlgui-apache-initialize)
   (scribehtml-apache-initialize)
   ;; return nothing
   0)

;*---------------------------------------------------------------------*/
;*    driver ...                                                       */
;*---------------------------------------------------------------------*/
(define (driver filename)
   (with-output-to-string
      (lambda ()
	 (if (file-exists? filename)
	     (with-input-from-file filename
		(lambda ()
		   (try (html (port->ast (current-input-port)))
			(lambda (escape proc msg obj)
			   (set! *debug* 2)
			   (notify-error proc msg obj)
			   (escape (scribe-error proc msg obj))))))
	     (scribe-error "driver: " "Can't find file -- " filename)))))

;*---------------------------------------------------------------------*/
;*    scribe-error ...                                                 */
;*---------------------------------------------------------------------*/
(define (scribe-error proc msg obj)
   (html
    (document :title "Scribe (Apache) Error"
	      (list (with-output-to-string (lambda () (display proc)))
		    ": "
		    (with-output-to-string (lambda () (display msg)))
		    " -- "
		    (bold (with-output-to-string (lambda () (write obj))))))))

