;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/misc.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Sep 23 14:57:32 2001                          */
;*    Last change :  Thu Dec 20 16:20:04 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    Miscellaneous                                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_misc
   (export (->string ::obj)
	   (find-first ::procedure ::pair-nil)))

;*---------------------------------------------------------------------*/
;*    ->string ...                                                     */
;*---------------------------------------------------------------------*/
(define (->string obj)
   (cond
      ((string? obj)
       obj)
      ((symbol? obj)
       (symbol->string obj))
      ((number? obj)
       (number->string obj))
      ((char? obj)
       (string obj))
      (else
       (error "->string" "Illegal conversion" obj))))

;*---------------------------------------------------------------------*/
;*    find-first ...                                                   */
;*---------------------------------------------------------------------*/
(define (find-first pred lst)
   (let loop ((lst lst))
      (if (null? lst)
	  #f
	  (let ((search (pred (car lst))))
	     (if search
		 search
		 (loop (cdr lst)))))))

