;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribehtml/api.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Nov 17 17:38:46 2001                          */
;*    Last change :  Wed Jan 16 09:33:49 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The Html specific API.                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribehtml_api

   (export  *scribe-html-bold-start*
	    *scribe-html-bold-stop*
	    
	    *scribe-html-underline-start*
	    *scribe-html-underline-stop*
	    
	    *scribe-html-emph-start*
	    *scribe-html-emph-stop*
	    
	    *scribe-html-kbd-start*
	    *scribe-html-kbd-stop*
	    
	    *scribe-html-it-start*
	    *scribe-html-it-stop*
	    
	    *scribe-html-tt-start*
	    *scribe-html-tt-stop*
	    
	    *scribe-html-code-start*
	    *scribe-html-code-stop*
	    
	    *scribe-html-samp-start*
	    *scribe-html-samp-stop*
	    
	    *scribe-html-var-start*
	    *scribe-html-var-stop*
	    
	    *scribe-html-sc-start*
	    *scribe-html-sc-stop*
	    
	    *scribe-html-sup-start*
	    *scribe-html-sup-stop*
	    
	    *scribe-html-sub-start*
	    *scribe-html-sub-stop*
	    
	    *scribe-html-section-start*
	    *scribe-html-section-stop*
	    *scribe-html-section-title-start*
	    *scribe-html-section-title-stop*
	    
	    *scribe-html-subsection-start*
	    *scribe-html-subsection-stop*
	    *scribe-html-subsection-title-start*
	    *scribe-html-subsection-title-stop*
	    
	    *scribe-html-subsubsection-start*
	    *scribe-html-subsubsection-stop*
	    *scribe-html-subsubsection-title-start*
	    *scribe-html-subsubsection-title-stop*
	    
	    *scribe-html-paragraph-start*
	    *scribe-html-paragraph-stop*
	    
	    *scribe-html-chapter-start*
	    *scribe-html-chapter-stop*
	    *scribe-html-chapter-title-start*
	    *scribe-html-chapter-title-stop*
	    
	    *scribe-html-left-margin*
	    *scribe-html-right-margin*)

   (eval    (export-module)))

;*---------------------------------------------------------------------*/
;*    Margins                                                          */
;*---------------------------------------------------------------------*/
(define *scribe-html-left-margin* #f)
(define *scribe-html-right-margin* #f)

;*---------------------------------------------------------------------*/
;*    Public HTML API.                                                 */
;*---------------------------------------------------------------------*/
;; bold
(define *scribe-html-bold-start* (lambda () (display "<strong>")))
(define *scribe-html-bold-stop* (lambda () (display "</strong>")))

;; emphazise
(define *scribe-html-emph-start* (lambda () (display "<em>")))
(define *scribe-html-emph-stop* (lambda () (display "</em>")))

;; underline
(define *scribe-html-underline-start* (lambda () (display "<u>")))
(define *scribe-html-underline-stop* (lambda () (display "</u>")))

;; keybord
(define *scribe-html-kbd-start* (lambda () (display "<kbd>")))
(define *scribe-html-kbd-stop* (lambda () (display "</kbd>")))

;; italic
(define *scribe-html-it-start* (lambda () (display "<em>")))
(define *scribe-html-it-stop* (lambda () (display "</em>")))

;; tt
(define *scribe-html-tt-start* (lambda () (display "<tt>")))
(define *scribe-html-tt-stop* (lambda () (display "</tt>")))

;; code
(define *scribe-html-code-start* (lambda () (display "<code>")))
(define *scribe-html-code-stop* (lambda () (display "</code>")))

;; samp
(define *scribe-html-samp-start* (lambda () (display "<samp>")))
(define *scribe-html-samp-stop* (lambda () (display "</samp>")))

;; var
(define *scribe-html-var-start* (lambda () (display "<var>")))
(define *scribe-html-var-stop* (lambda () (display "</var>")))

;; sc
(define *scribe-html-sc-start* (lambda () #unspecified))
(define *scribe-html-sc-stop* (lambda () #unspecified))

;; sup
(define *scribe-html-sup-start* (lambda () (display "<sup>")))
(define *scribe-html-sup-stop* (lambda () (display "</sup>")))

;; sub
(define *scribe-html-sub-start* (lambda () (display "<sub>")))
(define *scribe-html-sub-stop* (lambda () (display "</sub>")))

;; Section
(define *scribe-html-section-start* (lambda () #unspecified))
(define *scribe-html-section-stop* (lambda () (print "</p><br>")))
(define *scribe-html-section-title-start* (lambda () (display "<h2>")))
(define *scribe-html-section-title-stop* (lambda () (display "</h2><p>")))

;; chapter
(define *scribe-html-chapter-start* (lambda () #unspecified))
(define *scribe-html-chapter-stop* (lambda () (print "</p><br>")))
(define *scribe-html-chapter-title-start* (lambda () (display "<h1>")))
(define *scribe-html-chapter-title-stop* (lambda () (display "</h1><p>")))

;; Subsection
(define *scribe-html-subsection-start* (lambda () #unspecified))
(define *scribe-html-subsection-stop* (lambda () (print "</p><br>")))
(define *scribe-html-subsection-title-start* (lambda () (display "<h3>")))
(define *scribe-html-subsection-title-stop* (lambda () (display "</h3><p>")))

;; Subsubsection
(define *scribe-html-subsubsection-start* (lambda () #unspecified))
(define *scribe-html-subsubsection-stop* (lambda () (print "</p><br>")))
(define *scribe-html-subsubsection-title-start* (lambda () (display "<h4>")))
(define *scribe-html-subsubsection-title-stop* (lambda () (display "</h4><p>")))

;; Paragraph
(define *scribe-html-paragraph-start* (lambda () (print "<p>")))
(define *scribe-html-paragraph-stop* (lambda () (print "</p>")))

