;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribehtml/sui.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Sep 23 14:03:53 2001                          */
;*    Last change :  Sat Dec  1 17:48:58 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    The translator scribe->sui (scribe url index)                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribehtml_sui
   
   (library scribeapi)

   (import  __scribehtml_api
	    __scribehtml_tools)
   
   (export  (generic sui ::obj)))

;*---------------------------------------------------------------------*/
;*    sui ::obj ...                                                    */
;*---------------------------------------------------------------------*/
(define-generic (sui obj::obj)
   (cond
      ((procedure? obj)
       (sui (obj)))
      ((list? obj)
       (for-each sui obj))
      (else
       #unspecified)))

;*---------------------------------------------------------------------*/
;*    referenced-file ...                                              */
;*---------------------------------------------------------------------*/
(define (referenced-file file)
   (if (or (string=? (suffix file) "scr")
	   (string=? (suffix file) "sui"))
       (string-append (prefix file) ".html")
       file))

;*---------------------------------------------------------------------*/
;*    sui ::%document ...                                              */
;*---------------------------------------------------------------------*/
(define-method (sui obj::%document)
   (define (title->string title)
      (cond
	 ((string? title)
	  title)
	 ((pair? title)
	  (title->string (car title)))
	 (else
	  "???")))
   (with-access::%document obj (title mark-table file)
      (pp `(scribe-url-index ,(title->string title)
			     :file ,(referenced-file file)
			     ,(sui-marks obj)
			     ,(sui-chapters obj)
			     ,(sui-sections obj)
			     ,(sui-subsections obj)
			     ,(sui-subsubsections obj)))
      (newline)))

;*---------------------------------------------------------------------*/
;*    sui-marks ...                                                    */
;*---------------------------------------------------------------------*/
(define (sui-marks doc::%document)
   (with-access::%document doc (mark-table)
      `(marks ,@(map (lambda (lbl)
			 (with-access::%mark lbl (id parent)
			    `(,id :file ,(referenced-file
					  (container-file parent))
				  :mark ,id)))
		      (hashtable->list mark-table)))))

;*---------------------------------------------------------------------*/
;*    sui-chapters ...                                                 */
;*---------------------------------------------------------------------*/
(define (sui-chapters doc::%document)
   `(chapters
     ,@(map (lambda (chap)
	       (with-access::%chapter chap (title subtitle stamp)
		  `(,(or subtitle title)
		    :file ,(referenced-file (chapter-file chap))
		    :mark ,stamp)))
	    (document-chapters doc))))
			     
;*---------------------------------------------------------------------*/
;*    sui-sections ...                                                 */
;*---------------------------------------------------------------------*/
(define (sui-sections doc::%document)
   `(sections
     ,@(map (lambda (sec)
	       (with-access::%section sec (title stamp)
		  `(,title
		    :file ,(referenced-file (container-file sec))
		    :mark ,stamp)))
	    (document-sections doc))))
			     
;*---------------------------------------------------------------------*/
;*    sui-subsections ...                                              */
;*---------------------------------------------------------------------*/
(define (sui-subsections doc::%document)
   `(subsections
     ,@(map (lambda (sec)
	       (with-access::%subsection sec (title stamp)
		  `(,title
		    :file ,(referenced-file (container-file sec))
		    :mark ,stamp)))
	    (apply append
		   (map (lambda (s) (section-subsections s))
			(document-sections doc))))))

;*---------------------------------------------------------------------*/
;*    sui-subsubsections ...                                           */
;*---------------------------------------------------------------------*/
(define (sui-subsubsections doc::%document)
   `(subsubsections
     ,@(map (lambda (sec)
	       (with-access::%subsubsection sec (title stamp)
		  `(,title
		    :file ,(referenced-file (container-file sec))
		    :mark ,stamp)))
	    (apply append
		   (map (lambda (s)
			   (apply append
				  (map (lambda (s)
					  (subsection-subsubsections s))
				       (section-subsections s))))
			(document-sections doc))))))
			     
