#include "fontprefs.h"
#include <qhbox.h>
extern QPixmap loadIcon(QString nam);

// #include <iostream.h>

FontPrefs::FontPrefs( QWidget* parent,  SCFonts &flist)
    : QDialog( parent, "fpre", true, 0 )
{
    setCaption( tr( "Global Fontsettings" ) );
  	setIcon(loadIcon("AppIcon.xpm"));
    FontPrefsLayout = new QVBoxLayout( this );
    FontPrefsLayout->setSpacing( 5 );
    FontPrefsLayout->setMargin( 10 );
		Table1 = new QTable( this, "Table1" );
//		cout << "flist.count is " << flist.count() << endl;
		Table1->setNumRows( flist.count() );
    Table1->setNumCols( 5 );
//		cout << "Constructing iterator..." << endl;
		SCFontsIterator it(flist);
    int a = 0;
    for ( ; it.current(); ++it)
    	{
//			cout << "Setting currentKey()" << it.currentKey() << endl;
			Table1->setText(a, 0, it.currentKey());
//			cout << "Setting realname()" << endl;
//			cout << it.current()->RealName() << endl;
    	Table1->setText(a, 1, it.current()->RealName());
			QCheckBox *cp2 = new QCheckBox(this, "ps");
    	cp2->setText(tr("Postscript"));
    	cp2->setChecked(it.current()->EmbedPS);
    	cp2->setBackgroundColor(white);
    	FlagsPS.append(cp2);
    	Table1->setCellWidget(a, 2, cp2);
    	Table1->setText(a, 3, it.current()->Datei);
    	if (it.current()->HasMetrics)
    		Table1->setText(a, 4, tr("Yes"));
    	else
    		Table1->setText(a, 4, tr("No"));
    	a++;
    	}
    Zeilen = a-1;
    Table1->setSorting(false);
    Table1->setSelectionMode(QTable::NoSelection);
    Table1->setLeftMargin(0);
    Table1->verticalHeader()->hide();
    Header = Table1->horizontalHeader();
    Header->setLabel(0, tr("QT-Name"));
    Header->setLabel(1, tr("Postscript-Name"));
    Header->setLabel(2, tr("Embed in:"));
    Header->setLabel(3, tr("Path to Fontfile"));
    Header->setLabel(4, tr("AFM-File available"));
    Table1->adjustColumn(0);
    Table1->adjustColumn(1);
    Table1->setColumnWidth(2, 110);
    Table1->adjustColumn(3);
		Table1->setColumnWidth(4, Header->sectionSize(4));
    Table1->sortColumn(0, 1, 1);
    Table1->setColumnMovingEnabled(false);
    Table1->setRowMovingEnabled(false);
    Header->setMovingEnabled(false);
//    Header->setResizeEnabled(false);
    FontPrefsLayout->addWidget( Table1 );

    Layout2 = new QHBoxLayout;
    Layout2->setSpacing( 30 );
    Layout2->setMargin( 0 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout2->addItem( spacer );
    PushButton1_2 = new QPushButton( this, "PushButton1_2" );
    PushButton1_2->setMinimumSize( QSize( 90, 30 ) );
    PushButton1_2->setText( tr( "Cancel" ) );
    PushButton1_2->setDefault( TRUE );
    Layout2->addWidget( PushButton1_2 );
    PushButton1 = new QPushButton( this, "PushButton1" );
    PushButton1->setMinimumSize( QSize( 90, 30 ) );
    PushButton1->setText( tr( "OK" ) );
    Layout2->addWidget( PushButton1 );
    FontPrefsLayout->addLayout( Layout2 );
    resize( 590, 255 );
//    setMinimumSize( sizeHint() );

    // signals and slots connections
    connect( PushButton1_2, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( PushButton1, SIGNAL( clicked() ), this, SLOT( accept() ) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
FontPrefs::~FontPrefs()
{
    // no need to delete child widgets, Qt does it all for us
}

