/***************************************************************************
                          fpalettev.cpp  -  description
                             -------------------
    begin                : Sat Apr 14 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "fpalettev.h"
#include "fpalettev.moc"
#include "icons2.h"

FPaletteV::FPaletteV(QWidget *pa, int x, int y, int typ) : QPushButton(pa)
{
	if (typ == 1)
		{
		pixm = QPixmap(hBar);
		}
	else
		{
		pixm = QPixmap(vBar);
		}
	Art = typ;
	resize(pixm.width(), pixm.height());
	move(x, y);
	mp = FALSE;
	setFocusPolicy(QWidget::NoFocus);
}
FPaletteV::~FPaletteV(){
}

void FPaletteV::drawButton(QPainter *p)
{
	p->drawPixmap(0,0, pixm);
}

void FPaletteV::mousePressEvent(QMouseEvent *m)
{
	if (m->button() == LeftButton)
		{
		mp = TRUE;
		xp = m->x();
		yp = m->y();
		}
}

void FPaletteV::mouseReleaseEvent(QMouseEvent *m)
{
	QRect tr;
	if (Art == 1)
		{
		tr = QRect(5, 2, 7, 8);
		}
	else
		{
		tr = QRect(2, 5, 7, 8);
		}
	if ((m->button() == LeftButton) && tr.contains(m->pos()))
		{
		emit Schliessen();
		}
	else
		{
		mp = FALSE;
		}
}

void FPaletteV::mouseMoveEvent(QMouseEvent *m)
{
	if (mp)
		{
		parentWidget()->move(m->globalX()-xp, m->globalY()-yp);
		}
}




