/***************************************************************************
                          pageitem.cpp  -  description
                             -------------------
    begin                : Sat Apr 7 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pageitem.h"
#include <qpainter.h>
#include <qpen.h>
#include <qfontmetrics.h>
#include <qregion.h>
#include <qpoint.h>
#include <qfileinfo.h>
#include <qpaintdevicemetrics.h>
//#include <iostream.h>
#include "page.h"
extern float Cwidth(ScribusDoc *doc, QPainter *p, QString name, QString ch, int Siz);

PageItem::PageItem(Page *pa, int art, float x, float y, float w, float h, int w2, QString fill, QString outline, ScribusDoc *doc) : QObject(pa)
{
	BackBox = 0;
	NextBox = 0;
	Xpos = x;
	Ypos = y;
	Width = w;
	Height = h;
	PType = art;
	Rot = 0;
	Parent = pa;
	Doc = doc;
	Pcolor = fill;
	Pcolor2 = outline;
	Shade = 100;
	Shade2 = 100;
	Pwidth = w2;
	PLineArt = Doc->DLineArt;
	PLineEnd = FlatCap;
	PLineJoin = MiterJoin;
	Select = false;
	FrameOnly = false;
	ClipEdited = false;
	FrameType = 0;
	QFont ffo;
	QPainter p;
	p.begin(Parent);
	QPaintDeviceMetrics pm(Parent);
	DevRes = 75.0 / float(pm.logicalDpiX());
	ffo = Doc->UsedFonts[Doc->Dfont];
	ffo.setPointSize(Doc->Dsize * DevRes);
	p.setFont(ffo);
	IFont = Doc->Dfont;
	ISize = Doc->Dsize;
	LineSp = (Doc->Dsize * float(Doc->AutoLine) / 100) + Doc->Dsize;
	Doc->Vorlagen[0].LineSpa = LineSp;
	p.end();
	CurX = 0;
	CurY = 0;
	CPos = 0;
	Extra = 1;
	ExtraV = 0;
	Ptext.clear();
	Ptext.setAutoDelete(true);
	Pfile = "";
	pixm = QPixmap();
	LocalScX = 1;
	LocalScY = 1;
	LocalX = 0;
	LocalY = 0;
	flippedH = 0;
	flippedV = 0;
	BBoxX = 0;
	BBoxH = 0;
	RadRect = 0;
	if ((art == 4) || (art == 2))
		Frame = true;
	else
		Frame = false;
	if (art == 1)
		Clip.makeEllipse(0, 0, int(w), int(h));
	else
		Clip.setPoints(4, 0,0, int(w),0, int(w),int(h), 0,int(h));
	OwnPage = pa;
	isPrintable = true;
	isBookmark = false;
  BMnr = 0;
	isAnnotation = false;
	AnType = 0;
	AnAction = "0 0 0";
	AnZiel = 0;
	HasSel = false;
	Textflow = true;
	Tinput = false;
	isAutoText = false;
	Ausrich = 0;
	Redrawn = false;
	isRaster = false;
	Sizing = false;
	toPixmap = false;
	UseEmbedded = true;
	EmProfile = "";
	Groups.clear();
}

PageItem::~PageItem(){
}

/** Zeichnet das Item */
void PageItem::paintObj(QRect e, QPixmap *ppX)
{
	QPainter p, pp;
	QPoint pt1, pt2;
	QRegion cm;
	QFont ffo;
	uint a, nrc, nrc2, zae;
	int desc, asce, xp, yp, leng, h, s, sneu, v, absa, aSpa, chs;
	uint BuPos, LastSP, BuPos2;
	float oldCurY, LastXp, EndX, OFs, OFs2, wide;
	bool outs = false;
	PageItem *nb;
	QColor tmp;
	QString chx;
	struct Pti *hl;
	struct ZZ *Zli;
	struct ZZ *Zli2;
	QList<ZZ> LiList;
	LiList.setAutoDelete(true);
	for (int xxx=0; xxx<5; xxx++)
		{
		Doc->Vorlagen[xxx].LineSpa = LineSp;
		Doc->Vorlagen[xxx].Indent = 0;
		Doc->Vorlagen[xxx].First = 0;
		Doc->Vorlagen[xxx].Avor = 0;
		Doc->Vorlagen[xxx].Anach = 0;
		}
	Doc->Vorlagen[0].Ausri = Ausrich;
	if (toPixmap)
		p.begin(ppX);
	else
		p.begin(Parent);
	QPaintDeviceMetrics pm(Parent);
	DevRes = 75.0 / float(pm.logicalDpiX());
	if (!e.isEmpty())
		p.setClipRect(e);
	else
		p.setClipRect(OwnPage->ViewReg().boundingRect());
	QRegion gesClip = p.clipRegion();
	p.translate(int(Xpos*Doc->Scale), int(Ypos*Doc->Scale));
	p.scale(double(Doc->Scale), double(Doc->Scale));
	p.rotate(double(Rot));
	if (flippedH % 2 != 0)
		{
		p.translate(Width, 0);
		p.scale(-1, 1);
		}
	if (flippedV % 2 != 0)
		{
		p.translate(0, Height);
		p.scale(1, -1);
		}
	if (Pcolor != "None")
		{
		Doc->PageColors[Pcolor].getRGBColor().rgb(&h, &s, &v);
		if ((h == s) && (s == v))
			{
			Doc->PageColors[Pcolor].getRGBColor().hsv(&h, &s, &v);
			sneu = 255 - ((255 - v) * Shade / 100);
			tmp.setHsv(h, s, sneu);			
			}
		else
			{
			Doc->PageColors[Pcolor].getRGBColor().hsv(&h, &s, &v);
			sneu = s * Shade / 100;
			tmp.setHsv(h, sneu, v);
			}
		p.setBrush(tmp);
		p.setBackgroundColor(tmp);
		}
	else
		p.setBrush(NoBrush);
	if (Pcolor2 != "None")
		{
		Doc->PageColors[Pcolor2].getRGBColor().rgb(&h, &s, &v);
		if ((h == s) && (s == v))
			{
			Doc->PageColors[Pcolor2].getRGBColor().hsv(&h, &s, &v);
			sneu = 255 - ((255 - v) * Shade2 / 100);
			tmp.setHsv(h, s, sneu);			
			}
		else
			{
			Doc->PageColors[Pcolor2].getRGBColor().hsv(&h, &s, &v);
			sneu = s * Shade2 / 100;
			tmp.setHsv(h, sneu, v);
			}
		p.setPen(QPen(tmp, int(Pwidth*Doc->Scale), PLineArt, PLineEnd, PLineJoin));
		}
	else
		p.setPen(NoPen);
	if (!FrameOnly)
	{
	if (!((Doc->ActPage->Imoved) && (Select)))
		{
		switch (PType)
			{
			case 1:
				p.drawEllipse(0, 0, int(Width), int(Height));
				break;
			case 2:
				p.setClipRegion(QRegion(p.xForm(Clip)).intersect(gesClip));
				if (Pcolor != "None")
					{
					p.setPen(NoPen);
					p.drawPolygon(Clip);
					}
				if (Pfile == "")
					{
					p.setPen(QPen(black, 1, SolidLine, FlatCap, MiterJoin));
					p.drawLine(0, 0, Width, Height);
					p.drawLine(0, Height, Width, 0);
					}
				else
					{
					if ((!PicArt) || (!PicAvail))
						{
						p.setPen(QPen(black, 1, SolidLine, FlatCap, MiterJoin));
						p.drawLine(0, 0, Width, Height);
						p.drawLine(0, Height, Width, 0);
						if (PicAvail)
							{
							p.setPen(blue);
							}
						else
							{
							p.setPen(red);
							}
						p.save();
						if (flippedH % 2 != 0)
							{
							p.translate(Width, 0);
							p.scale(-1, 1);
							}
						if (flippedV % 2 != 0)
							{
							p.translate(0, Height);
							p.scale(1, -1);
							}
						p.setBackgroundMode(OpaqueMode);
						p.setFont(QFont("Helvetica", 18));
						QFileInfo fi = QFileInfo(Pfile);
						leng = p.fontMetrics().width(fi.fileName());
						xp = int(Width / 2 - leng / 2);
						yp = int(Height / 2 + p.fontMetrics().height() / 2);
						p.drawText(xp, yp, fi.fileName());
						p.restore();
						}
					else
						{
						p.save();
						p.scale(LocalScX, LocalScY);
						p.drawPixmap(LocalX, LocalY, pixm);
						p.restore();
						}
					}
				break;
			case 3:
				if (RadRect != 0)
					{
					float RR = RadRect * 2;
					QPointArray e1 = QPointArray();
					QPointArray e2 = QPointArray();
					QPointArray e3 = QPointArray();
					QPointArray e4 = QPointArray();
					e1.makeArc(0, 0, int(RR), int(RR), 1440, 1440);
					e2.makeArc(0, int(Height-RR), int(RR), int(RR), 2880, 1440);
					e3.makeArc(int(Width-RR), int(Height-RR), int(RR), int(RR), 4320, 1440);
					e4.makeArc(int(Width-RR), 0, int(RR), int(RR), 0, 1440);
					QPointArray e5 = QPointArray(e1.size()+e2.size()+e3.size()+e4.size()+1);
					for (uint ae = 0; ae < e1.size(); ae++)
						{
						e5.setPoint(ae, e1.point(ae));
						}
					for (uint ae = 0; ae < e2.size(); ae++)
						{
						e5.setPoint(ae+e1.size(), e2.point(ae));
						}
					for (uint ae = 0; ae < e3.size(); ae++)
						{
						e5.setPoint(ae+e1.size()+e2.size(), e3.point(ae));
						}
					for (uint ae = 0; ae < e4.size(); ae++)
						{
						e5.setPoint(ae+e1.size()+e2.size()+e3.size(), e4.point(ae));
						}
					e5.setPoint(e5.size()-1, e1.point(0));
					p.drawPolygon(e5);
					}
				else
					p.drawRect(0, 0, int(Width), int(Height));
				break;
			case 4:
				if ((Ptext.count() != 0) || (Dirty) || (NextBox != 0))
					{
					if (NextBox != 0)
						{
						nb = NextBox;
						while (nb != 0)
							{
							a = nb->Ptext.count();
							for (uint s=0; s<a; s++)
								{
								Ptext.append(nb->Ptext.take(0));
								}
							nb->CPos = 0;
							nb->Dirty = true;
							nb = nb->NextBox;
							}
						nb = NextBox;
						}
					Doc->Vorlagen[0].LineSpa = LineSp;
					QRegion cl = QRegion(p.xForm(Clip));
					if ((OwnPage->Items.count()-1) > ItemNr)
						{
						for (a=ItemNr+1; a<OwnPage->Items.count(); a++)
							{
							if (OwnPage->Items.at(a)->Textflow)
								{
								pp.begin(Parent);
								pp.translate(OwnPage->Items.at(a)->Xpos*Doc->Scale, OwnPage->Items.at(a)->Ypos*Doc->Scale);
								pp.scale(Doc->Scale, Doc->Scale);
								pp.rotate(OwnPage->Items.at(a)->Rot);
								cm = QRegion(pp.xForm(OwnPage->Items.at(a)->Clip));
								pp.end();
								cl = cl.subtract(cm);
								}
							}
						}
					p.setClipRegion(QRegion(p.xForm(Clip)).intersect(gesClip));
					if ((Doc->AppMode == 7) && (Dirty))
						{
						if ((CPos < int(Ptext.count())) && (CPos > 2) && (Tinput))
							{
							hl = Ptext.at(CPos-2);
							p.eraseRect(0, hl->yp-LineSp, Width, Height-hl->yp);
							}
						else
							p.eraseRect(0, 0, Width, Height);
						Dirty = false;
						}
					if (Pcolor != "None")
						{
						p.setPen(NoPen);
						p.drawPolygon(Clip);
						}
					p.setClipRegion(QRegion(p.xForm(Clip)).intersect(gesClip));
					CurX = Extra;
					CurY = Doc->Vorlagen[0].LineSpa+Extra;
					LiList.clear();
					BuPos = 0;
					BuPos2 = 0;
					LastSP = 0;
					LastXp = 0;
					outs = false;
					OFs = 0;
					OFs2 = 0;
					aSpa = 0;
					absa = 0;
					for (a = 0; a < Ptext.count(); a++)
						{
						hl = Ptext.at(a);
						chx = hl->ch;
						if (hl->ch == QChar(30))
							{
							if (Doc->MasterP)
								chx = "#";
							else
								{
								zae = 0;
								while (Ptext.at(a+zae)->ch == QChar(30))
									{
									zae++;
									if (a+zae == Ptext.count())
										break;
									}
								QString out="%1";
								chx = out.arg(OwnPage->PageNr+1, zae).right(zae).left(1);
								}
							}
						absa = hl->cab;
						if (a == 0)
							{
							if (BackBox != 0)
								{
								nb = BackBox;
								while (nb != 0)
									{
									if (nb->Ptext.count() != 0)
										{
										if (nb->Ptext.at(nb->Ptext.count()-1)->ch == QChar(13))
											{
											CurX += Doc->Vorlagen[absa].First;
											CurX += Doc->Vorlagen[absa].Indent;
											CurY += Doc->Vorlagen[absa].Avor;
											break;
											}
										else
											{
											CurX += Doc->Vorlagen[absa].Indent;
											break;
											}
										nb = nb->BackBox;
										}
									}
								}
							else
								{
								CurX += Doc->Vorlagen[absa].First;
								CurX += Doc->Vorlagen[absa].Indent;
								CurY += Doc->Vorlagen[absa].Avor;
								}
							}
						if ((Doc->Vorlagen[0].LineSpa != Doc->Vorlagen[absa].LineSpa) && (a == 0))
							{
							CurY += Doc->Vorlagen[absa].LineSpa - Doc->Vorlagen[0].LineSpa;
							CurY += Doc->Vorlagen[absa].Avor;
							}
						ffo = Doc->UsedFonts[hl->cfont];
						if (hl->ccolor != "None")
							{
							Doc->PageColors[hl->ccolor].getRGBColor().rgb(&h, &s, &v);
							if ((h == s) && (s == v))
								{
								Doc->PageColors[hl->ccolor].getRGBColor().hsv(&h, &s, &v);
								sneu = 255 - ((255 - v) * hl->cshade / 100);
								tmp.setHsv(h, s, sneu);			
								}
							else
								{
								Doc->PageColors[hl->ccolor].getRGBColor().hsv(&h, &s, &v);
								sneu = s * hl->cshade / 100;
								tmp.setHsv(h, sneu, v);
								}
							p.setPen(tmp);
							}
						else
							p.setPen(NoPen);
						if (LiList.count() == 0)
							{
							CurY += Doc->Vorlagen[absa].LineSpa - Doc->Vorlagen[0].LineSpa;
							if ((a > 0) && (Ptext.at(a-1)->ch == QChar(13)))
								{
								CurX += Doc->Vorlagen[hl->cab].First;
								CurX += Doc->Vorlagen[hl->cab].Indent;
								CurY += Doc->Vorlagen[hl->cab].Avor;
								}
							}
						oldCurY = CurY;
						chs = hl->csize;
						ffo.setPointSize(hl->csize*DevRes);
						p.setFont(ffo);
						desc = p.fontMetrics().descent();
						asce = p.fontMetrics().ascent();
						int chst = hl->cstyle & 127;
						if (chst != 0)
							{
							if (chst & 32)
								ffo.setBold(true);
							if (chst & 16)
								ffo.setStrikeOut(true);
							if (chst & 8)
								ffo.setUnderline(true);
							if (chst & 4)
								ffo.setItalic(true);
							if (chst & 1)
								{
								CurY -= asce * Doc->VHoch / 100;
								ffo.setPointSize(hl->csize * DevRes * Doc->VHochSc / 100);
								chs = hl->csize * Doc->VHochSc / 100;
								}
							if (chst & 2)
								{
								CurY += asce * Doc->VTief / 100;
								ffo.setPointSize(hl->csize * DevRes * Doc->VTiefSc / 100);
								chs = hl->csize * Doc->VTiefSc / 100;
								}
							if (chst & 64)
								{
								if (chx.upper() != chx)
									{
									ffo.setPointSize(hl->csize * DevRes * Doc->VKapit / 100);
									chs = hl->csize * Doc->VKapit / 100;
									chx = chx.upper();
									}
								}
							}
						p.setFont(ffo);
						wide = Cwidth(Doc, &p, hl->cfont, chx, chs);
						desc = p.fontMetrics().descent();
						asce = p.fontMetrics().ascent();
						if (LiList.isEmpty())
							{
							pt1 = QPoint(CurX, CurY+desc);
							pt2 = QPoint(CurX, CurY-asce);
							while ((!cl.contains(p.xForm(pt1))) || (!cl.contains(p.xForm(pt2))))
								{
								CurX++;
								pt1 = QPoint(CurX, CurY+desc);
								pt2 = QPoint(CurX, CurY-asce);
								if (CurX > Width)
									{
									CurY += Doc->Vorlagen[hl->cab].LineSpa;
									CurY += Doc->Vorlagen[hl->cab].Anach;
									CurX = Extra;
									if (CurY > Height)
										{
										nrc = a;
										goto NoRoom;
										}
									}
								}
								CurX += Extra;
							}
						hl->xp = CurX+hl->cextra;
						hl->yp = CurY;
						CurY = oldCurY;
						CurX += wide+hl->cextra;
						pt1 = QPoint(CurX+Extra, CurY+desc);
						pt2 = QPoint(CurX+Extra, CurY-asce);
						if ((!cl.contains(p.xForm(pt1))) || (!cl.contains(p.xForm(pt2))))
							outs = true;
						Zli = new ZZ;
						Zli->Zeich = chx;
						Zli->Farb = tmp;
						Zli->Zsatz = ffo;
						Zli->xco = hl->xp;
						Zli->yco = hl->yp;
						Zli->Sele = hl->cselect;
						Zli->Siz = hl->csize;
						Zli->ZFo = hl->cfont;
						if ((hl->ch == " ") && (!outs))
							{
							LastXp = hl->xp;
							LastSP = BuPos;
							}
						if ((hl->ch == "-") && (!outs))
							{
							LastXp = CurX;
							LastSP = BuPos;
							}
						if ((hl->cstyle & 128) && (!outs))
							{
							LastXp = CurX + Cwidth(Doc, &p, hl->cfont, "-", hl->csize);
							LastSP = BuPos;
							}
						LiList.append(Zli);
						BuPos++;
						if ((hl->ch == QChar(13)) || (outs))
							{
							if (outs)
								{
								if (LastSP != 0)            // Hier knnen auch andere Trennungen eingebaut werden
									{
									a -= BuPos - LastSP;
									a++;
									if (Ptext.at(a)->cstyle & 128)
										{
										Zli = new ZZ;
										Zli->Zeich = "-";
										Zli->Farb = tmp;
										Zli->Zsatz = ffo;
										Zli->xco = LastXp - Cwidth(Doc, &p, Ptext.at(a)->cfont, "-", Ptext.at(a)->csize);
										Zli->yco = Ptext.at(a)->yp;
										Zli->Sele = Ptext.at(a)->cselect;
										Zli->Siz = Ptext.at(a)->csize;
										Zli->ZFo = Ptext.at(a)->cfont;
										LiList.insert(LastSP+1, Zli);
										LastSP += 1;
										}
									BuPos = LastSP+1;
									if (Tinput)
										{
										if (Doc->Vorlagen[absa].Ausri == 0)
											p.eraseRect(LastXp, CurY-asce, Width-LastXp, asce+desc+1);
										else
											p.eraseRect(0, CurY-asce, Width, asce+desc+1);
										}
									if (Doc->Vorlagen[absa].Ausri != 0)
										{
										EndX = LastXp;
										do
										{
											pt1 = QPoint(EndX+Extra, CurY+desc);
											pt2 = QPoint(EndX+Extra, CurY-asce);
											EndX++;
										}
										while ((cl.contains(p.xForm(pt1))) && (cl.contains(p.xForm(pt2))));
										if (Doc->Vorlagen[absa].Ausri == 2)
											OFs = EndX - LastXp;
										if (Doc->Vorlagen[absa].Ausri == 1)
											OFs = (EndX - LastXp) / 2;
										if ((Doc->Vorlagen[absa].Ausri == 3) || (Doc->Vorlagen[absa].Ausri == 4))
											{
											aSpa = 0;
											for (uint sof = 0; sof<BuPos-1; sof++)
												{
												if (LiList.at(sof)->Zeich == QChar(32))
													aSpa++;
												}
											if (aSpa > 1)
												{
												OFs2 = (EndX - LastXp) / aSpa;
												}
											else
												{
												if (aSpa == 0)
													OFs2 = 0;
												else
													OFs2 = (EndX - LastXp);
												}
											OFs = 0;
											for (uint yof = 0; yof < LiList.count(); yof++)
												{
												LiList.at(yof)->xco += OFs;
												Ptext.at(BuPos2)->xp += OFs;
												BuPos2++;
												if (LiList.at(yof)->Zeich == QChar(32))
													OFs += OFs2;										
												}
											}
										else
											{
											for (uint xof = 0; xof<LiList.count(); xof++)
												{
												LiList.at(xof)->xco += OFs;
												Ptext.at(BuPos2)->xp += OFs;
												BuPos2++;
												}
											}
										}
									}
								else
									{
									a--;
									BuPos--;
									}
								}
							else
								{
								if (Doc->Vorlagen[absa].Ausri != 0)
									{
									EndX = CurX;
									do
									{
										pt1 = QPoint(EndX+Extra, CurY+desc);
										pt2 = QPoint(EndX+Extra, CurY-asce);
										EndX++;
									}
									while ((cl.contains(p.xForm(pt1))) && (cl.contains(p.xForm(pt2))));
									if (Doc->Vorlagen[absa].Ausri == 2)
										OFs = EndX - CurX - Extra;
									if (Doc->Vorlagen[absa].Ausri == 1)
										OFs = (EndX - CurX - Extra) / 2;
									if (Doc->Vorlagen[absa].Ausri == 3)
										OFs = 0;
									if (Doc->Vorlagen[absa].Ausri == 4)
										{
										aSpa = 0;
										for (uint sof = 0; sof<LiList.count(); sof++)
											{
											if (LiList.at(sof)->Zeich == QChar(32))
												aSpa++;
											}
										if (aSpa != 0)
											{
											OFs2 = (EndX - CurX - Extra) / aSpa;
											}
										else
											OFs2 = 0;
										OFs = 0;
										for (uint yof = 0; yof < LiList.count(); yof++)
											{
											LiList.at(yof)->xco += OFs;
											Ptext.at(BuPos2)->xp += OFs;
											BuPos2++;
											if (LiList.at(yof)->Zeich == QChar(32))
												OFs += OFs2;										
											}
										}
									else
										{
										for (uint xof = 0; xof<LiList.count(); xof++)
											{
											LiList.at(xof)->xco += OFs;
											Ptext.at(BuPos2)->xp += OFs;
											BuPos2++;
											}
										}
									}							
								}
							BuPos2 = a;
							BuPos2++;
							uint BuPos3 = BuPos;
							CurY += Doc->Vorlagen[0].LineSpa;
							CurX = Extra;
							if (hl->ch != QChar(13))
								CurX += Doc->Vorlagen[hl->cab].Indent;
							else
								{
								CurY += Doc->Vorlagen[hl->cab].Anach;
								if (BuPos3 > 0)
								BuPos3 -= 1;
								}
							hl->xp = CurX;
							hl->yp = CurY;
							LiList.at(LiList.count()-1)->xco = hl->xp;
							LiList.at(LiList.count()-1)->yco = hl->yp;
							for (uint zc = 0; zc<BuPos3; zc++)
								{
								Zli2 = LiList.at(zc);
								p.setFont(Zli2->Zsatz);
								p.setPen(Zli2->Farb);
								if ((Zli2->Sele) && (Doc->AppMode == 7) && (Select))
									{
									p.save();
									wide = Cwidth(Doc, &p, Zli2->ZFo, Zli2->Zeich, Zli2->Siz);
									desc = p.fontMetrics().descent();
									asce = p.fontMetrics().ascent();
									p.setPen(NoPen);
            			p.setBrush(darkBlue);
            			p.drawRect(Zli2->xco, Zli2->yco-asce, wide+1, asce+desc);
									p.restore();
									p.setPen(white);
									}
								else
									{
									if (Doc->AppMode == 7)
										{
										p.save();
										wide = Cwidth(Doc, &p, Zli2->ZFo, Zli2->Zeich, Zli2->Siz);
										desc = p.fontMetrics().descent();
										asce = p.fontMetrics().ascent();
            				p.eraseRect(Zli2->xco, Zli2->yco-asce, wide+1, asce+desc);
										p.restore();
										}
									}
								p.drawText(Zli2->xco, Zli2->yco, Zli2->Zeich);
								}
							LiList.clear();
							BuPos = 0;
							LastSP = 0;
							LastXp = 0;
							outs = false;
							}
						}
						if (Doc->Vorlagen[absa].Ausri != 0)
							{
							EndX = CurX;
							desc = p.fontMetrics().descent();
							asce = p.fontMetrics().ascent();
							if (Tinput)
								p.eraseRect(0, CurY-asce, Width, asce+desc+1);
							do
							{
								pt1 = QPoint(EndX+Extra, CurY+desc);
								pt2 = QPoint(EndX+Extra, CurY-asce);
								EndX++;
							}
							while ((cl.contains(p.xForm(pt1))) && (cl.contains(p.xForm(pt2))));
							if (Doc->Vorlagen[absa].Ausri == 2)
								OFs = EndX - CurX - Extra;
							if (Doc->Vorlagen[absa].Ausri == 1)
								OFs = (EndX - CurX - Extra) / 2;
							if (Doc->Vorlagen[absa].Ausri == 3)
								OFs = 0;
							if (Doc->Vorlagen[absa].Ausri == 4)
								{
								aSpa = 0;
								for (uint sof = 0; sof<LiList.count(); sof++)
									{
									if (LiList.at(sof)->Zeich == QChar(32))
										aSpa++;
									}
								if (aSpa != 0)
									{
									OFs2 = (EndX - CurX - Extra) / aSpa;
									}
								else
									OFs2 = 0;
								OFs = 0;
								for (uint yof = 0; yof < LiList.count(); yof++)
									{
									LiList.at(yof)->xco += OFs;
									Ptext.at(BuPos2)->xp += OFs;
									BuPos2++;
									if (LiList.at(yof)->Zeich == QChar(32))
										OFs += OFs2;										
									}
								}
							else
								{
								for (uint xof = 0; xof<LiList.count(); xof++)
									{
										LiList.at(xof)->xco += OFs;
										Ptext.at(BuPos2)->xp += OFs;
										BuPos2++;
									}
								}
							}
						for (uint zc = 0; zc<LiList.count(); zc++)
							{
							Zli2 = LiList.at(zc);
							p.setFont(Zli2->Zsatz);
							p.setPen(Zli2->Farb);
							if ((Zli2->Sele) && (Doc->AppMode == 7) && (Select))
								{
								p.save();
								wide = Cwidth(Doc, &p, Zli2->ZFo, Zli2->Zeich, Zli2->Siz);
								desc = p.fontMetrics().descent();
								asce = p.fontMetrics().ascent();
								p.setPen(NoPen);
            		p.setBrush(darkBlue);
            		p.drawRect(Zli2->xco, Zli2->yco-asce, wide+1, asce+desc);
								p.restore();
								p.setPen(white);
								}
							else
								{
								if (Doc->AppMode == 7)
									{
									p.save();
									wide = Cwidth(Doc, &p, Zli2->ZFo, Zli2->Zeich, Zli2->Siz);
									desc = p.fontMetrics().descent();
									asce = p.fontMetrics().ascent();
           				p.eraseRect(Zli2->xco, Zli2->yco-asce, wide+1, asce+desc);
									p.restore();
									}
								}
							p.drawText(Zli2->xco, Zli2->yco, Zli2->Zeich);
							}
						LiList.clear();
						BuPos = 0;
						LastSP = 0;
						outs = false;
					}
					MaxChars = Ptext.count();
					break;
NoRoom:	 if (NextBox != 0)
						{
						nrc2 = Ptext.count();
						for (uint ss=nrc; ss<nrc2; ss++)
							{
							NextBox->Ptext.append(Ptext.take(nrc));
							}
						NextBox->Dirty = true;
						if (uint(CPos) > nrc)
							{
							CPos = nrc;
							if ((Doc->AppMode == 7) && (Tinput))
								{
								OwnPage->Deselect();
								NextBox->CPos = 1;
								Doc->ActPage = NextBox->OwnPage;
								NextBox->OwnPage->SelectItemNr(NextBox->ItemNr);
								break;
								}
							}
						NextBox->paintObj();
						}
					else
						{
						p.setPen(QPen(black, 1, SolidLine, FlatCap, MiterJoin));
						p.setBrush(white);
						p.drawRect(Width-16, Height-16, 14, 14);
						p.drawLine(Width-16, Height-16, Width-3, Height-3);
						p.drawLine(Width-16, Height-3, Width-3, Height-16);
						}
					MaxChars = nrc;
					Redrawn = true;
					break;
			case 5:
				p.drawLine(0, 0, int(Width), int(Height));
				break;
			}
		}
	}
	p.setClipping(FALSE);
	p.setClipRegion(gesClip);
	if (Sizing)
		{
		p.setRasterOp(XorROP);
		p.setBrush(NoBrush);
		p.setPen(QPen(white, 1, DotLine, FlatCap, MiterJoin));
		p.drawRect(0, 0, OldB, OldH);
		p.drawRect(0, 0, Width, Height);
		OldB = Width;
		OldH = Height;
		}
	if (!Tinput)
		{
		if ((Frame) && (Doc->ShFrames))
			{
			p.setPen(QPen(black, 1, DotLine, FlatCap, MiterJoin));
			if ((isBookmark) || (isAnnotation))
				p.setPen(QPen(blue, 1, DotLine, FlatCap, MiterJoin));
			if ((BackBox != 0) || (NextBox != 0))
				p.setPen(QPen(red, 1, SolidLine, FlatCap, MiterJoin));
			p.setBrush(NoBrush);
			p.drawPolygon(Clip);
			}
		if (Select) // && (!Doc->EditClip))
			{
			if (!OwnPage->SelItem.isEmpty())
				{
				if ((*OwnPage->SelItem.at(0) == ItemNr) || (Groups.count() == 0))
					{
					p.setPen(QPen(red, 1, DotLine, FlatCap, MiterJoin));
					p.setBrush(NoBrush);
					p.drawRect(-1, -1, int(Width+1), int(Height+1));
					p.setPen(QPen(red, 1, SolidLine, FlatCap, MiterJoin));
					p.setBrush(red);
					}
				else
					{
					p.setPen(QPen(darkCyan, 1, DotLine, FlatCap, MiterJoin));
					p.setBrush(NoBrush);
					p.drawRect(-1, -1, int(Width+1), int(Height+1));
					p.setPen(QPen(darkCyan, 1, SolidLine, FlatCap, MiterJoin));
					p.setBrush(darkCyan);
					}
				p.drawRect(-1, -1, 6, 6);
				p.drawRect(int(Width), int(Height), -6, -6);
				p.drawRect(int(Width), -1, -6, 6);
				p.drawRect(-1, int(Height), 6, -6);
				}
			}
		}
	Tinput = false;
	FrameOnly = false;
	p.end();
}

void PageItem::CopyIt(struct CLBuf *Buffer)
{
	uint a;
	Buffer->PType = PType;
	Buffer->Xpos = Xpos;
	Buffer->Ypos = Ypos;
	Buffer->Width = Width;
	Buffer->Height = Height;
	Buffer->RadRect = RadRect;
	Buffer->FrameType = FrameType;
	Buffer->ClipEdited = ClipEdited;
	Buffer->Pwidth = Pwidth;
	Buffer->Pcolor = Pcolor;
	Buffer->Pcolor2 = Pcolor2;
	Buffer->Shade = Shade;
	Buffer->Shade2 = Shade2;
	Buffer->Rot = Rot;
	Buffer->PLineArt = PLineArt;
	Buffer->PLineEnd = PLineEnd;
	Buffer->PLineJoin = PLineJoin;
	Buffer->LineSp = LineSp;
	Buffer->LocalScX = LocalScX;
	Buffer->LocalScY = LocalScY;
	Buffer->LocalX = LocalX;
	Buffer->LocalY = LocalY;
	Buffer->PicArt = PicArt;
	Buffer->flippedH = flippedH;
	Buffer->flippedV = flippedV;
	Buffer->BBoxX = BBoxX;
	Buffer->BBoxH = BBoxH;
	Buffer->isPrintable = isPrintable;
	Buffer->isBookmark = isBookmark;
	Buffer->isAnnotation = isAnnotation;
	Buffer->AnType = AnType;
	Buffer->AnAction = AnAction;
	Buffer->AnZiel = AnZiel;
	Buffer->Extra = Extra;
	Buffer->Pfile = Pfile;
	QString Text = "";
	if (Ptext.count() != 0)
		{
		for (a=0; a<Ptext.count(); a++)
			{
			Text += Ptext.at(a)->ch+"\t";
			Text += Ptext.at(a)->cfont+"\t";
			Text += QString::number(Ptext.at(a)->csize)+"\t";
			Text += Ptext.at(a)->ccolor+"\t";
			Text += QString::number(Ptext.at(a)->cextra)+"\t";
			Text += QString::number(Ptext.at(a)->cshade)+'\t';
			Text += QString::number(Ptext.at(a)->cstyle)+'\t';
			Text += QString::number(Ptext.at(a)->cab)+'\n';
			}
		}
	Buffer->Ptext = Text;
	Buffer->Clip = Clip.copy();
	Buffer->Textflow = Textflow;
	Buffer->Ausrich = Ausrich;
	Buffer->IFont = IFont;
	Buffer->ISize = ISize;
	Buffer->ExtraV = ExtraV;
	Buffer->Groups = Groups;
	Buffer->IProfile = IProfile;
	Buffer->IRender = IRender;
	Buffer->UseEmbedded = UseEmbedded;
	Buffer->EmProfile = EmProfile;
}
