
//////////////////////////////////////////////////////////////////////////
//
//   Slib, Sfront's SAOL library
//   This file: The trig library (trigonometric and related opcodes)
//   Copyright (C) 2000  Regents of the University of California
//
// This library file is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// The GNU C Library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with the GNU C Library; see the file COPYING.LIB.  If not,
// write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.  */
//
//   Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu
//
//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////
//                                                
//
// This library is a collection of polymorphic core opcode definitions,
// for trignometric and other related functions that are not in the 
// MP4-SA core opcode set.
//
//
// Opcode header                Description
//
// opcode tan(xsig x);          Tangent of x.
// opcode sinh(xsig x);         Hyperbolic sine of x.
// opcode cosh(xsig x);         Hyperbolic cosine of x.
// opcode tanh(xsig x);         Hyperbolic tangent of x.
// opcode asinh(xsig x);        Inverse hyperbolic sine of x.
// opcode acosh(xsig x);        Inverse hyperbolic cosine of x.
// opcode atanh(xsig x);        Inverse hyperbolic tangent of x.
// 
/////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
//                                                
// library definitions begin here
//

#ifndef SLIB_TRIG
#define SLIB_TRIG

opcode tan(xsig x) 

{
  return ((sin(x)/cos(x)));
}

opcode sinh(xsig x)

{
  xsig tmp;

  tmp = exp(x);
  return(0.5*(tmp - (1/tmp)));
}

opcode cosh(xsig x)

{
  xsig tmp;

  tmp = exp(x);
  return(0.5*(tmp + (1/tmp)));
}

opcode tanh(xsig x)

{
  xsig tmp;

  tmp = exp(x);
  tmp = tmp*tmp;
  return((tmp - 1)/(tmp + 1));
}

opcode asinh(xsig x)

{
  return(log(x + sqrt(x*x + 1)));
}

opcode acosh(xsig x)

{
  return(log(x + sqrt(x*x - 1)));
}

opcode atanh(xsig x)

{
  return(0.5*log((1+x)/(1-x)));
}


#endif // SLIB_TRIG 
