#ifndef _SIGX_STATIC_ASSERT_HPP_
#define _SIGX_STATIC_ASSERT_HPP_

/*
 * Copyright 2006 Klaus Triendl
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free 
 * Software Foundation, 51 Franklin Street, Fifth Floor, 
 * Boston, MA 02110-1301, USA.
*/

/**	@file Simplified version of boost's static assert.
 *	Can only be used at function scope.
 *	@todo To be removed if C++09 is out (has a static_assert)
 */


namespace sigx
{

// HP aCC cannot deal with missing names for template value parameters
template<bool B_>
struct static_assert;

template<> 
struct static_assert<true>
{};


// Not used; boost does many workarounds for different compilers to allow
// using a static assertion in namespace, template and class scope
#if 0
// HP aCC cannot deal with missing names for template value parameters
template<int I_> struct static_assert_test
{};
#endif
	

} // namespace sigx


#define SIGX_STATIC_ASSERT( expr ) \
	sizeof(::sigx::static_assert< (bool)( expr ) >)


#endif // end file guard
