/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 1999, 2001 SIL International. All rights reserved.

Distributable under the terms of either the Common Public License or the
GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: HwTextSrc.h
Responsibility: Sharon Correll
Last reviewed: Not yet.

Description:

-------------------------------------------------------------------------------*//*:End Ignore*/
#pragma once
#ifndef HWTXTSRC_INCLUDED
#define HWTXTSRC_INCLUDED


//typedef unsigned long int utf32;	// UTF32 encoded Unicode codepoints
//typedef unsigned short int utf16;	// UTF16 encoded Unicode codepoints
//typedef unsigned char utf8;			// UTF-8 encoded Unicode codepoints

//typedef struct tagGrCharProps // TODO: remove
//{
//    unsigned long clrFore;
//    unsigned long clrBack;
//    int dympOffset;
//    int ws;
//    int ows;
//    byte fWsRtl;
//    int nDirDepth;
//    byte ssv;
//    byte ttvBold;
//    byte ttvItalic;
//    int dympHeight;
//    wchar_t szFaceName[ 32 ];
//    wchar_t szFontVar[ 64 ];
//} GrCharProps;

using namespace gr;

/*----------------------------------------------------------------------------------------------
	Class: HwTextSrc
	This class provides a simple implementation for a text source for the Graphite engine.
	There are no paragraph properties of interest and one set of character properties that
	apply to the entire string.
----------------------------------------------------------------------------------------------*/
class HwTextSrc : public IColorTextSource
{
public:
	// Constructor:
	HwTextSrc(gr::utf16 * pszText,
		gr::utf16 * szFaceName, int pointSize,
		bool fBold, bool fItalic, bool fRtl);
	~HwTextSrc();

	virtual long IncRefCount(void)
	{
		return InterlockedIncrement(&m_cref);
	}
	virtual long DecRefCount(void)
	{
		long cref = InterlockedDecrement(&m_cref);
		if (cref == 0) {
			m_cref = 1;
			delete this;
		}
		return cref;
	}

	// -------------------------------------------------------------------------------
	// Interface methods:

	virtual UtfType utfEncodingForm()
	{
		return kutf16;
	}
	virtual size_t getLength()
	{
		return m_cchLength;
	}
	virtual size_t fetch(toffset ichMin, size_t cch, gr::utf32 * prgchBuffer)
	{
		throw;
	}
	virtual size_t fetch(toffset ichMin, size_t cch, gr::utf16 * prgchwBuffer);
	virtual size_t fetch(toffset ichMin, size_t cch, gr::utf8  * prgchsBuffer)
	{
		throw;
	};
	virtual bool getRightToLeft(int ich);
	virtual unsigned int getDirectionDepth(int ich);
	virtual float getVerticalOffset(int ich);

	virtual std::pair<toffset, toffset> propertyRange(int ich)
	{
		std::pair<toffset, toffset> pairRet;
		pairRet.first = 0;
		pairRet.second = m_cchLength;
		return pairRet;
	}

	virtual size_t getFontFeatures(int ich, FeatureSetting * prgfset)
	{
		return 0; // no features in this simple implementation
	}
	
	virtual bool sameSegment(int ich1, int ich2)
	{
		return true;
	}

	virtual void getColors(int ich, int * pclrFore, int * pclrBack)
	{
		*pclrFore = kclrBlack;
		*pclrBack = kclrTransparent;
	}

protected:
	long m_cref;
	gr::utf16 * m_prgchText;
	int m_cchLength;
	//utf16 m_rgchFontVar[64];

	gr::utf16 m_szFaceName[32];
	int m_pointSize;
	bool m_fBold;
	bool m_fItalic;
	bool m_fRtl;
	bool m_directionDepth;
};


#endif // !HWTXTSRC_INCLUDED
