/*
 * Decompiled with CFR 0.152.
 */
package de.calcom.applet.help;

import de.calcom.cclib.help.JavaHelpTOCReader;
import de.calcom.cclib.tree.SimpleTree;
import de.calcom.cclib.tree.event.SimpleTreeEvent;
import de.calcom.cclib.tree.event.SimpleTreeListener;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.ScrollPane;
import java.net.URL;

public class JavaHelpTOC
extends Applet {
    boolean isStandalone = false;
    String mapFileName;
    String tocFileName;
    String targetFrame;
    String currentUrl = "";
    ScrollPane scrollPane = new ScrollPane();
    SimpleTree tree;
    BorderLayout borderLayout1 = new BorderLayout();

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public void init() {
        try {
            this.mapFileName = this.getParameter("mapFileName", "map.jhm");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.tocFileName = this.getParameter("tocFileName", "toc.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.targetFrame = this.getParameter("targetFrame", "main");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.tree = new SimpleTree(this.getCodeBase());
        this.tree.addSimpleTreeListener(new MySimpleTreeListener());
        JavaHelpTOCReader jhtr = new JavaHelpTOCReader();
        jhtr.read(this.getDocumentBase(), this.tree, this.tocFileName, this.mapFileName);
        this.scrollPane.add(this.tree);
        this.scrollPane.getVAdjustable().setUnitIncrement(12);
        this.scrollPane.getHAdjustable().setUnitIncrement(10);
        this.add((Component)this.scrollPane, "Center");
    }

    public void start() {
        this.scrollPane.validate();
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        String aInfo = "JavaHelpTOC.\r\n";
        aInfo = String.valueOf(String.valueOf(aInfo)).concat("An applet to display a table of contents tree from \r\n");
        aInfo = String.valueOf(String.valueOf(aInfo)).concat("a map file and toc file both in JavaHelp format.\r\n\r\n");
        aInfo = String.valueOf(String.valueOf(aInfo)).concat("Copyright (c) 2001 CalCom, http://www.calcom.de");
        return aInfo;
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"mapFileName", "String", "name and relative path of map file"}, {"tocFileName", "String", "name and relative path of toc file"}, {"targetFrame", "String", "name of browser frame to display choices"}};
        return pinfo;
    }

    protected class MySimpleTreeListener
    implements SimpleTreeListener {
        protected MySimpleTreeListener() {
        }

        public void nodeChanged(SimpleTreeEvent e) {
            JavaHelpTOC.this.scrollPane.validate();
        }

        public void nodeInserted(SimpleTreeEvent e) {
            JavaHelpTOC.this.scrollPane.validate();
        }

        public void nodeRemoved(SimpleTreeEvent e) {
            JavaHelpTOC.this.scrollPane.validate();
        }

        public void selectionChanged(SimpleTreeEvent e) {
            try {
                String urlStr = JavaHelpTOC.this.getDocumentBase().toString();
                urlStr = urlStr.substring(0, urlStr.lastIndexOf("/") + 1);
                String nodeUrl = (String)e.getAffectedNode().getData();
                int pathEnd = JavaHelpTOC.this.tocFileName.lastIndexOf("/");
                if (pathEnd > -1) {
                    urlStr = String.valueOf(String.valueOf(urlStr)).concat(String.valueOf(String.valueOf(JavaHelpTOC.this.tocFileName.substring(0, pathEnd + 1))));
                }
                if (!(urlStr = String.valueOf(String.valueOf(urlStr)).concat(String.valueOf(String.valueOf(nodeUrl)))).equals(JavaHelpTOC.this.currentUrl) && !JavaHelpTOC.this.tree.getSelectedNode().isRoot()) {
                    JavaHelpTOC.this.getAppletContext().showDocument(new URL(urlStr), JavaHelpTOC.this.targetFrame);
                    JavaHelpTOC.this.currentUrl = urlStr;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void nodeExpansionChanged(SimpleTreeEvent e) {
            Point sPos = JavaHelpTOC.this.scrollPane.getScrollPosition();
            JavaHelpTOC.this.scrollPane.setScrollPosition(0, JavaHelpTOC.this.tree.getPreferredSize().height);
            JavaHelpTOC.this.scrollPane.setScrollPosition(sPos);
            JavaHelpTOC.this.scrollPane.validate();
        }
    }
}

