#!/usr/bin/perl -w
# This code is a part of Slash, and is released under the GPL.
# Copyright 1997-2001 by Open Source Development Network. See README
# and COPYING for more information, or see http://slashcode.com/.
# $Id: fz.pl,v 1.1.2.4 2001/10/22 17:34:00 pudge Exp $

# note: requires, for now, Mozilla 0.9 (not Mozilla 0.9.1!) and
# ForumZilla 0.3.1.  See http://forumzilla.mozdev.org/.

use strict;
use Slash 2.001;	# require Slash 2.1
use Slash::Display;
use Slash::Utility;
use Slash::XML;
use vars qw($VERSION);

($VERSION) = ' $Revision: 1.1.2.4 $ ' =~ /\$Revision:\s+([^\s]+)/;

use constant ALLOWED	=> 0;
use constant FUNCTION	=> 1;

sub main {
 	my $slashdb   = getCurrentDB(); #getObject('Slash::ForumZilla');
	my $constants = getCurrentStatic();
	my $user      = getCurrentUser();
	my $form      = getCurrentForm();

	# possible value of "op" parameter in form
	my %ops = (
		ad		=> [ 1,		\&fzDispAd	],
		navbar		=> [ 1,		\&fzDispNavbar  ],

		forum		=> [ 1,		\&fzForum	],
		describeStory	=> [ 1,		\&fzStory	],
		displayStory	=> [ 1,		\&fzDispStory	],
		displayComment	=> [ 1,		\&fzDispComment	],

		default		=> [ 1,		\&fzForum	]
	);

	$user->{commentsort} = 0;
	# ack, make sure mode isn't archive ?
	$user->{mode} = 'thread';
	$user->{threshold} = -1;

	# prepare op to proper value if bad value given
	my $op = $form->{op};
	if (!$op || !exists $ops{$op} || !$ops{$op}[ALLOWED]) {
		$op = 'default';
	}

	# dispatch of op
	$ops{$op}[FUNCTION]->($slashdb, $constants, $user, $form);

	# writeLog('SOME DATA');	# if appropriate
}

sub fzForum {
	my($slashdb, $constants, $user, $form) = @_;
	my $stories = $slashdb->fzGetStories($form->{section});

	xmlDisplay('fz', {
		stories => $stories,
		section	=> $form->{section},
		type	=> 'forum',
	});
}

sub fzStory {
	my($slashdb, $constants, $user, $form) = @_;
	$user->{state}{noreparent} = 1;
	my($comments) = Slash::selectComments(
		$slashdb->getDiscussionBySid($form->{sid})
	);

	xmlDisplay('fz', {
		# move to plugin eventually, probably
		comments => $comments,
		sid      => $form->{sid},
		section	 => $form->{section},
		type	 => 'story',
	});
}

sub fzDispStory {
	my($slashdb, $constants, $user, $form) = @_;

	header();
	my($data, $story) = displayStory($form->{sid}, 'Full');
	print $data;

	$user->{state}{nocomment} = 1;
	my $discussion = $slashdb->getDiscussionBySid($form->{sid});
	printComments($discussion);

	footer();
}

sub fzDispComment {
	my($slashdb, $constants, $user, $form) = @_;
	$user->{state}{noreparent} = 1;
	my($comments) = Slash::selectComments(
		$slashdb->getDiscussionBySid($form->{sid})
	);

	header();
	print dispComment($comments->{$form->{cid}});
	footer();
}

sub fzDispAd {
	my($slashdb, $constants, $user, $form) = @_;
	$user->{is_admin} = 0;
	
	header('Advertisement');
	print getAd();
	footer();
}

sub fzDispNavbar {
	my($slashdb, $constants, $user, $form) = @_;
	$user->{is_admin} = 0;
	
	header();
	slashDisplay('mainmenu');
	footer();
}

createEnvironment();
main();
1;
