#include "petscsys.h"
#include "petscfix.h"
#include "private/fortranimpl.h"
/* qepsolve.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepcqep.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define qepsolve_ QEPSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define qepsolve_ qepsolve
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define qepgetiterationnumber_ QEPGETITERATIONNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define qepgetiterationnumber_ qepgetiterationnumber
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define qepgetconverged_ QEPGETCONVERGED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define qepgetconverged_ qepgetconverged
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define qepgeteigenpair_ QEPGETEIGENPAIR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define qepgeteigenpair_ qepgeteigenpair
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define qepgeterrorestimate_ QEPGETERRORESTIMATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define qepgeterrorestimate_ qepgeterrorestimate
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define qepcomputeresidualnorm_ QEPCOMPUTERESIDUALNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define qepcomputeresidualnorm_ qepcomputeresidualnorm
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define qepcomputerelativeerror_ QEPCOMPUTERELATIVEERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define qepcomputerelativeerror_ qepcomputerelativeerror
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define qepsorteigenvalues_ QEPSORTEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define qepsorteigenvalues_ qepsorteigenvalues
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define qepsorteigenvaluesreal_ QEPSORTEIGENVALUESREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define qepsorteigenvaluesreal_ qepsorteigenvaluesreal
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define qepcompareeigenvalues_ QEPCOMPAREEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define qepcompareeigenvalues_ qepcompareeigenvalues
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define qepgetoperationcounters_ QEPGETOPERATIONCOUNTERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define qepgetoperationcounters_ qepgetoperationcounters
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  qepsolve_(QEP *qep, int *__ierr ){
*__ierr = QEPSolve(*qep);
}
void PETSC_STDCALL  qepgetiterationnumber_(QEP *qep,PetscInt *its, int *__ierr ){
*__ierr = QEPGetIterationNumber(*qep,its);
}
void PETSC_STDCALL  qepgetconverged_(QEP *qep,PetscInt *nconv, int *__ierr ){
*__ierr = QEPGetConverged(*qep,nconv);
}
void PETSC_STDCALL  qepgeteigenpair_(QEP *qep,PetscInt *i,PetscScalar *eigr,PetscScalar *eigi,Vec Vr,Vec Vi, int *__ierr ){
*__ierr = QEPGetEigenpair(*qep,*i,eigr,eigi,
	(Vec)PetscToPointer((Vr) ),
	(Vec)PetscToPointer((Vi) ));
}
void PETSC_STDCALL  qepgeterrorestimate_(QEP *qep,PetscInt *i,PetscReal *errest, int *__ierr ){
*__ierr = QEPGetErrorEstimate(*qep,*i,errest);
}
void PETSC_STDCALL  qepcomputeresidualnorm_(QEP *qep,PetscInt *i,PetscReal *norm, int *__ierr ){
*__ierr = QEPComputeResidualNorm(*qep,*i,norm);
}
void PETSC_STDCALL  qepcomputerelativeerror_(QEP *qep,PetscInt *i,PetscReal *error, int *__ierr ){
*__ierr = QEPComputeRelativeError(*qep,*i,error);
}
void PETSC_STDCALL  qepsorteigenvalues_(QEP *qep,PetscInt *n,PetscScalar *eigr,PetscScalar *eigi,PetscInt *perm, int *__ierr ){
*__ierr = QEPSortEigenvalues(*qep,*n,eigr,eigi,perm);
}
void PETSC_STDCALL  qepsorteigenvaluesreal_(QEP *qep,PetscInt *n,PetscReal *eig,PetscInt *perm, int *__ierr ){
*__ierr = QEPSortEigenvaluesReal(*qep,*n,eig,perm);
}
void PETSC_STDCALL  qepcompareeigenvalues_(QEP *qep,PetscScalar *ar,PetscScalar *ai,PetscScalar *br,PetscScalar *bi,PetscInt *result, int *__ierr ){
*__ierr = QEPCompareEigenvalues(*qep,*ar,*ai,*br,*bi,result);
}
void PETSC_STDCALL  qepgetoperationcounters_(QEP *qep,PetscInt* matvecs,PetscInt* dots,PetscInt* lits, int *__ierr ){
*__ierr = QEPGetOperationCounters(*qep,matvecs,dots,lits);
}
#if defined(__cplusplus)
}
#endif
